/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#include "SimpleTapStateMachine.h"

#ifdef __cplusplus
    #include <stdint.h>
    #include <algorithm>
#endif

typedef struct
{
	unsigned count			: 24; // 24-bits of count at destination state
	unsigned gotostate		: 4;  // 4-bits of destination state
	unsigned usetdi			: 1;  // 1-bit of use TDI that follows  (shift state)
	unsigned capturetdo		: 1;  // 1-bit of collect TDO (shift state)
	unsigned triggerstall	: 1;  // 1-bit of triggerstall (non-shift, stable state)
	unsigned metaop			: 1;  // 1-bit indicates a metaoperation (vs a scan)

#ifdef __cplusplus
	operator uint32_t()
	{
        uint32_t temp;
        const uint8_t* src = reinterpret_cast<uint8_t*>(this);
        std::copy(src, src + sizeof(temp), reinterpret_cast<uint8_t*>(&temp));
        return temp;
	}
#endif
} JtagDwordEncode;





