/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once
#ifdef __cplusplus
    #include <stdint.h>
    #include <algorithm>
#endif

enum MetaOpTypeEncode
{
	Hold				= 0x00, // lock-down/release interfaces that are accessed
	Wait				= 0x01,	// realtime wait for some period of time ('start = 1' only)
	//LoopCaptureAll		= 0x02,	// set up a loop, and for each read operation capture everything
	//LoopCaptureLast		= 0x03,	// set up a loop, and only capture read data for last loop
	//Compare				= 0x04,	// define what to compare (of read data)
	//Loopback			= 0x05, // perform a read-2-write loopback (only for scan protocols, like JTAG, which support that)
	//Save				= 0x06,	// define what to save (of read data)
	//Restore				= 0x07,	// restore previsouly saved read data
};

typedef struct
{
	unsigned count			: 24; // 24-bits of count at destination state
	unsigned optype			: 6;  // 6-bits of metaop type encoding
	unsigned start			: 1;  // 1-bit indicates the start of a metaop (vs end)
	unsigned metaop			: 1;  // 1-bit indicates a metaoperation (vs a scan)

#ifdef __cplusplus
    operator uint32_t()
	{
		uint32_t temp;
        const uint8_t* src = reinterpret_cast<uint8_t*>(this);
        std::copy(src, src + sizeof(temp), reinterpret_cast<uint8_t*>(&temp));
		return temp;
	}
#endif
} MetaOpDwordEncode;





