/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#pragma once

#ifdef __cplusplus
    #include <stdint.h>
    #include <algorithm>
#endif

typedef struct
{
	unsigned count			: 20; // 20-bits of 10ns delay after operation, or width of pulse (0-1,000,000) (For values larger than 1,000,000, see largeCount description)
	unsigned operation		: 4;  // 4-bits of encoded operation selection (see PinsOperationEncode enum below)
    unsigned largeCount     : 1;  // 1-bit when this bit is set, count represents a value larger than 20 bits and should be shifted left 12 bits.
	unsigned reserved		: 6;  // 6-bits undefined, reserved for future use
	unsigned metaop			: 1;  // 1-bit indicates a metaoperation (vs a scan)

#ifdef __cplusplus
    operator uint32_t()
	{
        uint32_t temp;
        const uint8_t* src = reinterpret_cast<uint8_t*>(this);
        std::copy(src, src + sizeof(temp), reinterpret_cast<uint8_t*>(&temp));
        return temp;
	}
#endif
} PinsDwordEncode;

// This returns the value of count after taking into account if the value should be shifted left or not.
#define GET_COUNT_VALUE(pinsEncode) ((pinsEncode).largeCount == 0 ? (pinsEncode).count : (pinsEncode).count << 12)

// this enumeration represents the bit position in the 64-bits that follow each pin header.
enum PinTypeEncode
{
	Pin_Hook0			= 0x00,
	Pin_Hook1			= 0x01,
	Pin_Hook2			= 0x02,
	Pin_Hook3			= 0x03,
	Pin_Hook4			= 0x04,	// no such thing on XDP debug port (probably deprecated PRdy)
	Pin_Hook5			= 0x05,	// no such thing on XDP debug port (probably deprecated PReq)
	Pin_Hook6			= 0x06,
	Pin_Hook7			= 0x07,
	Pin_ResetOccurred	= 0x08,
	Pin_DBR				= 0x09,
	Pin_PREQ			= 0x0A,
	Pin_PRDY			= 0x0B,
	Pin_PWRGOOD			= 0x0C,
	Pin_TRSTn			= 0x0D,
	Pin_obsA_func0		= 0x0E,
	Pin_obsA_func1		= 0x0F,
	Pin_obsB_func0		= 0x10,
	Pin_obsB_func1		= 0x11,
	Pin_obsC_func0		= 0x12,
	Pin_obsC_func1		= 0x13,
	Pin_obsD_func0		= 0x14,
	Pin_obsD_func1		= 0x15,
	Pin_obsA_data0		= 0x16,
	Pin_obsA_data1		= 0x17,
	Pin_obsA_data2		= 0x18,
	Pin_obsA_data3		= 0x19,
	Pin_obsB_data0		= 0x1A,
	Pin_obsB_data1		= 0x1B,
	Pin_obsB_data2		= 0x1C,
	Pin_obsB_data3		= 0x1D,
	Pin_obsC_data0		= 0x1E,
	Pin_obsC_data1		= 0x1F,
	Pin_obsC_data2		= 0x20,
	Pin_obsC_data3		= 0x21,
	Pin_obsD_data0		= 0x22,
	Pin_obsD_data1		= 0x23,
	Pin_obsD_data2		= 0x24,
	Pin_obsD_data3		= 0x25,
	Pin_Hook8           = 0x26,
	Pin_Hook9           = 0x27,
	// add sync and LA signals?
	// add 'meta' pins (i.e., for multisocket PReq drive)?
	// add the debug port interface pins (JTAG, I2C, etc.)?
};
// this enum describes the operation values
enum PinsOperationEncode
{
	pinsWriteAsserted = 0,
	pinsWriteDeAsserted = 1,
	pinsRead = 2,
    pinsPulse = 3,  // Need to get rid of this - only DCI uses it
                    // and it needs to update pinspulse to use the
                    // below since pin can be pulsed from low to
                    // high or visa versa
	pinsPulseAsserted = 4,
    pinsPulseDeAsserted = 5,
	// future possibilities
	//	pinsReadOccurred = 4,
	//	pinsReadResetOccurred = 5,
	//	pinsWaitAsserted = 6,
	//	pinsWaitDeAsserted = 7,
};

