//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel'ss
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#pragma once

#include <Foundation/Error/Error.h>

#define PROBE_PLUGIN_ERRORS \
ERRORDEF(Plugin_Is_Not_Initialized,                 1,  "The plugin should be initialized before this operation is attempted") \
ERRORDEF(Probe_Bundle_Invalid,                      2,  "The probe bundle handle is not valid") \
ERRORDEF(Probe_Bundle_Invalid_Handle,               3,  "The probe bundle handle has already been executed, so no new commands can be added") \
ERRORDEF(Probe_Bundle_Invalid_Slot,                 4,  "The probe bundle handle does not have the indicated slot") \
ERRORDEF(Probe_Invalid_JTAG_Device,                 5,  "The device given is not a JTAG device.") \
ERRORDEF(Probe_Invalid_Parameter,                   6,  "A parameters value is invalid.")\
ERRORDEF(Probe_Invalid_Size,                        7,  "A parameter's size is insufficient to handle the output.")\
ERRORDEF(Plugin_Not_Initialized,                    8,  "Unable to initialize the plug-in") \
ERRORDEF(Probe_Not_Initialized,                     9,  "Unable to initialize the probe") \
ERRORDEF(Interface_Not_Initialized,                 10, "Unable to initialize the interface") \
ERRORDEF(Interface_Not_Supported,                   11, "The requested interface is not supported by this probe type") \
ERRORDEF(Plugin_Not_Found,                          12, "No probe plugin could be found") \
ERRORDEF(Writeback_Size_Mismatch,                   13, "The probe API returned an unexpected amount of read data (or none at all)") \
ERRORDEF(Probe_Request_Timeout,                     14, "A request to the probe has timed out") \
ERRORDEF(Probe_Config_file,                         15, "A file used to configure the probe was not found") \
ERRORDEF(Plugin_Already_Initialized,                16, "Plug-in is already initialized") \
ERRORDEF(Probe_Already_Initialized,                 17, "Probe is already initialized") \
ERRORDEF(Interface_Already_Initialized,             18, "Interface is already initialized") \
ERRORDEF(Callback_Already_Initialized,	            19, "Callback being registered more than once") \
ERRORDEF(Interface_Jtag_Boundary_Scan_Timeout,      20, "Jtag Boundary Scan Timeout occurred") \
ERRORDEF(Interface_Jtag_Mark_Return,                21, "Jtag Mark and Return error occurred") \
ERRORDEF(Interface_Jtag_Tdi_Fill,                   22, "Jtag TDI Fill error occurred") \
ERRORDEF(Interface_Jtag_Save,                       23, "Jtag Save error occurred") \
ERRORDEF(Interface_Jtag_Restore,                    24, "Jtag Restore error occurred") \
ERRORDEF(Interface_I2c_Arbitration_Loss,            25, "I2c Arbitration Loss error occurred") \
ERRORDEF(Interface_I2c_Nack_Before_Length_Complete, 26, "I2c Nack before Length Complete error occurred") \
ERRORDEF(Interface_I2c_Retry_Failed,                27, "I2c Retry failed") \
ERRORDEF(Interface_I2c_Nack_At_Address_Phase,       28, "I2c Nack at Address Phase or Last Write Data") \
ERRORDEF(Interface_I2c_Fifo_Empty,                  29, "I2c FIFO empty before scan complete") \
ERRORDEF(Interface_I2c_Sda_Wire_Stuck_Low,          30, "I2c SDA Wire Stuck Low") \
ERRORDEF(Interface_I2c_Sda_Wire_Stuck_High,         31, "I2c SDA Wire Stuck High") \
ERRORDEF(Interface_Jtag,                            32, "Jtag Error Occurred") \
ERRORDEF(Interface_I2c,                             33, "I2c Error Occurred") \
ERRORDEF(Interface_Obs,                             34, "Obs Error Occurred") \
ERRORDEF(Probe_Config_Undefined,                    35, "Probe Config is Undefined") \
ERRORDEF(Interface_Pins,                            36, "Pins Interface error occurred") \
ERRORDEF(Interface_Pins_Operation_Not_Supported,    37, "Pin Operation is Not Supported") \
ERRORDEF(Interface_Pins_Pin_Not_Supported,          38, "Pin is Not Supported") \
ERRORDEF(Interface_PortAccessMode_Not_Supported,    39, "Port does not support the configured access mode") \
ERRORDEF(Interface_Port_Operation_Failed,           40, "Port operation failed") \
ERRORDEF(Interface_Port_Operation_Invalid,          41, "Port operation invalid") \
ERRORDEF(Plugin_Implementer_Defined,                42, "") \
ERRORDEF(Operation_Not_Supported,                   43, "Operation is not supported") \
ERRORDEF(Target_Not_Available,                      44, "Target is powered down or otherwise not available") \
ERRORDEF(Remote_Connection_Server_Lost,             45, "Remote Connection was lost to the server") \
ERRORDEF(Remote_Connection_Client_Lost,             46, "Remote Connection was lost to the client") \
ERRORDEF(Remote_Connection_Unable_To_Connect,       47, "Remote Connection was unable to connect to the server") \
ERRORDEF(Remote_Connection_Unable_To_Listen,        48, "Remote Connection was unable to listen for a client") \
ERRORDEF(Remote_Connection_Already_Connected,       49, "Remote Connection was unable to connect; it is already connected") \
ERRORDEF(Remote_Connection_Unable_To_Send,          50, "Remote Connection was unable to send") \
ERRORDEF(Remote_Connection_Not_Connected,           51, "Remote Connection is not connected") \
ERRORDEF(Remote_Plugin_Rpc_Fatal_Invalid_Magic_Number,              52, "Message with an invalid magic number was received") \
ERRORDEF(Remote_Plugin_Rpc_Fatal_Handshake_Already_In_Progress,     53, "Connection handshake was already in progress") \
ERRORDEF(Remote_Plugin_Rpc_Fatal_Negeotiation_Not_Accpeted,         54, "Negeotiation not accepted at connect") \
ERRORDEF(Remote_Plugin_Rpc_Fatal_Server_Version_Not_Compatible,     55, "Server and client versions not compatible") \
ERRORDEF(Remote_Plugin_Rpc_Fatal_Token_Required_At_Connect,         56, "Token required at connect") \
ERRORDEF(Remote_Plugin_Rpc_Fatal_Invalid_Payload_Size,              57, "Invalid payload size for message encountered") \
ERRORDEF(Remote_Plugin_Rpc_Fatal_Out_Of_Sequence,                   58, "Invalid message sequence") \

#define ERRORDEF(name, value, string) ERROR_ENUM(ProbePlugin, name, value)
enum { PROBE_PLUGIN_ERRORS };
#undef ERRORDEF
