/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#if defined(HOST_WINDOWS)
#   if defined(LOGGING_EXPORTS)
#       define EXPORT_LOGGING_API __declspec(dllexport)
#   else
#       define EXPORT_LOGGING_API __declspec(dllimport)
#   endif
#else
#   define EXPORT_LOGGING_API __attribute__ ((visibility("default")))
#endif

#include "LoggingTypes.h"

static const uint32_t OpenIPC_LOGGING_MAX_PRESET_NAME_LENGTH = 256;
static const uint32_t OpenIPC_LOGGING_MAX_SINK_TARGET_NAME_LENGTH = 256;

typedef void (*OpenIPC_LoggingReceiveMessageCallback)(void* data, OpenIPC_LoggingSeverityLevel severity, const char* message);
typedef void (*OpenIPC_LoggingSeverityLevelChangedCallback)(void* data, OpenIPC_LoggingSeverityLevel severity);
typedef void (*OpenIPC_LoggingOnPresetChangedCallback)(const char* presetName);

extern "C"
{
	EXPORT_LOGGING_API bool OpenIPC_LoggingInitializeLogging(const char* suffix);

    EXPORT_LOGGING_API bool OpenIPC_LoggingUninitializeLogging();

	EXPORT_LOGGING_API void OpenIPC_LoggingAddSyslogSink(const char* address, const uint16_t port, const char** sinkTargets, uint32_t numberOfSinkTargets, bool shortFormatter);

	EXPORT_LOGGING_API void OpenIPC_LoggingAddConsoleSink(const char** sinkTargets, uint32_t numberOfSinkTargets);

	EXPORT_LOGGING_API void OpenIPC_LoggingAddFileSink(const char* filePath, const char* fileName, uint32_t rolloverSize, uint32_t maxSize, const char** sinkTargets, uint32_t numberOfSinkTargets, bool shortFormatter);

	EXPORT_LOGGING_API void OpenIPC_LoggingSetLoggerLevel(const char* name, OpenIPC_LoggingSeverityLevel desiredSeverity);

	EXPORT_LOGGING_API void OpenIPC_LoggingSetLoggerSinkTargets(const char* name, const char** sinkTargets, uint32_t numSinkTargets);

	EXPORT_LOGGING_API OpenIPC_LoggingToken OpenIPC_LoggingGetLogger(OpenIPC_LoggingLoggerId loggerId);

	EXPORT_LOGGING_API bool OpenIPC_LoggingIsLogEnabled(OpenIPC_LoggingToken token, OpenIPC_LoggingSeverityLevel desiredSeverity);

	// Sets whether logging is supressed on the current thread
	EXPORT_LOGGING_API void OpenIPC_LoggingSuppressLogging(bool suppressed);

	EXPORT_LOGGING_API bool OpenIPC_LoggingIsLoggingSuppressed();

	EXPORT_LOGGING_API OpenIPC_LoggingSeverityLevel OpenIPC_LoggingGetLogSeverityLevel(OpenIPC_LoggingToken token);

	EXPORT_LOGGING_API void OpenIPC_LoggingGetLogSinkTargets(OpenIPC_LoggingToken token, char(*sinkTargets)[OpenIPC_LOGGING_MAX_SINK_TARGET_NAME_LENGTH], uint32_t maxSinks, uint32_t* numSinks);

	EXPORT_LOGGING_API void OpenIPC_LoggingSetLogSeverityLevel(OpenIPC_LoggingToken token, OpenIPC_LoggingSeverityLevel value);

	EXPORT_LOGGING_API void OpenIPC_LoggingSetLogSinkTargets(OpenIPC_LoggingToken token, const char** sinkTargets, uint32_t numSinks);

	EXPORT_LOGGING_API void OpenIPC_LoggingPushLogSeverityLevels();

	EXPORT_LOGGING_API void OpenIPC_LoggingPopLogSeverityLevels();

	EXPORT_LOGGING_API void OpenIPC_LoggingLog(OpenIPC_LoggingToken token, OpenIPC_LoggingSeverityLevel desiredSeverity, const char* message, int indent);

	EXPORT_LOGGING_API bool OpenIPC_LoggingIsLoggingUsage();

	EXPORT_LOGGING_API void OpenIPC_LoggingLogUsage(const char* componentName, const char* eventName, const char* message);

	EXPORT_LOGGING_API void OpenIPC_LoggingCreateLoggingPreset(const char* presetName);

	EXPORT_LOGGING_API void OpenIPC_LoggingGetLoggingPresetNamesCount(uint32_t* numPresetNames);

	EXPORT_LOGGING_API void OpenIPC_LoggingGetLoggingPresetNames(char (*presetNames)[OpenIPC_LOGGING_MAX_PRESET_NAME_LENGTH], uint32_t numPresetNames);

	EXPORT_LOGGING_API bool OpenIPC_LoggingLoadLoggingPreset(const char* presetName);

	EXPORT_LOGGING_API void OpenIPC_LoggingGetLoadedLoggingPreset(char presetName[OpenIPC_LOGGING_MAX_PRESET_NAME_LENGTH]);

	EXPORT_LOGGING_API bool OpenIPC_LoggingAddOnPresetChangedCallback(OpenIPC_LoggingOnPresetChangedCallback callback);

	EXPORT_LOGGING_API bool OpenIPC_LoggingRemoveOnPresetChangedCallback(OpenIPC_LoggingOnPresetChangedCallback callback);

	EXPORT_LOGGING_API bool OpenIPC_LoggingSetPresetLoggerLevel(const char* presetName, const char* loggerName, OpenIPC_LoggingSeverityLevel desiredSeverity, const char** sinkTargets, uint32_t numSinkTargets);

	EXPORT_LOGGING_API void OpenIPC_LoggingAddListener(OpenIPC_LoggingToken token, void* data, OpenIPC_LoggingReceiveMessageCallback receiveMessageCallback, OpenIPC_LoggingSeverityLevelChangedCallback severityLevelChangedCallback);

	EXPORT_LOGGING_API void OpenIPC_LoggingRemoveListener(OpenIPC_LoggingToken token, void* data, OpenIPC_LoggingReceiveMessageCallback receiveMessageCallback, OpenIPC_LoggingSeverityLevelChangedCallback severityLevelChangedCallback);

	EXPORT_LOGGING_API void OpenIPC_LoggingLock();

    EXPORT_LOGGING_API void OpenIPC_LoggingUnlock();

    EXPORT_LOGGING_API bool OpenIPC_LoggingClearLogs();

    EXPORT_LOGGING_API bool OpenIPC_LoggingArchiveLogs();

    EXPORT_LOGGING_API const char* OpenIPC_LoggingGetLastErrorMessage();

};
