/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#include "LoggingTypes.h"

#include <iomanip>

#define OpenIPC_LOG(LOGGER, SEVERITY, FUNC) if ((LOGGER)->IsLogEnabled(SEVERITY)) { (LOGGER)->Log(SEVERITY, [&](std::basic_ostream<char>& stream) { stream << FUNC << ""; }); }

#define OpenIPC_LOG_FUNC(LOGGER, SEVERITY, FUNC) if ((LOGGER)->IsLogEnabled(SEVERITY)) { (LOGGER)->Log(SEVERITY, FUNC); }

#define OpenIPC_LOG_USAGE(COMPONENT, EVENT, FUNC) if (OpenIPC_LoggingIsLoggingUsage()) { auto fn = [&](std::basic_ostream<char>& stream) \
    { \
        stream << FUNC << ""; \
	}; \
	std::stringstream stream; \
	fn(stream); \
	OpenIPC_LoggingLogUsage(OpenIPC_Logger::GetLoggerName(COMPONENT), EVENT, stream.str().c_str() ); }

#define LOG_UINT8_HEX(X) "0x" << (std::hex) << std::setfill('0') << std::setw(2) << static_cast<uint32_t>(X)
#define LOG_UINT16_HEX(X) "0x" << (std::hex) << std::setfill('0') << std::setw(4) << (X)
#define LOG_UINT32_HEX(X) "0x" << (std::hex) << std::setfill('0') << std::setw(8) << (X)
#define LOG_UINT64_HEX(X) "0x" << (std::hex) << std::setfill('0') << std::setw(16) << (X)

#define LOG_UINT8_DEC(X) (std::dec) << static_cast<uint32_t>(X)
#define LOG_UINT16_DEC(X) (std::dec) << (X)
#define LOG_UINT32_DEC(X) (std::dec) << (X)
#define LOG_UINT64_DEC(X) (std::dec) << (X)

#define LOG_INT8_HEX(X) "0x" << (std::hex) << std::setfill('0') << std::setw(2) << static_cast<int32_t>(X)
#define LOG_INT16_HEX(X) "0x" << (std::hex) << std::setfill('0') << std::setw(4) << (X)
#define LOG_INT32_HEX(X) "0x" << (std::hex) << std::setfill('0') << std::setw(8) << (X)
#define LOG_INT64_HEX(X) "0x" << (std::hex) << std::setfill('0') << std::setw(16) << (X)

#define LOG_INT8_DEC(X) (std::dec) << static_cast<int32_t>(X)
#define LOG_INT16_DEC(X) (std::dec) << (X)
#define LOG_INT32_DEC(X) (std::dec) << (X)
#define LOG_INT64_DEC(X) (std::dec) << (X)

#define LOG_STRING(X) ""; if (X == NULL) { stream << "<NULL>"; } else { stream << "'" << X << "'"; } stream << ""

#define LOG_BOOL(X) (X ? "True" : "False")

#define LOG_UINT8_ARRAY(X, SIZE) ""; \
	if ((X) == NULL) \
	{ \
		stream << "<NULL>"; \
	} \
	else if ((SIZE) == 0) \
	{ \
		stream << "<EMPTY>"; \
	} \
	else \
	{ \
		stream << "{"; \
		\
		for (size_t i = 0; i < size_t((SIZE)) - 1; ++i) \
		{ \
			stream << LOG_UINT8_HEX(reinterpret_cast<const uint8_t*>(X)[i]) << ", "; \
		} \
		\
		stream << LOG_UINT8_HEX(reinterpret_cast<const uint8_t*>(X)[(SIZE) - 1]); \
		\
		stream << "}"; \
	} \
	stream << ""

#define LOG_CONST_SIZE_UINT8_ARRAY(X, SIZE) ""; \
	if ((X) == NULL) \
	{ \
		stream << "<NULL>"; \
	} \
	else \
	{ \
        static_assert((SIZE) != 0, "The array size constant should not be 0"); \
		stream << "{"; \
		\
		for (size_t i = 0; i < size_t((SIZE)) - 1; ++i) \
		{ \
			stream << LOG_UINT8_HEX(reinterpret_cast<const uint8_t*>(X)[i]) << ", "; \
		} \
		\
		stream << LOG_UINT8_HEX(reinterpret_cast<const uint8_t*>(X)[(SIZE) - 1]); \
		\
		stream << "}"; \
	} \
	stream << ""

#define LOG_UINT16_ARRAY(X, SIZE) ""; \
	if ((X) == NULL) \
	{ \
		stream << "<NULL>"; \
	} \
	else if ((SIZE) == 0) \
	{ \
		stream << "<EMPTY>"; \
	} \
	else \
	{ \
		stream << "{"; \
		\
		for(size_t i = 0; i < size_t((SIZE)) - 1; ++i) \
		{ \
			stream << LOG_UINT16_HEX(reinterpret_cast<const uint16_t*>(X)[i]) << ", "; \
		} \
		\
		stream << LOG_UINT16_HEX(reinterpret_cast<const uint16_t*>(X)[(SIZE) - 1]); \
		\
		stream << "}"; \
	} \
	stream << ""

#define LOG_UINT32_ARRAY(X, SIZE) ""; \
	if ((X) == NULL) \
	{ \
		stream << "<NULL>"; \
	} \
	else if ((SIZE) == 0) \
	{ \
		stream << "<EMPTY>"; \
	} \
	else \
	{ \
		stream << "{"; \
		\
		for(size_t i = 0; i < size_t((SIZE)) - 1; ++i) \
		{ \
			stream << LOG_UINT32_HEX(reinterpret_cast<const uint32_t*>(X)[i]) << ", "; \
		} \
		\
		stream << LOG_UINT32_HEX(reinterpret_cast<const uint32_t*>(X)[(SIZE) - 1]); \
		\
		stream << "}"; \
	} \
	stream << ""

#define LOG_UINT64_ARRAY(X, SIZE) ""; \
	if ((X) == NULL) \
	{ \
		stream << "<NULL>"; \
	} \
	else if ((SIZE) == 0) \
	{ \
		stream << "<EMPTY>"; \
	} \
	else \
	{ \
		stream << "{"; \
		\
		for(size_t i = 0; i < size_t((SIZE)) - 1; ++i) \
		{ \
			stream << LOG_UINT64_HEX(reinterpret_cast<const uint64_t*>(X)[i]) << ", "; \
		} \
		\
		stream << LOG_UINT64_HEX(reinterpret_cast<const uint64_t*>(X)[(SIZE) - 1]); \
		\
		stream << "}"; \
	} \
	stream << ""

#define LOG_STRING_ARRAY(X, SIZE) ""; \
    if ((X) == NULL) \
    { \
        stream << "<NULL>"; \
    } \
    else if ((SIZE) == 0) \
    { \
        stream << "<EMPTY>"; \
    } \
    else \
    { \
        stream << "{"; \
 \
        for(size_t i = 0; i < size_t((SIZE)) - 1; ++i) \
        { \
            stream << LOG_STRING((X)[i]) << ", "; \
        } \
 \
        stream << LOG_STRING((X)[(SIZE) - 1]) << ""; \
        stream << "}"; \
    } \
 \
stream << ""

#define LOG_OpenIPC_BITDATA(X) ""; \
    if ((X) == NULL) \
    { \
        stream << "<NULL>"; \
    } \
    else if ((uint32_t)(((BitData*)(X))->bitsize) == 0) \
    { \
        stream << "<EMPTY>"; \
    } \
    else \
    { \
        uint32_t numBitDataChars = (uint32_t)((((BitData*)(X))->bitsize) >> 2) + 16; \
        std::vector<char> strBitData (numBitDataChars); \
		\
        BitData_ToHex((BitData*)(X), 0, ((BitData*)(X))->bitsize, &strBitData[0], numBitDataChars); \
        stream << (std::dec) << "["<< ((BitData*)(X))->bitsize <<"b]"; \
        stream << &strBitData[0];\
    } \
    \
    stream << ""

#define LOG_OpenIPC_INDEXLIST(X) ""; \
    if ((X) == NULL) \
    { \
        stream << "<NULL>"; \
    } \
    else if (IndexList_GetLength((IndexList*)(X)) == 0) \
    { \
        stream << "<EMPTY>"; \
    } \
    else \
    { \
        size_t size = IndexList_GetStringSize((IndexList*)(X)); \
        std::vector<char> buffer(size + 1); \
        IndexList_ToString((IndexList*)(X), &buffer[0], buffer.size()); \
        stream << &buffer[0]; \
    } \
    \
    stream << ""

#define LOG_NULLABLE(TEST, X) ""; if (TEST == NULL) { stream << "<NULL>"; } else { stream << X << ""; } stream << ""

#define LOG_TIMEOUT(X) ""; \
    if ((X) == IPC_TIMEOUT_INFINITE) \
    { \
        stream << "<INFINITE>"; \
    } \
    else \
    { \
        stream << LOG_UINT32_DEC(X); \
    } \
    stream << ""

#define LOG_POINTER(X) LOG_NULLABLE((X), LOG_UINT64_HEX(reinterpret_cast<uint64_t>(X)))
#define LOG_THIS_POINTER() LOG_UINT64_HEX(reinterpret_cast<uint64_t>(this))
