/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

/*!
\brief session ID string constants to be used with Telemetry

Telemetry sessions and events are orthogonal to the software architecture, so this file provides a
component-agnostic way to define and share the same session or event ID across the codebase, so that
multiple compnents can contribute to that session or event
*/

#pragma once

/*!
\brief This encapsulates the "OpenIPC launches with a specific set of parameters" scenario

It contains data related to the following:
 - configuration file used
 - client connection data
 - knobs that were tweaked

 Note that this is *not* the same as a "utilization" scenario
 */
#define Telemetry_Session_Server_Lifespan "Server_Lifespan"

/*!
\brief This encapsulates the idea of a "probe was detected, utilized, and then removed" scenario

It contains data related to the following:
 - probe type
 - probe parameters
 - scenario data, e.g. was a target detected at the time the probe was added

*/
#define Telemetry_Session_Probe_Lifespan "Probe_Lifespan"

/*!
\brief This encapsulates the idea of a "client attacches, uses, and then disconnects"

It contains data related to the following:
 - client ID
 - APIs utilized

*/
#define Telemetry_Session_Client_Lifespan "Client_Lifespan"


/*!
\brief This event is emitted when the server has initialized
*/
#define Telemetry_Event_Server_Init "Server_Initialization"

/*!
\brief This event is emitted when we detect that a previous instance didn't shut down cleanly
*/
#define Telemetry_Event_Server_Previous_Process_Killed "Server_Previous_Process_Killed"

/*!
\brief This event is emitted when the OpenIPC server fails to launch
*/
#define Telemetry_Event_ServerLaunch_Fail "Server_Launch_Fail"

/*!
\brief This event is emitted when the OpenIPC server exits cleanly
*/
#define Telemetry_Event_Server_Clean_Exit "Server_Clean_Exit"

/*!
\brief This event is emitted when the OpenIPC process crashes
*/
#define Telemetry_Event_Server_Crash "Server_Crash"

/*!
\brief This event is emitted when a probe has been added
*/
#define Telemetry_Event_ProbeInit "Probe_Init"

/*!
\brief This event is emitted when the targets "ExI Silicon ID" has changed

Note that this is discrete from the ProbeInit event because it could happen at an arbitrary time during a Probe's lifespan
*/
#define Telemetry_Event_ExiSiId_Changed "ExiSiId_Changed"

/*!
\brief This event is emitted when a topology update occurs
*/
#define Telemetry_Event_Topology_Update "Topology_Update"

/*!
\brief This event is emitted when one or more threads fail to halt
*/
#define Telemetry_Event_Halt_Failure "Halt_Failure"

/*!
\brief This event is emitted when a scanengine routine throws an error
*/
#define Telemetry_Event_ScanEngine_Error "ScanEngine_Error"

/*!
\brief This event is emitted when a client has connected
*/
#define Telemetry_Event_ClientConnect "Client_Connect"

/*!
\brief This event is emitted when we finish initialization (after that, no more client info can be set)
*/
#define Telemetry_Event_ClientInfo "Client_Info"

/*!
\brief This event is emitted when a client has disconnected
*/
#define Telemetry_Event_ClientDisconnect "Client_Disconnect"

/*!
\brief This event is emitted when a top level jtag device is detected during startup or forcereconfig
*/
#define Telemetry_Event_DetectedJtagDevice "DetectedJtagDevice"

/*!
\brief This event is emitted with the count of calls per IPC_API function
*/
#define Telemetry_Event_IPC_Call "IPC_Call"

/*!
\brief This event is emitted when an interesting Authorization event occurs
*/
#define Telemetry_Authorization_Status "Authorization_Status"

/*!
\brief This event is emitted when a feature is used and includes usage details
*/
#define Telemetry_Event_Feature_Message "Feature"