#!/bin/bash
#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008-2015 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

. ./testslib.sh
ParseTestArguments $@

Print " " 4
Print "NM PROCHOT# assertion" 4 34
Print " " 4

scriptError=0
suppressCmdError=0 # compCode from response will be located in 'errorCode' variable


SetProchotMgpio() {
  Print "Set GPIO Output State $1" 5 32
  SendDiagCmdProxy "0x06 0x05 0x9D 0x52 0x02 0x14 $1"
  if [ "$error" -eq 0 ]; then
    Print " Prochot set to: $1" 8
  fi
}

GetThrottlingStatus() {
  suppressCmdError=1
  SendRawPeci "$1 0x05 0x05 0xA1 0x00 0x14 0x00 0x00"
  cc=$errorCode
  suppressCmdError=0
  if [ $((0x$cc)) == $((0xAC)) ]; then
    Print " Cannot found CPU 0x$2." 4
    Print " " 4
    continue
  fi
  if [ "$cc" != "00" ]; then
    SetProchotMgpio "0x01"
    Print " Failed to check throttling status for CPU 0x$2" 0 31
    Print " " 0
    Print "TEST FAILED " 0 31
    exit 1
  fi
  arr=($rsp)
  throttlingStatus=${arr[4]}
}

ValidateThrottlingStatus() {
  if [ $(( $((0x$1)) & 0x04 )) != $((0x04)) ]; then
    Print " Throttling was not triggered for CPU 0x$2" 0 31
    scriptError=1
  fi 
}

#STEP 1
SetProchotMgpio "0x00"
#STEP 2
anyCpuPresented=0
for address in 0x30 0x31 0x32 0x33 0x34 0x35 0x36 0x37
  do
    cpuID=$(($address - 0x30))
    GetThrottlingStatus $address $cpuID
    anyCpuPresented=1
    ValidateThrottlingStatus $throttlingStatus $cpuID
  done
#STEP 3
if [ "$anyCpuPresented" -eq 0 ]; then
  SetProchotMgpio "0x01"
  Print " Cannot found any CPU" 0 31
  Print " " 0
  Print "TEST FAILED " 0 31
  scriptError=1
fi
#STEP 4
SetProchotMgpio "0x01"


if [ $scriptError -eq 1 ]; then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
    exit 0
fi

