#!/bin/bash
. ./testslib.sh

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008-2013 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

ParseTestArguments $@

Print " " 4
Print "Launch PTU On Next Boot" 4 34
Print " " 4

scriptError=0
suppressCmdError=1 # compCode from response will be located in 'errorCode' variable

NMPowerCharacterizationLaunchRequest "0x01 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00"
if [ "$errorCode" != "00" ]; then
  Print "Lunch PTU on Next Restart initialization failed." 4
  scriptError=1
fi

if [ $scriptError -eq 0 ]; then

  Print "Please restart your platform and wait for responding OS. Press enter after that" 0 33
  read enter

  for domain in 0 1 2 # available domains
    do
      Print "Domain: $domain" 5
      GetNMPowerCharacterizationRange "$domain"
      if [ "$errorCode" != "00" ]; then
        Print "Can not get response for domain $domain." 4
        scriptError=1
        break
        elif [ "$ts4$ts3$ts2$ts1" == "00000000" ] || [ "$ts4$ts3$ts2$ts1" == "ffffffff" ]; then
        Print "Incorrect timestamp value: 0x$ts1$ts2$ts3$ts4 for domain $domain." 4
        scriptError=1
        break
      fi
    done
fi


if [ $scriptError -eq 1 ]; then
  Print " " 0
  Print "TEST FAILED " 0 31
  Print " " 0
  exit 1
else
  Print " " 4
  Print "PTU works properly." 4
  Print " " 4
  Print "TEST PASSED " 4 32
  Print " " 4
fi