'================================================'
' Establish File Names & Initialize Variables    '
'================================================'
Cls
RxProm$ = "KyodoRx.Bin"
TxProm$ = "KyodoTx.Bin"
PLProm$ = "KyodoPL.Bin"

DIM byte%(30)
DIM PLTones#(38)
DIM Code$(2)
DIM PLCodes$(38)
DIM PLData$(255)

GoSub LoadArray
OPEN RxProm$ FOR BINARY AS #1
OPEN TxProm$ FOR BINARY AS #2
OPEN PLProm$ FOR BINARY AS #3
OPEN "Kyodo.Chn" FOR INPUT AS #4
'======================================================'
'1st 2 lines of file are Header/Comments.  Ignore them.'
'======================================================'
    LINE INPUT #4, channel$
    LINE INPUT #4, channel$
'======================================================'
'3rd line contains Column numbers. Ignore it.'
'4th line contains column headings.  Ignore them.'
'======================================================'
    LINE INPUT #4, channel$
    LINE INPUT #4, channel$
'======================================================'
' Clear input string to be ready for 1st channel       '
'======================================================'
    channel$ = ""

'======================================================'
' Read Input File, and Build Tx, Rx, and PL Prom Data  '
'======================================================'
WHILE NOT EOF(4)                             'Begin Read Loop'
    LINE INPUT #4, channel$                  'Read Next Channel Info'
    Ftx = VAL(MID$(channel$, 1, 7))          'Transmit Freq'
    Frx = VAL(MID$(channel$, 11, 7))         'Receive Freq'
    Channel% = VAL(MID$(channel$, 22, 3))    'Channel Number - Not used'
    FSpc = VAL(MID$(channel$, 37, 4))        'Channel Spacing'
    If (FSpc = 0) then
	FSpc = 10                            'Default to 10 kHz'
    End If
    PLEncode# = VAL(MID$(channel$, 50, 5))   'Encode PL'
    PLDecode# = VAL(MID$(channel$, 61, 5))   'Decode PL'
    Print Channel%,Ftx,Frx,FSpc
    GOSUB calc

    channel$ = ""                            'Cleanup for next channel'
WEND                                         'End Read Loop

'=============================================='
' Write End-of-Block Marker to EPROM files     '
'=============================================='
Put$ #1, CHR$(0,255,255)
Put$ #2, CHR$(0,255,255)

'=============================================='
'Write Out PLProm'
'=============================================='
For x = 1 to 255
 Put$ #3, PLData$(x)
Next x
'CLS

Print "Completed - Hit Any Key to Continue"
CLOSE
END
'=============================================='
'End of Main Program                           '
'=============================================='



'=============================================='
'Calculate VCO & PL Data for this channel      '
'=============================================='
calc:
	R% = 750/FSpc
	N = INT((Frx - 21600) / (FSpc * 64))   'Rx Data'
	A% = ((Frx - 21600) / FSpc) - (N * 64)
        k = 1
	GOSUB xdata

	N = INT(Ftx / (FSpc * 64))             'Tx Data'
	A% = (Ftx / FSpc) - (N * 64)
        k = 2
	GOSUB xdata
	offset = offset + 8

	PLFreq# = PLEncode#                    'PL Encode'
	PLOffset# = (Channel%)
	Gosub PLCalc

	PLFreq# = PLDecode#                    'PL Decode'
	PLOffset# = (Channel% + 128)
	Gosub PLCalc

RETURN
'=============================================='
'End of Channel Data                           '
'=============================================='



'=============================================='
'Convert Numeric values to Character (Hex)     '
'=============================================='
xdata:
	byte%(1) = A% MOD 16
        byte%(2) = A% \ 16

	temp% = N MOD 256
        byte%(3) = temp% MOD 16
        byte%(4) = temp% \ 16
        byte%(5) = N \ 256

        temp% = R% MOD 256
        byte%(6) = temp% MOD 16
        byte%(7) = temp% \ 16
        byte%(8) = R% \ 256
'=============================================='
'Write out 8 bytes of data to either Tx or Rx  '
'=============================================='
     Print R%,N,A%
	FOR i = 1 TO 8
		PUT$ #k, Chr$(byte%(i))
	NEXT
RETURN
'=============================================='


'=============================================='
'Convert PL Frequency to PL Eprom Data Code'
'=============================================='
PLCalc:
	J% = 0
	Array Scan PLTones#(), = PLFreq#, to J%
	PLData$(PLOffset#) = PLCodes$(J% - 1)
Return
'=============================================='


'=============================================='
'Load Arrays with PL Frequency & Hex Identifier'
'=============================================='
LoadArray:
For x = 1 to 38
	Read PLTones#(x), Code$
	PLCodes$(x) = Chr$(Val(Code$))
	I = Val(Code$)
Next x
Return
'=============================================='


'=============================================='
'PL Data Values. Frequency & Hex Identifier    '
'=============================================='
Data 67.0,&H3F
Data 71.9,&H3E
Data 74.4,&H1F
Data 77.0,&H3C
Data 79.7,&H2F
Data 82.5,&H1E
Data 85.4,&H0F
Data 88.5,&H1C
Data 91.5,&H37
Data 94.8,&H2E
Data 97.4,&H17
Data 100.0,&H2C
Data 103.5,&H0E
Data 107.2,&H0C
Data 110.9,&H36
Data 114.8,&H34
Data 118.8,&H16
Data 123.0,&H14
Data 127.3,&H26
Data 131.8,&H24
Data 136.5,&H06
Data 141.3,&H04
Data 146.2,&H3A
Data 151.4,&H38
Data 156.7,&H1A
Data 162.2,&H18
Data 167.9,&H2A
Data 173.8,&H28
Data 179.9,&H0A
Data 186.2,&H08
Data 192.8,&H32
Data 203.5,&H30
Data 210.7,&H12
Data 218.1,&H10
Data 225.7,&H22
Data 233.6,&H20
Data 241.8,&H02
Data 250.3,&H00
'=============================================='
'End of Program                                '
'=============================================='