
;NEW SINGLE AND DOUBLE DENSITY FORMAT PROGRAM FOR MICROMATION DOUBLER
;THIS PROGRAM DECIDES WHICH DRIVE AND DENSITY TO FORMAT EITHER FROM
;THE COMMAND LINE, OR, IF NO PARAMETERS WERE PASSED, BY PROMPTING
;THE USER
;TO INPUT THE PARAMETERS ON THE COMMAND LINE INVOKE THE PROGRAM WITH
;	FORMAT <DRV><DEN>
;		OR
;	FORMAT <DEN><DRV>
;WHERE <DRV> IS A, B, C, OR D (CORRESPONDING TO THE DRIVE TO FORMAT)
;AND <DEN> IS S OR D (CORRESPONDING TO SINGLE OR DOUBLE DENSITY)

;THIS PROGRAM MUST BE RUN UNDER CPM 2.0 OR MPM

;	COPYRIGHT (C) 1980
;	MICROMATION, INC.
;	SAN FRANCISCO, CA
;
;	LAST UPDATED JAN 25, 1980
;
CONTROLLER	EQU	0F800H	;ADDRESS OF THE DOUBLER IN YOUR SYSTEM

STEPTIME	EQU	CONTROLLER+410H	;LOCATION IN DOUBLER RAM WHERE
					;STEPTIME (IN MS) IS STORED

	;HARDWARE PORT DEFINITIONS FOR THE DOUBLER

WRCONT		EQU	CONTROLLER+600H
RDSTAT		EQU	WRCONT
RDMARK		EQU	WRCONT+5
RDDATA		EQU	WRCONT+6
WRCLK		EQU	WRCONT+1
WRMRKCRC	EQU	WRCONT+4
WRMARK		EQU	WRCONT+5
WRDATA		EQU	WRCONT+6
WRCRC		EQU	WRCONT+7


BOOT		EQU	0		;LOCATION TO JUMP FOR REBOOT
BDOS		EQU	BOOT+5
TBUFF		EQU	BOOT+80H	;CPM BUFFER FOR TAIL OF COMMAND LINE

HEADSETTLE	EQU	40		;HEAD SETTLING TIME AFTER SELECT
STEPSETTLE	EQU	15

LF		EQU	0AH
CR		EQU	0DH
CTRLH		EQU	8


	ORG	100H

	LXI	SP,100H		;SET UP STACK POINTER BELOW TPA
	LXI	D,LOGON
	CALL	PRINT		;PRINT LOGON MESSAGE
	CALL	GETPARMS	;FIND WHICH DRIVE AND DENSITY TO FORMAT
REPEAT	CALL	VERIFY		;VERIFY ABOVE INFORMATION
	CALL	INDISK		;PROMPT USER TO INSERT DISK
	LDA	DRIVE		;DRIVE NUMBER IN ASCII PUT HERE BY GETPARMS
	SUI	'A'		;CONVERT TO HEX
	MOV	C,A		;PUT IN C REG FOR SELDSK
	CALL	SELDSK		;SELECT THE DISK
	CALL	READY		;CHECK FOR DRIVE READY
	CALL	PROTECT		;CHECK FOR WRITE ENABLED DISKETTE
	CALL	HOME		;HOME THE DRIVE

				;NOW START FORMATTING
	XRA	A
	STA	TRACK		;START AT TRACK 0
	STA	DECTRK		;INITIALIZE THE DECIMAL TRACK COUNTER
	MVI	A,10H
	STA	ABOVE43		;INITIALIZE ABOVE43
	LXI	D,TRKMSG
	CALL	PRINT		;PRINT TRACK NUMBER
	CALL	SDFORM		;FORMAT TRACK 0 IN SINGLE DENSITY
	CALL	YSFORM		;FORMAT SIDE 1 IF PRESENT

LOOP	CALL	STEPIN		;STEP TO NEXT TRACK
	CALL	PRTTRACK	;INCREMENT TRACK NUMBER AND PRINT IT
	LDA	TRACK
	CPI	2		;ON TRACK 1?
	JC	SD		;FORMAT TRACKS 0 AND 1 IN SINGLE DENSITY

	LDA	DENSITY		;GET DENSITY
	ORA	A		;SINGLE DENSITY?
	JNZ	DD		;IF NO, GO TO DD

SD				;SINGLE DENSITY
	CALL	SDFORM		;FORMAT SIDE 0
	CALL	YSFORM		;FORMAT SIDE 1 IF PRESENT
	JMP	LOOP1

DD				;DOUBLE DENSITY
	CALL	DDFORM		;FORMAT SIDE 0
	CALL	YDFORM		;FORMAT SIDE 1 IF PRESENT

LOOP1	CALL	SETAB43		;SET UP THE ABOVE TRACK 43 FLAG
	LDA	TRACK		;GET TRACK NUMBER
	CPI	76		;DONE?
	JNZ	LOOP

	CALL	HOME		;DONE FORMATTING. HOME THE DRIVE

BYE	LXI	D,LOGOFF
	CALL	PRINT		;PRINT LOGOFF MESSAGE
BYE1	CALL	CONIN
	CPI	'Y'		;DOES USER WANT TO REPEAT FORMAT?
	JZ	REPEAT		;IF YES, DO IT
	CPI	'N'
	JNZ	BYE1		;IF NOT "Y" OR "N", GET NEXT CONSOLE CHAR
	JMP	BOOT


	;VARIABLES
TRACK	DS	1
DECTRK	DS	1
DENSITY	DS	1
CONTROL	DS	1
ABOVE43	DS	1


	;MESSAGES TO CONSOLE
LOGON	DB	CR,LF,'SINGLE AND DOUBLE DENSITY FORMAT PROGRAM FOR A'
	DB	CR,LF,'MICROMATION DOUBLER LOCATED AT '
	DB	CONTROLLER/1000H - 10 + 'A'
	DB	CONTROLLER/100H MOD 10H + '0'
	DB	'00 (HEX)',CR,LF,'$'

LOGOFF	DB	CR,LF,'DO YOU WANT TO FORMAT ANOTHER DISKETTE? '
	DB	'(TYPE Y OR N) $'

DRVMSG	DB	CR,LF,'FORMAT DISKETTE IN WHICH DRIVE? '
	DB	'(TYPE A, B, C, OR D) $'

DENMSG	DB	CR,LF,'FORMAT IN SINGLE OR DOUBLE DENSITY? (TYPE S OR D) $'

VER1	DB	CR,LF,'FORMAT DRIVE '
DRIVE	DB	'A IN $'
SINGLE	DB	'SINGLE$'
DOUBLE	DB	'DOUBLE$'
VER2	DB	' DENSITY'
	DB	CR,LF,'IS THAT CORRECT? (TYPE Y OR N) $'

INMSG	DB	CR,LF,'INSERT DISKETTE TO BE FORMATTED IN DRIVE '
DRIVE1	DS	1
	DB	' THEN HIT RETURN$'

TRKMSG	DB	CR,LF,'TRACK 00$'

BKSPC	DB	CTRLH,CTRLH,'$'

RDYMSG	DB	CR,LF,'DRIVE NOT READY. TRY AGAIN? (TYPE Y OR N) $'

PROTMSG	DB	CR,LF,'DISKETTE IS WRITE PROTECTED. TRY AGAIN?'
	DB	'(TYPE Y OR N) $'


;	SUBROUTINES FOLLOW


PRINT		;PRINT ASCII DATA AT (DE) UNTIL '$' IS ENCOUNTERED
	MVI	C,9
	JMP	BDOS


CONIN		;CONSOLE INPUT
	MVI	C,6		;DIRECT CONSOLE I/O PARAMETER
	MVI	E,0FFH		;ASK FOR INPUT
	CALL	BDOS
	CPI	3		;CONTROL C?
	JZ	BOOT		;IF YES, REBOOT
	ORA	A		;CHAR READY?
	JZ	CONIN		;IF NO, TRY AGAIN
	PUSH	PSW
	MOV	E,A
	CALL	CONOUT		;PRINT CHAR TYPED IN
	POP	PSW
	ANI	5FH		;CONVERT TO UPPER CASE
	RET


PRTHEX		;PRINT HEX VALUE IN ACCUMULATOR
	PUSH	PSW
	RRC
	RRC
	RRC
	RRC
	CALL	HEXOUT
	POP	PSW
HEXOUT	ANI	0FH
	CPI	10
	JC	DEC
	ADI	7
DEC	ADI	'0'
	MOV	E,A
CONOUT	MVI	C,6
	JMP	BDOS


SETAB43		;SET THE ABOVE TRACK 43 FLAG
	LDA	TRACK		;GET TRACK NUMBER
	CPI	44		;TRACK < 44?
	MVI	A,10H		;IF YES, RESET THE ABOVE 43 BIT (BIT 6)
	JC	UNDER44

	MVI	A,50H		;IF TRACK > 43, SET BIT 6
UNDER44	STA	ABOVE43
	RET


GETPARMS	;GET DRIVE NUMBER TO FORMAT AND IN WHICH DENSITY
		;IF PARAMETERS WERE INPUT ON COMMAND LINE, USE THOSE
		;ELSE, PROMPT USER FOR PARAMETERS
	LXI	H,DENSITY	;HL POINTS TO DENSITY THRU MOST OF THIS ROUTINE
	LXI	D,TBUFF		;POINT TO COMMAND LINE TAIL
	LDAX	D		;GET BYTE COUNT OF COMMAND LINE TAIL
	MOV	C,A		;KEEP IT IN C REG
	ORA	A		;ARE THERE ANY PARAMETERS ON COMMAND LINE?
	JZ	PROMPT		;IF NO, PROMPT FOR THEM

GET1	INX	D
	LDAX	D		;GET NEXT BYTE OF COMMAND LINE
	CPI	'S'		;IS IT "S"
	JZ	SNGLDEN		;IF YES, DENSITY IS SD
	CPI	'A'		;LOOK FOR DRIVE NUMBER
	JC	GET2		;IF < A, BYTE NOT VALID
	CPI	'D'
	JC	GOTDRV		;IF BETWEEN "A" AND "C", IT'S A DRIVE NUMBER
	JZ	GOTD		;A "D" IS AMBIGUOUS

GET2	DCR	C		;BAD CHARACTER.ARE THERE ANY MORE?
	JNZ	GET1		;IF YES, GET IT

PROMPT	CALL	GETDRV		;ELSE, PROMPT FOR THE INFORMATION
	CALL	GETDEN
	RET

SNGLDEN		;"S" WAS TYPED IN. FORMAT IN SINGLE DENSITY
	MVI	M,0		;SET SD FLAG

SNGL1	DCR	C		;DECREMENT # BYTES ON COMMAND LINE
	JZ	GETDRV		;IF HAVEN'T FOUND DRIVE, PROMPT FOR IT
	INX	D
	LDAX	D		;GET NEXT BYTE ON COMMAND LINE
	CPI	'A'		;LOOK FOR A DRIVE NUMBER
	JC	SNGL1
	CPI	'D'+1
	JNC	SNGL1		;ONLY "A" THRU "D" ARE VALID
				;FOUND DRIVE
	STA	DRIVE		;STORE IT
	RET

GOTDRV		;FOUND DRIVE NUMBER. LOOK FOR DENSITY
	STA	DRIVE		;STORE DRIVE NUMBER
GOTDRV1	DCR	C		;DECREMENT # BYTES IN COMMAND LINE
	JZ	GETDEN		;IF HAVEN'T FOUND DENSITY, PROMPT FOR IT
	INX	D
	LDAX	D		;GET NEXT BYTE
	CPI	'S'		;SINGLE DENSITY?
	MVI	M,0
	RZ			;IF YES, EXIT
	CPI	'D'		;DOUBLE DENSITY?
	MVI	M,1
	JNZ	GOTDRV1		;IF BYTE WASN'T "S" OR "D", TRY NEXT ONE
	RET

GOTD		;FOUND A "D" IN COMMAND LINE. LOOK FOR EITHER A DRIVE
		;NUMBER OR FOR THE DENSITY
	DCR	C		;DECREMENT # BYTES IN COMMAND LINE
	JZ	PROMPT		;IF DIDN'T FIND ANYTHING ELSE,
				;PROMPT FOR BOTH DRIVE AND DENSITY
	INX	D
	LDAX	D		;GET NEXT BYTE
	CPI	'S'		;IF IT'S AN "S", THEN FORMAT DRIVE D
	JZ	SDRVD		;IN SINGLE DENSITY

	CPI	'A'		;ELSE, LOOK FOR A DRIVE NUMBER
	JC	GOTD
	CPI	'D'+1
	JNC	GOTD
				;FOUND A DRIVE NUMBER
	STA	DRIVE		;STORE IT
	MVI	M,1		;AND SET DOUBLE DENSITY FLAG
	RET

SDRVD				;AN "S" IMPLIES THE LAST "D" WAS A DRIVE #
	MVI	M,0		;STORE SD FLAG
	MVI	A,'D'
	STA	DRIVE		;STORE DRIVE D
	RET

GETDRV		;PROMPT USER FOR DRIVE NUMBER
	LXI	D,DRVMSG
	CALL	PRINT		;PRINT PROMPT
GDRV1	CALL	CONIN		;WAIT FOR CONSOLE INPUT
	CPI	'A'		;LOOK FOR VALID DRIVE NUMBER
	JC	GDRV1
	CPI	'D'+1
	JNC	GDRV1
				;FOUND DRIVE NUMBER
	STA	DRIVE		;STORE IT
	RET

GETDEN		;PROMPT USER FOR DENSITY
	LXI	D,DENMSG
	CALL	PRINT		;PRINT PROMPT
GDEN1	CALL	CONIN		;WAIT FOR CONSOLE INPUT
	LXI	H,DENSITY
	CPI	'S'		;SINGLE DENSITY?
	MVI	M,0		;IF YES, STORE SD FLAG
	RZ			;AND RETURN
	CPI	'D'		;DOUBLE DENSITY?
	MVI	M,1		;IF YES, STORE DD FLAG
	RZ			;AND RETURN
	JMP	GDEN1		;IF NEITHER, TRY AGAIN


VERIFY		;ASK USER TO VERIFY DRIVE AND DENSITY PARAMETERS
	LXI	D,VER1
	CALL	PRINT		;PRINT FIRST PART OF VERIFY MESSAGE
	LXI	D,SINGLE
	LDA	DENSITY		;GET DENSITY
	ORA	A		;SINGLE DENSITY?
	JZ	VERSD

	LXI	D,DOUBLE
VERSD	CALL	PRINT		;PRINT DENSITY
	LXI	D,VER2
	CALL	PRINT		;PRINT LAST PART OF VERIFY MESSAGE
VER3	CALL	CONIN		;WAIT FOR CONSOLE INPUT
	CPI	'Y'		;OK?
	RZ
	CPI	'N'		;NOT OK?
	JNZ	VER3		;IF NEITHER, GET ANOTHER CONSOLE CHAR
				;USER SAID PARMS WERE WRONG
	CALL	GETDRV		;PROMPT FOR NEW PARAMETERS
	CALL	GETDEN
	JMP	VERIFY		;AND ASK HIM TO VERIFY THOSE


INDISK		;PROMPT USER TO PUT IN DISKETTE
	LDA	DRIVE		;GET DRIVE NUMBER
	STA	DRIVE1		;AND STORE IT IN MESSAGE
	LXI	D,INMSG
	CALL	PRINT		;PRINT PROMPT
INDSK1	CALL	CONIN		;WAIT FOR CONSOLE INPUT
	CPI	CR
	JNZ	INDSK1		;LOOP UNTIL HE TYPES RETURN
	RET


SELDSK		;SELECT DRIVE POINTED TO BY C REG
		;THE FIRST LITTLE LOOP JUST CONSTRUCTS A ZERO-ACTIVE
		;ONE-OF-FOUR CODE IN BITS 3-6 OF THE CONTROL BYTE
	MVI	A,7FH
SEL1	RRC
	DCR	C
	JP	SEL1
				;THE ONE-OF-FOUR CODE IS IN THE ACC
	STA	CONTROL		;STORE IT IN CONTROL FOR FUTURE USE
	STA	WRCONT		;AND PUT IT IN THE HARDWARE PORT WRCONT
				;WHICH ACTUALLY SELECTS THE DRIVE
	LDA	RDMARK		;LOAD THE HEAD
	MVI	B,HEADSETTLE
	CALL	DELAY		;AND DELAY FOR THE HEAD SETTLING TIME
	RET


DELAY			;DELAYS (B) MILLISECONDS
			;USES THE C REG
	LDA	CONTROL
	ORI	4	;SELECT SINGLE DENSITY ON THE CONTROLLER
	STA	WRCONT
DLY1	MVI	C,31		;A ONE MILLISECOND DELAY IS GENERATED
				;READING 31 BYTES IN SINGLE DENSITY
				;(31 BYTES * 32 USEC = 1 MS)
	;START OF ONE MILLISECOND LOOP
MSEC	LDA	RDDATA		;READ A BYTE FROM DISK
	DCR	C
	JNZ	MSEC
				;END OF 1 MS LOOP
	DCR	B		;DECREMENT # MILLISECONDS TO DELAY
	JNZ	DLY1
	RET


READY			;CHECK FOR DRIVE READY. PROMPT USER IF NOT
	LDA	RDMARK		;KEEP THE HEAD LOADED
	LDA	RDSTAT		;GET DRIVE STATUS
	ANI	80H		;MASK FOR READY BIT
	RZ			;RETURN IF READY
	LXI	D,RDYMSG
	CALL	PRINT		;PRINT PROMPT
RDY1	CALL	CONIN		;WAIT FOR CONSOLE INPUT
	CPI	'Y'		;TRY AGAIN?
	JZ	READY
	CPI	'N'		;REBOOT?
	JZ	BOOT
	JMP	RDY1


PROTECT		;CHECK FOR A WRITE ENABLED DISKETTE. PROMPT USER IF NOT
	LDA	RDMARK		;KEEP THE HEAD LOADED
	LDA	RDSTAT		;GET DRIVE STATUS
	ANI	4		;MASK FOR PROTECT BIT
	RNZ			;RETURN IF WRITE ENABLED
	LXI	D,PROTMSG
	CALL	PRINT		;PRINT PROMPT
PROT1	CALL	CONIN		;WAIT FOR CONSOLE INPUT
	CPI	'Y'		;TRY AGAIN?
	JZ	PROTECT
	CPI	'N'		;REBOOT?
	JZ	BOOT
	JMP	PROTECT


HOME		;STEP THE DRIVE TO TRACK 00
	LDA	RDSTAT		;GET DRIVE STATUS
	ANI	2		;MASK FOR TRACK 00 BIT
	JZ	HOME1		;IF AT TRACK 00, EXIT
	CALL	STEPOUT		;ELSE, STEP ONE TRACK TOWARDS 00
	JMP	HOME		;AND TRY AGAIN
HOME1	MVI	B,STEPSETTLE
	CALL	DELAY		;DELAY STEP SETTLING TIME
	RET


STEPOUT		;STEP TOWARDS TRACK 00
	LDA	CONTROL		;GET DRIVE CONTROL BYTE
	ORI	2		;SET DIRECTION = OUT
	JMP	STEP		;DO STEP

STEPIN		;STEP TOWARDS TRACK 76
	LDA	CONTROL		;GET DRIVE CONTROL BYTE
	ANI	0FDH		;SET DIRECTION = IN

STEP			;STEP ONE TRACK
	LXI	D,WRCONT	;POINT TO HARDWARE CONTROL PORT
	STAX	D		;OUTPUT CONTROL BYTE
	DCR	A
	STAX	D		;OUTPUT WITH STEP LINE LOW
	INR	A
	STAX	D		;OUTPUT WITH STEP LINE HIGH
	LDA	RDMARK		;KEEP HEAD LOADED
	LDA	STEPTIME
	MOV	B,A
	CALL	DELAY		;DELAY STEP TIME
	RET


PRTTRACK	;INCREMENT TRACK NUMBER AND PRINT IT
	LXI	D,BKSPC
	CALL	PRINT
	LXI	H,TRACK
	INR	M
	LXI	H,DECTRK
	MOV	A,M
	INR	A
	DAA
	MOV	M,A
	CALL	PRTHEX
	RET


YSFORM	LDA	RDSTAT
	ANI	40H		;DOUBLE SIDED DISKETTE?
	RNZ			;NO, RETURN
	LDA	CONTROL
	ANI	7FH
	JMP	S1

SDFORM	LDA	CONTROL
S1	STA	WRCONT
	LDA	ABOVE43
	STA	WRCLK
	MVI	B,0		;SECTOR NUMBER
	LXI	D,WRDATA
	MVI	L,72D
S2	LDA	RDSTAT
	ANI	10H		;WAIT FOR NO INDEX
	JZ	S2
S3	LDA	RDSTAT
	ANI	10H		;NOW WAIT FOR LEADING EDGE OF INDEX
	JNZ	S3
	MVI	A,0FFH
S4	STAX	D		;73 FF'S
	DCR	L
	JNZ	S4
	STAX	D
SECTOR	XRA	A
	STAX	D		;6 00'S
	INR	B		;INCREMENT SECTOR NUMBER
	STAX	D
	XCHG
	MVI	E,0
	MOV	M,E
	LDA	ABOVE43
	MOV	M,E
	ORI	80H
	STA	WRCLK
	MOV	M,E
	XRA	A
	XCHG
	STAX	D
	MVI	A,0FEH
	STA	WRMRKCRC	;ID MARK
	LDA	TRACK		;GET TRACK NUMBER
	STAX	D		;TRACK
	XRA	A
	STAX	D		;00
	MOV	A,B
	STAX	D		;SECTOR
	XRA	A
	STAX	D		;00
	MVI	A,0FFH
	STA	WRCRC		;CRC
	STA	WRCRC		;CRC
	MVI	L,10D
S5	STAX	D		;11 FF'S
	DCR	L
	JNZ	S5
	STAX	D
	XRA	A
	STAX	D		;6 00'S
	STAX	D
	LDA	ABOVE43
	STA	WRCLK		;SET UP FOR DATA MARK
	XRA	A
	STAX	D
	STAX	D
	STAX	D
	STAX	D
	MVI	A,0FBH
	STA	WRMRKCRC	;DATA MARK
	MVI	L,7FH
	MVI	A,0E5H
S6	STAX	D		;128 E5'S
	DCR	L
	JNZ	S6
	STAX	D
	MVI	A,0FFH
	STA	WRCRC		;CRC
	MVI	L,25D
	STA	WRCRC		;CRC
S7	STAX	D		;27 FF'S
	DCR	L
	JNZ	S7
	STAX	D
	MOV	A,B
	CPI	26D		;LAST SECTOR?
	MVI	A,0FFH
	STAX	D
	JNZ	SECTOR
S8	STAX	D		;INSERT FF'S UNTIL INDEX
	LDA	RDSTAT
	ANI	10H
	MVI	A,0FFH
	STAX	D
	JNZ	S8
	XRA	A
	STA	WRCLK
	MVI	B,1
	CALL	DELAY
	RET


YDFORM	LDA	RDSTAT
	ANI	40H		;DOUBLE SIDED DISKETTE?
	RNZ			;NO, RETURN
	LDA	CONTROL
	ANI	7BH
	JMP	D1


DDFORM	LDA	CONTROL
	ORI	80H
	ANI	0FBH
D1	STA	WRCONT
	LDA	ABOVE43
	STA	WRCLK
ERRETRY	LDA	RDMARK		;KEEP HEAD LOADED
	LXI	B,DSECTBL	;SECTOR NUMBER
	LXI	D,WRDATA
	MVI	L,46D
D2	LDA	RDSTAT
	ANI	10H		;WAIT FOR NO INDEX
	JZ	D2
D3	LDA	RDSTAT
	ANI	10H		;WAIT FOR LEADING EDGE OF INDEX
	JNZ	D3
	MVI	A,4EH
D4	STAX	D		;46 4E'S
	DCR	L
	JNZ	D4
DSECTOR STAX	D
	MVI	L,16D
D5	STAX	D		;18 4E'S
	DCR	L
	JNZ	D5
	STAX	D
	XRA	A
	STAX	D		;6 00'S
	STAX	D
	STAX	D
	STAX	D
	STAX	D
	STAX	D
	MVI	A,0A1H
	STA	WRMRKCRC	;ID MARK
	MVI	A,0FEH
	STAX	D		;FE
	LDA	TRACK		;GET TRACK NUMBER
	STAX	D		;TRACK
	LDAX	B		;GET SECTOR NUMBER
	STAX	D		;SECTOR
	MVI	A,4EH
	STA	WRCRC		;CRC
	STA	WRCRC		;CRC
	MVI	L,21D
D6	STAX	D		;22 4E'S
	DCR	L
	JNZ	D6
	STAX	D
	XRA	A
	STAX	D		;6 00'S
	STAX	D
	STAX	D
	STAX	D
	STAX	D
	STAX	D
	MVI	A,0A1H
	STA	WRMRKCRC	;DATA MARK
	MVI	L,7FH
	MVI	A,0E5H
D7	STAX	D		;128 E5'S
	DCR	L
	JNZ	D7
	STAX	D
	MVI	A,4EH
	STA	WRCRC		;CRC
	STA	WRCRC		;CRC
	STAX	D		;4 4E'S
	MOV	L,A
	STAX	D
	INX	B		;INCREMENT SECTOR NUMBER
	STAX	D
	LDAX	B
	ORA	A		;LAST SECTOR?
	MOV	A,L
	STAX	D
	JNZ	DSECTOR
	STAX	D
	XCHG
	MVI	D,0
D8	MOV	M,E		;4E'S UNTIL INDEX
	INR	D
	JZ	ERROR
	MOV	M,E
	LDA	RDSTAT
	MOV	M,E
	ANI	10H
	MOV	M,E
	JNZ	D8
	XRA	A
	STA	WRCLK
	MVI	B,1
	CALL	DELAY
	RET

ERROR	PUSH	B
	LXI	D,ERRMSG
	CALL	PRINT
	POP	B
	JMP	ERRETRY

ERRMSG	DB	CR,LF,'DRIVE ROTATIONAL SPEED OUT OF TOLERANCE'
	DB	CR,LF,'REFORMATTING TRACK'

DSECTBL		;DOUBLE DENSITY SECTOR TABLE
		;THE SECTORS IN THIS TABLE ARE SKEWED BY 12
	DB	 1,14,27,40
	DB	10,23,36,49
	DB	 6,19,32,45
	DB	 2,15,28,41
	DB	11,24,37,50
	DB	 7,20,33,46
	DB	 3,16,29,42
	DB	12,25,38,51
	DB	 8,21,34,47
	DB	 4,17,30,43
	DB	13,26,39,52
	DB	 9,22,35,48
	DB	 5,18,31,44
	DB	 0		;END OF TRACK FLAG--MUST BE HERE
