
*******************************************************************************
*
*	*** MICROMATION RAMTEST TO CURE YOUR MEMORY ILLS FAST ***
*
*   ===>>>THIS version loops reading the bad byte UNTIL <CR> IS PRESSED
*
*------------------------------------------------------------------------------
*      updated: January 31, 1980  by  M.GILLILAND and Ed Anderson,RET'D
*        
* 	        FEBRUARY 13, 1980 BY  A. REYNOLDS                       
*******************************************************************************

HOLDOFF	EQU	500		;NUMBER OF SYNC TRIES BETWEEN PATTERNS
				;IN AN ATTEMPT TO KILL MEMORY REFRESH
				;AT ABOUT 250 uS PER COUNT (4000 = 1 SEC)

DOUBLER	EQU	0F800H		;DOUBLER BASE ADDRESS
*******************************************************************************
BUFF	EQU	DOUBLER+400H	;RAM BUFFER ON DOUBLER
WRCONT	EQU	DOUBLER+600H	;HARDWARE PORTS ON DOUBLER
WRCLK	EQU	WRCONT+1	;SYNC REGISTER
SYNCPRT	EQU	WRCONT+7	;SYNCPORT
URTSTAT	EQU	WRCONT+0AH	;UART STATUS PORT
URTDATA EQU	WRCONT+2H	;UART DATA PORT
STARTAD	EQU	BUFF
LASTAD	EQU	BUFF+2
*******************************************************************************
TRUE	EQU	-1		!		FALSE	EQU	0
*==============================================================================
;            SET FLAG FOR TEST CONFIGURATION DESIRED:

DBLR	EQU	FALSE		;PROM BASED TEST FOR DOUBLER SOCKET
Z64	EQU	FALSE		;PROM BASED TEST FOR 64 BRD SOCKET @ 0F000H
CPM	EQU	TRUE		;CP/M COM FILE
*==============================================================================

	IF CPM			;ASSEMBLE FOR COM FILE
	ORG	100H		;
TESTSTR	SET	NOMORE		;START OF TEST AREA
TESTEND	EQU	DOUBLER		;TOP OF THE TEST AREA
	ENDIF

	IF Z64			;ASSEMBLE FOR PROM AT 0F000H
	ORG	0F000H		;
TESTSTR	EQU	0		;START OF TEST AREA
TESTEND	EQU	$		;TOP OF TEST AREA
	ENDIF

	IF DBLR			;ASSEMBLE FOR PROM IN DOULBER EPROM SOCKET
	ORG DOUBLER		;
TESTSTR	EQU	0		;START OF TEST AREA
TESTEND	EQU	$		;TOP OF TEST AREA
	ENDIF
	
BEGIN	JMP	ENTRY		;TO DO A JUMP ON RESET
ENTRY	LXI	SP,BUFF+3FH	;INITIALIE STACK TO DOUBLER RAM
	MVI	A,0FFH		;PATTERN TO TURN OFF ALL WRCONT BITS
	STA	WRCONT

	IF (DBLR OR Z64)	;HARDWARE UART INITIALIZATION
UARTINT	LXI	H,URTSTAT	;
	MVI	M,0EH		;USED FOR THE 8251 UART
	PUSH	B		;JUST FILLER FOR 4MHZ OPERATION
	MVI	M,40H
	POP	B		;MORE FILLER
	MVI	M,0EEH
	PUSH	PSW!POP	PSW	;TIME FILL
	MVI	M,37H		;Don't forget this instruction
	NOP
	NOP
	ENDIF

CLEAR	LXI	H,CLR		;LOAD CLEAR SCREEN STRING FOR TERMINAL
	CALL	PRINT		;CLEAR SCREEN

SIGNON	LXI	H,SIGNMESS	;OUTPUT SIGNON
	CALL	PRINT
	
	IF CPM			;SPECIAL SIGN ON
	LXI	D,TESTSTR	;START OF TEST AREA
	CALL	MOVHEX		;HEX TO ASCII CONVERSTION AND OUTPUT
	LXI 	H,SIGN1		;MESSAGE CONTINUES
	CALL	PRINT		;
	LXI	D,TESTEND	;END OF TEST ADDRESS
	CALL	MOVHEX		;
	LXI	H,SIGN2		;MORE MESSAGE
	CALL	PRINT		;
	ENDIF	

ASK	LXI	H,TESTSTR	;DEFAULT PARAMETERS----------
	SHLD	STARTAD		;PUT IN BUFFER
	LXI	H,TESTEND	;TOP OF TEST AREA (LAST PAGE+1)
	SHLD	LASTAD		;
	CALL	CONIN		;GET KEYBOARD Y/N INPUT
	MOV	C,A		;CHAROUT MOVES C TO A AGAIN
	CALL	CHAROUT		;ECHO RESPONSE TO THE CRT
	CPI	59H		;IS IT A YES VOTE???
	JZ	ASKMORE		;GET NEW PARAMETERS IF SO....
	JMP	LESSON		;INSTRUCTIONS ON OUT...
ASKMORE	LXI	H,GETSTART	;ASK FOR BEGINNING OF BLOCK
	CALL	PRINT
	CALL	GETADDR		;GET THE START ADDR IN H&L
	CPI	CR		;<CR>?
	JZ	MORE		;IF YES,KEEP THE DEFAULT VALUE
	SHLD	STARTAD
MORE	LXI	H,GETEND	;GET END ADDR
	CALL	PRINT
	CALL	GETADDR
	CPI	CR		;<CR>?
	JZ	LESSON		;IF YES,KEEP DEFAULT VALUE
	SHLD	LASTAD
LESSON	LXI	H,STARTUP	;INSTRUCTIONS OUT TO CRT...
	CALL	PRINT
	
GO	CALL	CONIN		;WAIT FOR KEYSTOKE TO BEGIN
	CPI	3		;^C ?
	JZ	ENTRY
	CPI	0DH		;BEGIN??
	JNZ	GO		;
	MVI	B,0H		;CLEAR PATTERN MODIFIER IN B REG.
	LXI	D,0H		;CLEAR PASS COUNTER
LOOP1	CALL	PASSMSG		;OUTPUT PASS COUNT AND PATTERN TO CRT
LOOP	LHLD	STARTAD		;LOAD STARTING ADDRESS OF TEST
FILL	MOV	A,L		;MOVE LOW ADDRESS INTO ACC.
	XRA	H		;GENERATE TEST BYTE
	XRA	B		;MODIFY WITH B REG.
	MOV	M,A		;STORE TEST BYTE IN MEMORY CELL
	CALL	ENDTEST		;NEXT ADDRESS TO DO...SETS ZERO FLAG IF DONE
	JNZ	FILL		;IF NOT ZERO, CONTINUE TO GENERATE TEST BYTES

SYNC	LXI	H,WRCLK		;NOW GET READY TO SYNC ON DISK(TEST REFRESH)
	MVI	M,70H		;NONEXISTENT SYNC BYTE TO LATCH ON
	LXI	H,HOLDOFF	;COUNT THE NUMBER OF SYNC TRIES
	INX	H		;CORRECT THE COUNT
     	PUSH	D		;SAVE PASS COUNTER
	LXI	D,SYNCPRT	;HARDWARE PORT ON DOUBLER
SYNLOOP	LDAX	D		;SYNC ON UP,GUYS (0FFH CLOCK IN HEADER)
	DCX	H		;DECREMENT SYNC COUNT
	MOV	A,H		;GET THE HIGH ORDER COUNT
	ORA	A		;COMPLETED NUMBER OF TRIES IN 'HOLDOFF'?
	JNZ	SYNLOOP		;NOT YET,TRY AGAIN

VERIFY	MVI	E,2		;LOAD"VERIFY LOOP"COUNT(TRY EACH CELL 2 TIMES)
TEST1	LHLD	STARTAD		;START ADDRESS OF MEMORY BLOCK TO TEST
TEST2	MOV	A,L		;LOW BYTE USED TO GENERATE PATTERN
	XRA	H		;GENERATE TEST BYTE
	XRA	B		;MODIFY WITH CONTENTS OF B REG.
	MOV	C,M		;GET MEMORY DATA BYTE
	CMP	C		;COMPARE WITH MEMORY CELL CONTENTS (IN C REG.)
	CNZ	ERRMSG		;IF NOT EQUAL,OUTPUT ADDRESS OF FAULTY CELL
NEXT	CALL	ENDTEST		;NEXT ADDRESS TO DO...SETS ZERO FLAG IF DONE
	JNZ	TEST2		;CONTINUE THIS TEST LOOP,IF NOT FINISHED.
	CALL	QUERY		;WAS A CHARACTER HIT WHILE WE WERE BUSY?
	DCR	E		;VERIFY LOOP-1 (CELL VALUES CHECKED AGAIN)
	JNZ	TEST1		;REPEAT THIS VERIFY LOOP 2 TIMES
	POP	D		;RESTORE PASS COUNTER IN DE
	MOV 	A,B		;HAS 1 PASS (256 PATTERN LOOPS) BEEN DONE?
	CPI	0FFH		;
	CZ	UPDATE		;UPDATE PASS COUNTER IF YES
	INR	B		;OTHERWISE,GENERATE NEXT PATTERN MODIFIER....
	JMP	LOOP1		;AND EXECUTE NEXT PATTERN LOOP

QUERY	CALL 	CONSTAT		;SHOULD TEST END??
	RZ			;IF ZERO FLAG,THEN NO CHARACTER: CONTINUE TEST
	CALL	CONIN		;GET CHARACTER
	CPI	13H		;IS IT A ^S ?
	CZ	CONIN		;IF YES, ENTER WAIT LOOP (STOP SCREEN SCROLL)
	CPI	3H		;IS IT A ^C ?
	RNZ			;NO...JUST GET BACK TO BUSINESS,PLEASE
EXIT1	POP	PSW		;CLEAR STACK: 	
	
	IF CPM			;EXIT FOR CPM FILE:
	JMP	DOUBLER		;COLD BOOT TO CP/M
	ENDIF
	
	IF (Z64 OR DBLR)	;RESTART THE TEST AGAIN...
	JMP	RENTRY          ;BACK TO TESTING       
	ENDIF

UPDATE	INX	D		;PASS COUNT + ONE
	RET

ENDTEST	INX	H		;NEXT ADDRESS TO DO
	LDA	LASTAD+1	;GET PAGE ADDR
	CMP	H		;DONE???(SET ZERO FLAG IF YES)
	RET

RENTRY	JMP	ENTRY		;Start from scratch

*******************************************************************************
*		;PRINT OUT ROUTINES FOR TESTER
*******************************************************************************
CONSTAT	LDA	URTSTAT		;READ UART STATUS
	ANI 	2		;IS THERE A CHARACTER?
	RET			;RETURNS WITH ZERO SET IF NOT READY
CONIN	CALL	CONSTAT		;
	JNZ	GETIT		;LOOP UNTIL INPUT FROM KEYBOARD
	MVI	C,' '		;YOU PUT YOUR RIGHT FOOT IN,
	CALL	CHAROUT
	MVI	C,8		;YOU PUT YOUR RIGHT FOOT OUT
	CALL	CHAROUT
	JMP	CONIN		;CONTINUE TO WAIT
GETIT	LDA	URTDATA		;INPUT CHARACTER
	ANI	5FH		;STRIP PARITY BIT
	RET

PRINT	MOV	A,M		;GET CHARACTER IN MESSAGE STRING
	CPI	'$'		;IS IT THE END OF THE STRING?
	RZ			;RETURN IF DONE
	MOV	C,A		;PUT CHARACTER INTO C REG.
	CALL	CHAROUT		;OUTPUT TO SCREEN
	INX	H		;NEXT CHARACTER IN STRING
	JMP	PRINT		;REPEAT THE LOOP
CHAROUT	LDA	URTSTAT		;GET UART STATUS
	ANI 	1		;
	JZ	CHAROUT		;WAIT FOR UART READY FLAG
	MOV 	A,C		;PUT OUTPUT CHARACTER IN ACC.
	STA	URTDATA		;OUTPUT TO UART
	RET			;DONE

GETADDR	CALL	CONIN		;GET THE DIGIT
	CPI	0DH		;IS IT A <CR>?
	RZ			;GET BACK!
	MOV	C,A		;SAVE IT IN C REG.
	ANI	10H		;NUMBER OR CHAR?
	JNZ	GETNUM		;A NUMBER 0-9
	MOV	A,C		;GET THE ORIGINAL DIGIT
	ANI	7		;MUST BE A THRU F, LOOK AT 3 LOW BITS (0-6)
	ADI	9		;CONVERT TO EQUIVALENT HEX NUMBER
CALC	RAL!RAL!RAL!RAL		;MULT BY 16 TO GET PAGE START
	LXI	H,0		;
	MOV	H,A		;RETURN WITH 4K BLOCK START ADDR IN H&L
	CALL	PRNHEX		;PRINT THE VALUE GOTTEN * 1000H
	XRA	A		;THE ZEROS PORTION
	CALL	PRNHEX		;
	RET

GETNUM	MOV	A,C		;GET THE DIGIT
	ANI	0FH		;LOW 4 BITS 0-9
	JMP	CALC		;GET LOST	

MOVHEX	MOV	A,D		;HIGH BYTE 
	CALL	PRNHEX		;HEX TO ASCII CONVERSION AND OUTPUT
	MOV	A,E		;LOW BYTE 
	CALL	PRNHEX		;HEX TO ASCII CONVERSION AND OUTPUT
	RET
PRNHEX	PUSH	PSW		;SAVE FOR LSNIBBBLE CONVERSION
	RAR!RAR!RAR!RAR!	;SHIFT MSN TO LSN
	CALL	HEXOUT		;CONVERT HEX TO ASCII
	POP 	PSW		;NOW DO THE LSN
HEXOUT	ANI	0FH		;
	ADI	30H		;SHIFT TO ASCII VALUE
	CPI	3AH		;OVER 9?
	JC	CRTOUT		;OUTPUT TO CRT,PLEASE
	ADI	7		;SHIFT TO ALPHA
CRTOUT	MOV	C,A		;GET READY TO OUTPUT IT
	JMP	CHAROUT		;DO IT

PASSMSG	PUSH 	H		;SAVE CURRENT ADDRESS OF MEMORY CELL 
	PUSH	D		;SAVE PASS COUNT
	PUSH	B		;SAVE PATTERN MODIFIER
	LXI	H,STRING1	;LOCATION OF PASSCOUNT MESSAGE
	CALL	PRINT		;OUT TO SCREEN
	CALL	MOVHEX		;HEX TO ASCII CONVERSION AND OUTPUT (PASSCOUNT)
	LXI	H,STRING2	;MORE MESSAGE,FOLKS.....
	CALL	PRINT		;DO IT
	MOV	A,B		;GET PATTERN-TYPE INTO ACC.  
	CALL	PRNHEX		;CONVERT IT AND DUMP IT ON OUT TO CRT
	LXI	H,STRING3	;STILL MORE MESSAGE...
	CALL	PRINT		;DO IT SOMEMORE
	POP	B		;RESTORE STATUS
 	POP	D		;
	POP	H		;
	RET

ERRMSG	PUSH	PSW		;SAVE THE PATTERN BYTE
	PUSH	H		;SAVE STATUS OF TEST
	PUSH 	D		;
	PUSH	B		;
	PUSH	B		;SAVE MEMORY DATA BYTE
	PUSH	PSW		;SAVE PATTERN BYTE
	XCHG			;PUT MEMORY ERROR ADDRESS INTO DE
	LXI	H,STRING4	;START OF ERROR MESSAGE
	CALL	PRINT		;DO IT,PLEASE...
	CALL	MOVHEX		;HEX TO ASCII CONVERSION AND OUTPUT (ADDRESS)
	LXI	H,STRING5	;NEXT PART OF THE 'DEAL'
	CALL	PRINT		;DO IT 
	POP	PSW		;PATTERN BYTE,NEXT....
	CALL	PRNHEX		;OUT TO CRT (LIKE THE REST OF 'EM)
	LXI	H,STRING6	;MORE MESSAGE
	CALL	PRINT		;OUT TO CRT
	POP	B		;GET MEMORY DATA
	MOV 	A,C		;PUT IN ACC. FOR OUTPUT
	CALL	PRNHEX		;AND DO IT ONCE AGAIN (UNTIL IT HURTS)
	LXI	H,STRING7	;LAST PART OF THE 'BIG' MESSAGE
	CALL	PRINT		;FINALLY,IT IS FINISHED.....
	CALL	QUERY
	POP	B		;RESTORE STATUS
	POP	D		;
	POP	H		;GET BACK THE MEMORY ADDR
RETRYS	POP	PSW		;GET BACK THE PATTERN BYTE
	CMP	M
	RZ			;FINALLY COMPARED,GET BACK
	PUSH	PSW		;SAVE THE PATTERN
   	CALL	CONIN  		;EXIT IF A <CR> IS TYPED
	CPI	3		;<^C>?
	JZ	EXIT1		;GO FOR IT
	CPI	0DH		; <CR>?
	JNZ     RETRYS          ;OTHERWISE KEEP LOOPING ON ERROR
	POP	PSW		;RESTORE THE STACK	
	RET

***********************************************************************
*		;MESSAGE AREA: STAY CLEAR			      *
***********************************************************************
CR	EQU	0DH
LF	EQU	0AH
BEL	EQU	07H
STRING1	DB	CR	
	DB	'MEMORY TEST:  Pass # $'
STRING2	DB	' Hex,    Pattern # $'
STRING3	DB	' Hex$'

STRING4 DB	CR,LF,BEL
	DB	'** ERROR ** Location: $'
STRING5	DB	' Hex, Proper Data: $'
STRING6	DB	' Hex, Memory Data: $'
STRING7	DB	' Hex',BEL,LF,'$'

NOMORE	EQU	$		;END OF TEST PROGRAM

CLR	DB	1AH,'$'		;CLEAR SCREEN STRING FOR ADM TERMINAL...

SIGNMESS
	DB	CR,LF,LF
	DB	'********** MICROMATION RAMTEST **********',CR,LF,LF
	DB	'This program tests memory from'
 
	IF CPM			;ASSEMBLE SIGN ON	
	DB	' $'
	
SIGN1	DB	' Hex to $'
SIGN2	DB	' Hex',CR,LF
	ENDIF

	IF DBLR			;ASSEMBLE SIGN ON
	DB	'0000 Hex to F800 Hex',CR,LF
	ENDIF

	IF Z64			;ASSEMBLE SIGN ON
	DB	'0000 Hex to F000 Hex',CR,LF
	ENDIF

	DB	'Do you wish to alter the default start/end address? (Y/N) $'
GETSTART
	DB	CR,LF,LF,'Parameters are modified along 4k boundaries.',CR,LF
	DB	'Enter single hex digit or <CR> to retain default values.'
	DB	CR,LF,'(ie: 1=1000 hex, 2=2000 hex, etc...)'
	DB	CR,LF,LF,'Enter block START address: $'
GETEND	DB	   CR,LF,'Enter block END   address: $'

STARTUP	DB	CR,LF,LF,'<^S> Pauses test'
	DB	CR,LF,'<^C> Restarts the test'
	DB	CR,LF,'Press <RETURN> to start the test',LF,CR,'$'

	END
