#!/bin/sh
IFCONFIG="/usr/sbin/ifconfig"
ETHTOOL="/usr/bin/ethtool"
COUNTER_FILE="/tmp/tehuti_workaround.count"
LOCK_PATH="/tmp/tehuti_workaround_lock"
DELAY_TIME=10
MAX_RETRY=15

is_tehuti_interface()
{
	local IfDriver=`${ETHTOOL} -i $1 | grep "driver" | awk '{print $2}'`
	if [ "$IfDriver" = "tn40xx" ]; then
		return 0
	fi
	return 1
}

tehuti_workaround()
{
	/usr/bin/ping 1.2.3.4 -I $IFNAME -w 3 > /dev/null 2>&1
	sleep $DELAY_TIME
	local OutPkts=`${ETHTOOL} -S $IFNAME | grep "OutPkts" | awk '{print $2}'`
	local counter=`cat $COUNTER_FILE`
	if [ $counter -ge $MAX_RETRY ]; then
		echo "0" > $COUNTER_FILE
		return
	else
		counter=$(($counter + 1))
		echo "$counter" > $COUNTER_FILE
	fi
	if [ "$OutPkts" = "0" ]; then
		local AllIfs=`${IFCONFIG} -a | grep "eth" | awk '{print $1}'`
		local TehutiIfs=""
		for ifs in $AllIfs
		do
			if is_tehuti_interface $ifs ; then
				TehutiIfs="$TehutiIfs $ifs"
			fi
		done
		/usr/bin/logger -p warn -t "Tehuti Workaround reset kernel module for interface" "$IFNAME"
		for ifs in $TehutiIfs
		do
			IFCFG_FILE="/etc/sysconfig/network-scripts/ifcfg-${ifs}"
			BOOTPROTO=`get_key_value ${IFCFG_FILE} BOOTPROTO`
			if [ "${BOOTPROTO}" = "dhcp" ]; then
				stop dhcp-client IFACE=${ifs}
			fi
			${IFCONFIG} $ifs down
		done
		/usr/sbin/rmmod tn40xx > /dev/null 2>&1
		/usr/sbin/insmod /usr/lib/modules/tn40xx.ko > /dev/null 2>&1
		/usr/syno/bin/synonetseqadj > /dev/null 2>&1
		for ifs in $TehutiIfs
		do
			${IFCONFIG} $ifs up 
			IFCFG_FILE="/etc/sysconfig/network-scripts/ifcfg-${ifs}"
			BOOTPROTO=`get_key_value ${IFCFG_FILE} BOOTPROTO`
			if [ "${BOOTPROTO}" = "dhcp" ]; then
				start dhcp-client IFACE=${ifs}
			fi
		done
	fi
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "Tehuti workaound";
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--pre)
    ;;
	--post)
	if is_tehuti_interface $IFNAME ; then
		retry_count=0
		need_retry="yes"
		while [ $retry_count -le $MAX_RETRY ] && [ "$need_retry" = "yes" ]
		do
			need_retry="no"
			retry_count=$(($retry_count + 1))
			if mkdir $LOCK_PATH ; then
				#Lock success
				if [ ! -e $COUNTER_FILE ]; then
					echo "0" > $COUNTER_FILE
				fi
				tehuti_workaround
				rm -rf $LOCK_PATH
			else
				need_retry="yes"
				sleep 5
			fi
		done
	fi
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

