#!/bin/sh

###############################################################
#   This script should be hooked when invoking share_set hook.
#   Usable environment variable:
#       ORIGIN_SHARE_NAME, ORIGIN_SHARE_STATUS, ORIGIN_SHARE_PATH, SHARE_NAME, SHARE_STATUS, SHARE_PATH
###############################################################

SNAPTREE_BINARY=/usr/syno/sbin/synosharesnaptree
SYNOFSTOOL_BINARY=/usr/syno/sbin/synofstool
TMP_DELETE_SHARE_ATTR_DIR="/tmp/deleteshareattr"

GetFsType() {
	$SYNOFSTOOL_BINARY --get-fs-type "$1"
}

GetShareAttr() {
	mkdir -p "$TMP_DELETE_SHARE_ATTR_DIR"
	VOLUME_NAME=$(dirname "$ORIGIN_SHARE_PATH")
	if [ "btrfs" = "$(GetFsType "$VOLUME_NAME")" ]; then
		cp "$VOLUME_NAME/@eaDir/$ORIGIN_SHARE_NAME/SYNO@.attr" "$TMP_DELETE_SHARE_ATTR_DIR/$ORIGIN_SHARE_NAME.attr"
	fi
}

CheckShareCreate() {
	if [ "" = "${ORIGIN_SHARE_NAME}" ] && [ "" != "${SHARE_NAME}" ] && [ "btrfs" = "$(GetFsType "$SHARE_PATH")" ]; then
		IS_CREATE=1
	fi
}

CheckShareRenameOrMove() {
	# if origin share name is empty, skip it
	if [ "" = "${ORIGIN_SHARE_NAME}" ] ; then
		return
	fi

	# share name changed or share path changed
	if [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ]; then
		if [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ]; then
			if [ "btrfs" = "$(GetFsType "$SHARE_PATH")" ]; then
				IS_RENAME=1
			fi
		else
			IS_MOVE=1
		fi
	fi
}

case $1 in
	--sdk-mod-ver)
		echo "2.0" ;;
	--name)
		echo "SnapTreeChangeShareSet" ;;
	--pkg-ver)
		echo "1.0" ;;
	--vendor)
		echo "Synology Inc." ;;
	--pre)
		IS_MOVE=0
		CheckShareRenameOrMove
		if [ "1" = "${IS_MOVE}" ]; then
			GetShareAttr
		fi
		;;
	--post)
		#Actions after share set
		IS_CREATE=0
		IS_RENAME=0
		IS_MOVE=0

		if [ "0" != "${RESULT}" ]; then
			exit 0
		fi

		#Check hook condition
		CheckShareCreate
		CheckShareRenameOrMove

		if [ "1" = "${IS_CREATE}" ]; then
			# check if the share is clone rather than create
			if [ -e "/tmp/shareclone_$SHARE_NAME" ]; then
				rm "/tmp/shareclone_$SHARE_NAME"
				exit 0
			fi
			${SNAPTREE_BINARY} --create_share "$SHARE_PATH"
		elif [ "1" = "${IS_RENAME}" ]; then
			${SNAPTREE_BINARY} --rename_share "$ORIGIN_SHARE_PATH" -s "$SHARE_PATH"
		elif [ "1" = "${IS_MOVE}" ]; then
			${SNAPTREE_BINARY} --move_share "$ORIGIN_SHARE_PATH" -s "$SHARE_PATH"
			if [ -e "$TMP_DELETE_SHARE_ATTR_DIR/$ORIGIN_SHARE_NAME.attr" ]; then
				rm -f "$TMP_DELETE_SHARE_ATTR_DIR/$ORIGIN_SHARE_NAME.attr"
			fi
		fi

		;;
	*)
		echo "Usage: $0 --sdk_mod_ver|--name|--pkg_ver|--vendor|--pre|--post" ;;
esac
