#!/bin/sh

###############################################################
#   This script should be hooked when invoking share_snapshot hook.
###############################################################

SNAPTREE_BINARY=/usr/syno/sbin/synosharesnaptree

#At begining, acquire package settings
case $1 in
	--sdk-mod-ver)
		echo "2.0" ;;
	--name)
		echo "SnapTreeChangeShareSnapshot" ;;
	--pkg-ver)
		echo "1.0" ;;
	--vendor)
		echo "Synology Inc." ;;
	--pre)
		case $ACTION in
			CLONE_SHARE|CLONE_SNAP)
				touch "/tmp/shareclone_$NEW_SHARE_NAME"
			;;
		esac
		;;
	--post)
		if [ "0" != "${RESULT}" ]; then
			exit 0
		fi

		case $ACTION in
			CREATE)
				${SNAPTREE_BINARY} --create_snapshot $SNAPSHOT -s "$SHARE_PATH"
			;;
			RESTORE)
				${SNAPTREE_BINARY} --restore "$SHARE_PATH" -s $SNAPSHOT
			;;
			CLONE_SHARE)
				${SNAPTREE_BINARY} --clone_share "$SHARE_PATH" -s "$NEW_SHARE_PATH"
			;;
			CLONE_SNAP)
				${SNAPTREE_BINARY} --clone_snapshot "$NEW_SHARE_PATH" -s "$SHARE_PATH" -n $SNAPSHOT
			;;
			DELETE)
				SNAPSHOTS=$(echo "$SNAPSHOT" | tr " " "\n")
				for ONE_SNAPSHOT in $SNAPSHOTS
				do
					${SNAPTREE_BINARY} --delete_snapshot $ONE_SNAPSHOT -s "$SHARE_PATH"
				done
			;;
			RECEIVE)
				SNAPSHOTS=$(echo "$SNAPSHOT" | tr " " "\n")
				for ONE_SNAPSHOT in $SNAPSHOTS
				do
					${SNAPTREE_BINARY} --create_snapshot $ONE_SNAPSHOT -s "$SHARE_PATH"
				done
			;;
			*)
			;;

		esac
		;;
	*)
		echo "Usage: $0 --sdk_mod_ver|--name|--pkg_ver|--vendor|--pre|--post" ;;
esac
