#!/bin/bash
# Copyright (c) 2019 Synology Inc. All rights reserved.

SYNOSERVICE="/usr/syno/sbin/synoservice"
SMBCONTROL="/usr/bin/smbcontrol"

usage()
{
	local H="[1m"
	local E="[0m"
	cat <<EOF
Usage: `basename $0` <actions>
Actions:
 $H --check_status$E        service is disable or okay: 0, something is error: 1.
 $H --ping$E                smbcontrol ping smbd
 $H -h, --help$E            show this help message
EOF
}

smb_is_enabled()
{
	${SYNOSERVICE} --is-enable samba > /dev/null
	[[ 1 = $? ]]
}

smb_service_status()
{
	${SYNOSERVICE} --status samba > /dev/null
}

smb_ping()
{

	if ! smb_is_enabled; then
		return 0
	fi

	smb_service_status
	smb_status=$?

	case ${smb_status} in
		0)
			$SMBCONTROL smbd ping > /dev/null
			if [[ 0 = $? ]]; then
				return 0
			fi
			smb_service_status
			smb_status=$?
			if [[ 0 = ${smb_status} ]]; then
				return 1
			fi
			return 0
			;;
		3)
			return 0
			;;
		*)
			return 1
			;;
	esac
}

case $1 in
	--check_status)
		smb_service_status
		;;
	--ping)
		smb_ping
		;;
	-h|--help)
		usage "$@"
		;;
	*)
		usage "$@" >&2
		exit ${LSB_ERR_ARGS:-2}
		;;
esac

exit $?
