#!/bin/sh

PKGS_READY_CONF="/etc/init/syno-packages-ready.override"

main() {
    local pkgs=$(/usr/syno/bin/synopkg list --name)
    local start_on="start on stopped 3rdparty-services"
    local to_upgrade_pkg=($(/usr/syno/etc/rc.sysv/syno-pkg-upgrade.sh get_queue))

    for pkg in $pkgs; do
        [[ " ${to_upgrade_pkg[*]} " == *" $pkg "* ]] && continue
        /usr/syno/sbin/synoservice --is-enabled pkgctl-$pkg
        [ 1 == $? ] && start_on+=" and (started pkgctl-$pkg or stopped pkgctl-$pkg)"
    done
    /bin/rm -f $PKGS_READY_CONF
    /bin/echo $start_on > $PKGS_READY_CONF
}


main
