/* Copyright (c) 2019 Synology Inc. All rights reserved. */

Ext.namespace("SYNO.SDS.App.PersonalSettings");Ext.define("SYNO.SDS.App.PersonalSettings.LoginHistory",{extend:"Ext.util.Observable",itemsPerPage:50,appInst:null,grid:null,perItemPageKey:"loginHistoryItemsPage",constructor:function(b){var d=b.baseURL;this.baseURL=d;this.topwin=b.topwin;this.appInst=b.appInst;this.owner=b.owner;var a=this.appInst.getUserSettings(this.perItemPageKey);this.itemsPerPage=a?a:this.itemsPerPage;SYNO.SDS.App.PersonalSettings.LoginHistory.superclass.constructor.call(this,b);this.tbar=new Ext.Toolbar({items:[{xtype:"syno_button",text:_T("personal_settings","manage_trust_info"),itemId:"manageTokenBtn",disabled:true,scope:this,handler:function(){this.openDialog()}}]});this.paging=new SYNO.ux.PagingToolbar({store:this.getStore(),displayInfo:true,pageSize:this.itemsPerPage,refreshText:_T("log","log_reload")});var c=new SYNO.ux.GridPanel({title:b.title,itemId:"login_history",viewConfig:{forceFit:true},store:this.getStore(),colModel:this.getCM(),tbar:this.tbar,bbar:this.paging,autoExpandColumn:"descr",loadMask:true,stripeRows:true,refresh:this.paging.doRefresh.createDelegate(this.paging),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onChangeSelection}}),listeners:{scope:this,afterrender:function(e){e.on("rowdblclick",function(f,g){this.openDialog()},this)},activate:function(e){e.getStore().load({params:{start:0,limit:this.itemsPerPage}})}}});this.grid=c},getPanel:function(){return this.grid},getStore:function(){if(this.store){return this.store}var b=this;var a=new SYNO.API.JsonStore({api:"SYNO.Core.SyslogClient.PersonalActivity",version:"1",method:"loginhistory",appWindow:this.topwin,baseParams:{start:0,limit:this.TotalRecords,target:"LOCAL",logtype:"connection",dir:"desc"},root:"items",fields:["time","ip","protocol","db_path","event",{name:"user",convert:function(d,c){return b.whoRender(d,c)}},{name:"place",convert:function(d,c){return b.placeRender(d,c)}}],sortInfo:{field:"time",direction:"DESC"},listeners:{scope:this,load:function(c){this.grid.doLayout();this.grid.getView().updateScroller()}}});this.store=a;this.topwin.addManagedComponent(a);return a},getCM:function(){if(this.cm){return this.cm}var a=new Ext.grid.ColumnModel({columns:[{header:_T("log","log_time"),dataIndex:"time",width:50,align:"center",renderer:function(c){var b=Date.parseDate(c,"Y/m/d H:i:s");return SYNO.SDS.DateTimeFormatter(b)}},{header:_T("log","log_account"),dataIndex:"user",width:30,hidden:true,align:"center"},{id:"protocol",header:_T("personal_settings","login_protocol"),dataIndex:"protocol",width:30,align:"center"},{id:"ip",header:_T("common","ip_addr"),dataIndex:"ip",width:50,align:"center"},{id:"place",header:_T("personal_settings","login_place"),dataIndex:"place",width:50,align:"center"},{id:"event",header:_T("log","log_action"),dataIndex:"event",width:70,align:"left"}],defaults:{sortable:true,renderer:this.qtipRenderer,menuDisabled:true}});this.cm=a;return a},openDialog:function(){var a=this.grid.getSelectionModel().getSelected();if(!a){return}var b=new SYNO.SDS.App.PersonalSettings.LoginHistoryDialog({owner:this.owner,record:a});b.open()},qtipRenderer:function(c,b){var a=Ext.util.Format.htmlEncode(c);b.attr='ext:qtip="'+Ext.util.Format.htmlEncode(a)+'"';return a},onChangeSelection:function(){var a=this.grid.getSelectionModel().getSelected();var b=this.tbar.getComponent("manageTokenBtn");if(a){b.setDisabled(false)}else{b.setDisabled(true)}},placeRender:function(b,a){if(!a.is_public_ip){return _T("personal_settings","private_ip")}else{if(a.country.empty()){return _T("personal_settings","geoip_lookup_failed")}else{return _T("Country",a.country)}}},whoRender:function(b,a){if(b.empty()){return"-"}return b}});Ext.define("SYNO.SDS.App.PersonalSettings.CurUserConn",{extend:"Ext.util.Observable",itemsPerPage:50,firstActivated:true,appInst:null,grid:null,constructor:function(b){var d=b.baseURL;this.baseURL=d;this.topwin=b.topwin;this.ownerWindow=b.owner;this.appInst=b.appInst;var a=this.appInst.getUserSettings("curconnItemsPage");this.itemsPerPage=a?a:this.itemsPerPage;SYNO.SDS.App.PersonalSettings.CurUserConn.superclass.constructor.call(this,b);this.paging=new SYNO.ux.PagingToolbar({store:this.getCurConnStore(),displayInfo:true,pageSize:this.itemsPerPage,refreshText:_T("log","log_reload")});var c=new SYNO.ux.GridPanel({title:b.title,itemId:"currUserConn",cls:"account-activity-connected-user",viewConfig:{forceFit:true},store:this.getCurConnStore(),colModel:this.getCurrConCM(),bbar:this.paging,autoExpandColumn:"descr",loadMask:true,stripeRows:true,refresh:this.paging.doRefresh.createDelegate(this.paging),listeners:{scope:this,activate:function(e){e.getStore().load({params:{start:0,limit:this.itemsPerPage}})}}});this.grid=c;this.grid.on("cellclick",this.onGridCellClick,this,{buffer:500})},getPanel:function(){return this.grid},getCurConnStore:function(){if(this.dsCurCon){return this.dsCurCon}var a=new SYNO.API.JsonStore({fields:["pid","who","time","descr","type","from","can_be_kicked","user_can_be_disabled"],root:"items",totalProperty:"total",api:"SYNO.Core.CurrentConnection",method:"list_by_user",version:"1",appWindow:this.topwin,sortInfo:{field:"time",direction:"DESC"},remoteSort:true});this.dsCurCon=a;this.topwin.addManagedComponent(a);return a},getCurrConCM:function(){if(this.cmCurrCon){return this.cmCurrCon}var a=new Ext.grid.ColumnModel({columns:[{header:_T("log","log_time"),dataIndex:"time",width:160,align:"center",renderer:function(c){var b=Date.parseDate(c,"Y/m/d H:i:s");return SYNO.SDS.DateTimeFormatter(b)}},{header:_T("log","log_account"),dataIndex:"who",width:100,align:"center",hidden:true,renderer:this.whoRender},{header:_T("log","log_client"),dataIndex:"from",width:144,align:"center"},{header:_T("routerconf","routerconf_header_service"),dataIndex:"type",width:100,align:"center"},{id:"descr",header:_T("log","log_resource"),dataIndex:"descr",width:170,align:"left",renderer:this.htmlEncodeRender},{id:"kick",header:_T("connections","kick_connection"),sortable:false,dataIndex:"can_be_kicked",width:88,renderer:this.kickRenderer}],defaults:{sortable:true,menuDisabled:true}});this.cmCurrCon=a;return a},htmlEncodeRender:function(c,b){var a=Ext.util.Format.htmlEncode(c);b.attr='ext:qtip="'+Ext.util.Format.htmlEncode(a)+'"';return a},whoRender:function(b,a){if(b.empty()){return"-"}return b},kickRenderer:function(c){var b=_T("connections","kick_connection");if(false===c){return""}if(_S("demo_mode")){b=_T("common","error_demo")}var a=String.format('<div class = "syno-sysinfo-disconn-button" ext:qtip = "{0}"></div>',b);return a},kickConnection:function(b,a){this.grid.mask(_T("common","loading"));this.topwin.sendWebAPI({api:"SYNO.Core.CurrentConnection",method:"kick_connection",timeout:450000,params:{service_conn:b,http_conn:a},version:1,scope:this,callback:function(c,d){this.grid.unmask();if(!c){this.grid.mask(SYNO.API.Errors.core[d.code]||_T("common","commfail"))}else{this.getCurConnStore().load()}}})},onGridCellClick:function(a,g,h,i){if(_S("demo_mode")){return}var d=a.getColumnModel().getIndexById("kick");var f=i.getTarget("div",1,true);var j=null;if(!f){return}j=this.getCurConnStore().getAt(g);if(h===d){if(false===j.get("can_be_kicked")){return}var b=[],e=[],c=false;if("HTTP/HTTPS"===j.get("type")){e.push({who:j.get("who"),from:j.get("from")})}else{b.push({pid:j.get("pid"),type:j.get("type"),who:j.get("who"),from:j.get("from")})}if(_S("user")===j.get("who")){c=true}if(c){this.ownerWindow.getMsgBox().confirm(_T("connections","connections_title"),_T("connections","confirm_kick_self"),function(k,l){if(k=="yes"){this.kickConnection(b,e)}},this)}else{this.kickConnection(b,e)}}}});Ext.define("SYNO.SDS.App.PersonalSettings.LoginHistoryDialog",{extend:"SYNO.SDS.ModalWindow",title:_T("personal_settings","login_history_inspect"),constructor:function(b){this.formPanel=this.createFormPanel(b.record);var a={width:500,height:540,layout:"fit",items:[this.formPanel],buttons:[{xtype:"syno_button",text:_T("personal_settings","set_login_untrusted"),disabled:true,id:(this.clearBtnId=Ext.id()),scope:this,handler:this.onClearBtnClick},{xtype:"syno_button",text:_T("common","alt_close"),scope:this,handler:this.close}]};Ext.apply(a,b);this.callParent([a])},createFormPanel:function(a){var b=[{xtype:"syno_fieldset",title:_T("personal_settings","basic_info"),itemId:"basicInfo",items:[{xtype:"syno_displayfield",fieldLabel:_T("personal_settings","login_username"),name:"user",value:a.get("user")},{xtype:"syno_displayfield",fieldLabel:_T("log","log_time"),name:"time",value:a.get("time")}]},{xtype:"syno_fieldset",title:_T("personal_settings","trust_info"),itemId:"trustInfo",items:[{xtype:"syno_displayfield",fieldLabel:_T("personal_settings","login_token"),itemId:"tokenStatus"},{xtype:"syno_displayfield",fieldLabel:_T("personal_settings","login_ip_address"),itemId:"ipStatus"},{xtype:"syno_displayfield",itemId:"abnormalLoginWarning",htmlEncode:false,hidden:true,value:String.format('<span class="syno-ux-note">{0}{1}</span> {2}',_T("common","note"),_T("common","colon"),_T("personal_settings","security_advisor_abnormal_login_warning"))}]},{xtype:"syno_fieldset",title:_T("personal_settings","extra_info"),itemId:"extraInfo",hidden:true,items:[{xtype:"syno_displayfield",fieldLabel:_T("personal_settings","login_protocol"),name:"protocol",hidden:true},{xtype:"syno_displayfield",fieldLabel:_T("common","country"),name:"country",hidden:true},{xtype:"syno_displayfield",fieldLabel:_T("personal_settings","login_operating_system"),name:"os",hidden:true},{xtype:"syno_displayfield",fieldLabel:_T("personal_settings","login_browser"),name:"browser",hidden:true}]}];return new SYNO.SDS.Utils.FormPanel({border:false,items:b,listeners:{scope:this,afterrender:function(){this.loadRecordDetail();this.checkAbnormalLogin()}}})},loadRecordDetail:function(){this.setStatusBusy({text:_T("common","loading")});this.sendWebAPI({api:"SYNO.Core.SyslogClient.PersonalActivity",method:"get",version:1,params:{db_path:this.record.get("db_path"),record_id:this.record.id},scope:this,callback:function(e,c,b){this.clearStatusBusy();if(!e){var d=SYNO.API.Errors.core[c.code]||_T("common","error_system");this.getMsgBox().alert(null,d,function(){this.close()},this);return}this.recordData=c.record;var a=this.formPanel.getForm();a.setValues(this.recordData);this.updateTokenStatus(this.recordData);this.updateIPStatus(this.recordData);this.updateClearBtn(this.recordData);this.updateCountry(this.recordData);this.showExtraFields(this.recordData)}})},checkAbnormalLogin:function(){this.setStatusBusy({text:_T("common","loading")});this.sendWebAPI({api:"SYNO.SecurityAdvisor.Conf.Checklist",method:"list",version:1,params:{group:"custom"},scope:this,callback:function(c,b,a){this.clearStatusBusy();if(!c){return}Ext.each(b.items,function(f){if(f.analyzer!="abnormal_login"||f.label!="AbnormalLogin"){return}if(f.enable){return}var e=this.formPanel.getForm();var d=e.findField("abnormalLoginWarning");d.setVisible(true)},this)}})},updateTokenStatus:function(a){var b=this.formPanel.getComponent("trustInfo");var c=b.getComponent("tokenStatus");if(!a.token_recorded){c.setValue(_T("personal_settings","info_is_unavailable"))}else{if(a.token_trusted){c.setValue(_T("personal_settings","info_is_trusted"))}else{c.setValue(_T("personal_settings","info_is_untrusted"))}}},updateIPStatus:function(b){var c=this.formPanel.getComponent("trustInfo");var a=c.getComponent("ipStatus");if(!b.ip){a.setValue(_T("personal_settings","info_is_unavailable"))}else{if(!b.is_public_ip){a.setValue(String.format("{0}, {1}",b.ip,_T("personal_settings","ignore_private_ip")))}else{if(b.ip_trusted){a.setValue(String.format("{0}, {1}",b.ip,_T("personal_settings","info_is_trusted")))}else{a.setValue(String.format("{0}, {1}",b.ip,_T("personal_settings","info_is_untrusted")))}}}},updateClearBtn:function(b){var c=Ext.getCmp(this.clearBtnId);var a=(b.token_recorded&&b.token_trusted);var d=(b.ip&&b.ip_trusted);if(a||d){c.setDisabled(false)}else{c.setDisabled(true)}},updateCountry:function(b){if(!Ext.isDefined(b.country)){return}var d=this.formPanel.getForm();var c=d.findField("country");var a=_T("Country",b.country);if(""===a){a=_T("personal_settings","geoip_lookup_failed")}c.setValue(a)},showExtraFields:function(a){var b=this.formPanel.getComponent("extraInfo");var c=false;Ext.each(b.items.items,function(d){if(Ext.isDefined(a[d.getName()])){d.setVisible(true);c=true}});if(c){b.setVisible(true)}},onClearBtnClick:function(){this.getMsgBox().confirm(null,_T("personal_settings","set_login_untrusted_confirm"),function(c){if(c!=="yes"){return}var a=false;var b=false;var d=this;var e=function(){if(a&&b){d.setStatusOK({text:_T("common","setting_applied")})}};this.clearRecord(function(){a=true;e()});this.kickConnections(function(){b=true;e()})},this)},clearRecord:function(a){this.setStatusBusy({text:_T("common","saving")});this.sendWebAPI({api:"SYNO.Core.SyslogClient.PersonalActivity",method:"clear",version:1,params:{record_id:this.record.id},scope:this,callback:function(e,c,b){this.clearStatusBusy();if(!e){var d=SYNO.API.Errors.core[c.code]||_T("common","error_system");this.getMsgBox().alert(null,d);return}this.recordData.token_trusted=false;this.recordData.ip_trusted=false;this.updateTokenStatus(this.recordData);this.updateIPStatus(this.recordData);this.updateClearBtn(this.recordData);a()}})},kickConnections:function(a){this.setStatusBusy({text:_T("common","saving")});this.sendWebAPI({api:"SYNO.Core.CurrentConnection",method:"list_by_user",version:1,scope:this,callback:function(g,e,d){if(!g){var f=SYNO.API.Errors.core[e.code]||_T("common","error_system");this.getMsgBox().alert(null,f);this.clearStatusBusy();return}var c=[];var b=[];Ext.each(e.items,function(h){if(h.from!==this.recordData.ip){return}if("HTTP/HTTPS"===h.type){b.push({who:h.who,from:h.from})}else{c.push({pid:h.pid,type:h.type,who:h.who,from:h.from})}},this);this.sendWebAPI({api:"SYNO.Core.CurrentConnection",method:"kick_connection",timeout:450000,params:{service_conn:c,http_conn:b},version:1,scope:this,callback:function(k,i,h){this.clearStatusBusy();if(!k){var j=SYNO.API.Errors.core[i.code]||_T("common","error_system");this.getMsgBox().alert(null,j);return}a()}})}})}});Ext.namespace("SYNO.SDS.App.PersonalSettings");Ext.define("SYNO.SDS.App.PersonalSettings.TrustDevice",{extend:"SYNO.ux.Panel",constructor:function(a){this.topwin=a.topwin;this.appInst=a.appInst;this.callParent([this.fillConfig(a)])},fillConfig:function(b){var a={cls:"syno-sds-personal-trustdevice",items:this.getItems(),listeners:{afterrender:{fn:function(){this.getTrustDeviceRecord()},single:true,scope:this},activate:{fn:function(){if(!this.topwin.accountPanel.OTPenabled){this.getEl().mask(_T("trustdevice","enable_otp_to_manage_trustdevice"))}else{this.getEl().unmask()}this.hideRefreshBtn()},scope:this},deactivate:{fn:function(){this.showRefreshBtn()},scope:this}}};return Ext.apply(a,b)},getItems:function(){var a=[{xtype:"container",cls:"trust-device-wrap first",layout:"column",items:[{xtype:"container",cls:"device-icon-wrap",items:[{xtype:"box",cls:"this-device-icon device-icon"}]},{xtype:"container",columnWidth:1,cls:"trustdevice-content-wrap",items:[{xtype:"container",cls:"trustdevice-content",items:[{xtype:"box",cls:"trustdevice-title",id:this.trustdeviceTitle=Ext.id(),html:_T("trustdevice","this_device_trusted")},{xtype:"box",cls:"trustdevice-desc",id:this.trustdeviceDesc=Ext.id(),html:String.format(_T("trustdevice","this_device_trusted_desc"),"1970/01/01")},{xtype:"syno_button",text:_T("trustdevice","untrust_this_device"),id:this.untrustdeviceBtn=Ext.id(),handler:this.onClickUntrustThisDevice,scope:this},{xtype:"syno_button",text:_T("trustdevice","trust_this_device"),id:this.trustdeviceBtn=Ext.id(),handler:this.onClickTrustThisDevice,scope:this}]}]}]},{xtype:"container",cls:"trust-device-wrap",layout:"column",items:[{xtype:"container",cls:"device-icon-wrap",items:[{xtype:"box",cls:"other-devices-icon device-icon"}]},{xtype:"container",columnWidth:1,cls:"trustdevice-content-wrap",items:[{xtype:"container",cls:"trustdevice-content",items:[{xtype:"box",cls:"trustdevice-title",html:_T("trustdevice","other_devices_trusted")},{xtype:"box",cls:"trustdevice-desc",html:_T("trustdevice","other_devices_trusted_desc")},{xtype:"syno_button",scope:this,handler:this.onClickUntrustOtherDevices,text:_T("trustdevice","untrust_other_devices")}]}]}]}];return a},getTpl:function(){},hideRefreshBtn:function(){this.findWindow().getFooterToolbar().getComponent("refresh_btn").hide()},showRefreshBtn:function(){this.findWindow().getFooterToolbar().getComponent("refresh_btn").show()},getTrustDeviceRecord:function(){this.findWindow().setStatusBusy();this.sendWebAPI({api:"SYNO.Core.TrustDevice",version:1,method:"get",params:{},scope:this,callback:function(a,b,c){this.findWindow().clearStatusBusy();if(!a){this.toUntrustedMode();return}this.toTrustedMode(b.ctime)}})},toTrustedMode:function(d){var b=Ext.getCmp(this.trustdeviceDesc).getEl();var a=Ext.getCmp(this.trustdeviceTitle).getEl();var f=Ext.getCmp(this.trustdeviceBtn);var e=Ext.getCmp(this.untrustdeviceBtn);var c='<span class="date"> {0} </span>';f.hide();e.show();b.update(String.format(_T("trustdevice","this_device_trusted_desc"),String.format(c,this.getDate(d))));a.update(_T("trustdevice","this_device_trusted"))},toUntrustedMode:function(){var b=Ext.getCmp(this.trustdeviceDesc).getEl();var a=Ext.getCmp(this.trustdeviceTitle).getEl();var d=Ext.getCmp(this.trustdeviceBtn);var c=Ext.getCmp(this.untrustdeviceBtn);d.show();c.hide();b.update(_T("trustdevice","this_device_untrusted_desc"));a.update(_T("trustdevice","this_device_untrusted"))},getDate:function(a){return SYNO.SDS.DateTimeFormatter(new Date(a*1000))},getName:function(){var d="{0}-{1}",c="others",b="others",a;if(Ext.isLinux){c="Linux"}else{if(Ext.isMac){c="Mac"}else{if(Ext.isWindows){c="Windows"}}}if(Ext.isGecko){b="FireFox"}else{if(Ext.isIE){b="IE"}else{if(Ext.isChrome){b="Chrome"}else{if(Ext.isOpera){b="Opera"}else{if(Ext.isSafari){b="Safari"}else{if(Ext.isEdge){b="Edge"}}}}}}a=String.format(d,c,b);return a},onClickTrustThisDevice:function(){this.sendWebAPI({api:"SYNO.Core.TrustDevice",version:1,method:"create",params:{name:this.getName()},scope:this,callback:function(a,b,d){var c=this.findWindow();c.clearStatusBusy();if(!a){c.setStatusError({clear:true});return}this.toTrustedMode(b.ctime);c.setStatusOK()}})},onClickUntrustThisDevice:function(){this.findWindow().setStatusBusy();this.sendWebAPI({api:"SYNO.Core.TrustDevice",version:1,method:"delete",params:{},scope:this,callback:function(a,b,d){var c=this.findWindow();c.clearStatusBusy();if(!a){c.setStatusError({clear:true});return}this.toUntrustedMode();c.setStatusOK()}})},onClickUntrustOtherDevices:function(){this.sendWebAPI({api:"SYNO.Core.TrustDevice",version:1,method:"delete_others",params:{},scope:this,callback:function(a,b,d){var c=this.findWindow();c.clearStatusBusy();if(!a){c.setStatusError({clear:true});return}c.setStatusOK()}})}});Ext.define("SYNO.SDS.App.PersonalSettings.AccountActivityWin",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){Ext.apply(this,a);this.tabpanel=this.createTabPanel(a.activeTab);var b={owner:this.owner,resizable:true,minimizable:false,maximizable:false,closable:true,layout:"fit",width:700,minWidth:700,height:490,title:_T("personal_settings","current_login_status"),items:[this.tabpanel],buttons:[{text:_T("common","refresh"),itemId:"refresh_btn",handler:function(){this.tabpanel.getActiveTab().refresh()},scope:this},{text:_T("common","close"),handler:this.close,scope:this}]};this.callParent([b])},createTabPanel:function(a){this.curUserConn=new SYNO.SDS.App.PersonalSettings.CurUserConn({title:_T("connections","connections_title"),owner:this,topwin:this.topwin,appInst:this.appInst,baseURL:"modules/SystemInfoApp"});this.curUserConnPenl=this.curUserConn.getPanel();this.loginHistory=new SYNO.SDS.App.PersonalSettings.LoginHistory({title:_T("personal_settings","current_login_history"),owner:this,topwin:this.topwin,appInst:this.appInst,baseURL:"modules/LogCenter"});this.loginHistoryPanel=this.loginHistory.getPanel();this.trustDevicePanel=new SYNO.SDS.App.PersonalSettings.TrustDevice({title:_T("trustdevice","trust_device"),owner:this,topwin:this.topwin,appInst:this.appInst});return new SYNO.ux.TabPanel({plain:true,activeTab:a,items:[this.curUserConnPenl,this.trustDevicePanel,this.loginHistoryPanel]})}});Ext.define("SYNO.SDS.App.PersonalSettings.AccountForm",{extend:"SYNO.SDS.Utils.FormPanel",isUserInfoEditable:false,isLDAP:function(){return"ldap"===_S("authType")},isDomain:function(){return"domain"===_S("authType")},constructor:function(c){this.otp_settings_btn=new SYNO.ux.Button({indent:1,name:"otp_settings_btn",text:_T("personal_settings","otp_settings"),scope:this,disabled:true,handler:this.launchOTPwizard});this.currentUserConnectionBtn=new SYNO.ux.Button({name:"current_user_connection_btn",text:_T("personal_settings","current_login_status"),scope:this,handler:function(){this.launchCurrentConnection(0)}});var a={username:{xtype:"syno_displayfield",name:"username",fieldLabel:_T("user","user_account")},fullname:{xtype:"syno_textfield",name:"fullname",maxlength:64,fieldLabel:_T("user","user_fullname")},old_password:{xtype:"syno_textfield",textType:"password",name:"old_password",maxlength:128,fieldLabel:_T("user","user_passwd"),validator:(function(e){var d=this.getForm().findField("password");if(d.isDirty()&&Ext.isEmpty(e)){return false}return true}).createDelegate(this)},password:{xtype:"syno_passwordfield",updateWhenRender:false,textType:"password",name:"password",maxlength:128,fieldLabel:_T("user","user_passwd_new"),validator:(function(e){var d=this.getForm().findField("old_password");if(d&&d.isDirty()&&(Ext.isEmpty(e)||this.isFakePasswd())){return false}if(d&&e==d.value){return false}if(!this.startValidate||this.isFakePasswd()){return true}if(this.strongPassValidator){return this.strongPassValidator.isStrongValidator()}return true}).createDelegate(this),listeners:{blur:{fn:function(d){d.validate()},scope:this},afterrender:function(){this.hidePasswordStrength()},password_strength_get:function(){this.showPasswordStrength()}}},password2:{xtype:"syno_textfield",textType:"password_confirm",name:"password2",maxlength:128,confirmFor:"password",fieldLabel:_T("user","user_repswd")},email:{xtype:"syno_textfield",name:"email",maxlength:512,vtype:"email",fieldLabel:_T("user","user_email")},language:{xtype:"syno_combobox",name:"language",fieldLabel:_T("language","lang_display_field"),width:270,displayField:"display",valueField:"value",tpl:new Ext.XTemplate('<tpl for=".">','<div class="x-combo-list-item" ext:qtip="{display}">',"{display}","</div>","</tpl>"),store:this.getLangStore()},dateFormat:{xtype:"syno_combobox",name:"dateFormat",fieldLabel:_T("personal_settings","date_format"),displayField:"display",valueField:"value",tpl:new Ext.XTemplate('<tpl for=".">','<div class="x-combo-list-item" role="option" aria-label="{display}" id="{[Ext.id()]}" ext:qtip="{display}">',"{display}","</div>","</tpl>"),store:SYNO.SDS.DateTimeUtils.CreateDateFormatStore(true)},timeFormat:{xtype:"syno_combobox",name:"timeFormat",fieldLabel:_T("personal_settings","time_format"),displayField:"display",valueField:"value",tpl:new Ext.XTemplate('<tpl for=".">','<div class="x-combo-list-item" role="option" aria-label="{display}" id="{[Ext.id()]}" ext:qtip="{display}">',"{display}","</div>","</tpl>"),store:SYNO.SDS.DateTimeUtils.CreateTimeFormatStore(true)},OTP_enable:{xtype:"syno_checkbox",name:"OTP_enable",boxLabel:_T("personal_settings","otp_enable_desc")},OTP_enforced:{xtype:"hidden",name:"OTP_enforced"},OTP_settings_btn:this.otp_settings_btn,currentUserConnection:{xtype:"syno_displayfield",name:"current_user_connection",hideLabel:true,value:_T("personal_settings","watch_current_login_status")},currentUserConnectionBtn:this.currentUserConnectionBtn,change_password_url:{xtype:"syno_displayfield",htmlEncode:false,itemId:"change_password_url"}};var b=Ext.apply({itemId:"account",trackResetOnLoad:true,title:_T("tree","leaf_account"),listeners:{afterlayout:{single:true,scope:this,fn:this.onAfterLayout}},fieldWidth:270,labelWidth:180,items:[]},c);if(this.isLDAP()){Ext.each(["username","fullname","email","password","password2","language","dateFormat","timeFormat","OTP_enforced","OTP_enable","OTP_settings_btn","currentUserConnection","currentUserConnectionBtn","change_password_url"],function(d){b.items.push(a[d])})}else{Ext.each(["username","fullname","old_password","password","password2","email","language","dateFormat","timeFormat","OTP_enforced","OTP_enable","OTP_settings_btn","currentUserConnection","currentUserConnectionBtn"],function(d){b.items.push(a[d])})}this.callParent([b]);this.on("showloginhistory",function(){this.launchCurrentConnection("login_history")},this)},destroy:function(){delete this.strongPassValidator},isFakePasswd:function(){var a=this.getForm().findField("password").getValue();var b=this.getForm().findField("password2").getValue();if(a==="12345678"&&b==="87654321"){return true}return false},isPersonalMailEnable:function(a){this.module.setStatusBusy();this.sendWebAPI({api:"SYNO.PersonMailAccount",method:"get",version:1,scope:this,callback:function(c,b){this.module.clearStatusBusy();if(c&&(b.data.size()>0)){this.launchOTPwizard()}else{this.module.getMsgBox().confirm(this.title,_T("otp_enforcement","enforce_mail_notification_service"),function(d){if(d==="yes"){this.getForm().reset();var e={owner:this.module,module:this,appInstance:this.module.appInstance,blFirstCreate:true};var f=new SYNO.SDS.App.PersonalSettings.EmailAccountWizard(e);f.onOpen()}else{a.setValue(false)}},this)}}})},onCheckOTPenable:function(b,a){if(a){this.isPersonalMailEnable(b)}else{this.otp_settings_btn.disable()}},launchCurrentConnection:function(a){var b=this.module;var c=new SYNO.SDS.App.PersonalSettings.AccountActivityWin({owner:b,topwin:b,activeTab:a,appInst:b.appInstance});c.show()},launchOTPwizard:function(){var a;a=this.getForm().findField("email").getValue();var b={owner:this.module,module:this,mail:a,triggerCheckbox:this.getForm().findField("OTP_enable"),accountMailField:this.getForm().findField("email"),appInstance:this.module.appInstance};this.OTPwizard=new SYNO.SDS.App.PersonalSettings.OTPWizard(b);this.OTPwizard.onOpen()},onAfterLayout:function(){this.loadPasswordRules();this.loadForm()},loadForm:function(){this.module.setStatusBusy();this.sendWebAPI({api:"SYNO.Core.NormalUser",method:"get",version:1,scope:this,callback:function(d,b,a){this.module.clearStatusBusy();if(!d){var c;if(Ext.isObject(b.errors)){c=_T(b.errors.sec,b.errors.key)}else{c=SYNO.API.Errors.core[b.code]||_T("common","error_system")}this.module.getMsgBox().alert(this.module.title,c);return false}this.processReturnData(b)}})},applyForm:function(){var b=this.getForm();var a=[];if(!b.isValid()){this.module.getMsgBox().alert(this.module.title,_T("error","error_bad_field"));return}if((!b.isDirty()&&!this.OTPenabled)){this.module.doClose();return}this.module.setStatusBusy({text:_T("common","saving")});if(this.isLDAP()&&b.findField("password").isDirty()){a.push({api:"SYNO.Core.Directory.LDAP",method:"password",params:this.processLDAPParams(),version:1})}if(this.isDomain()&&b.findField("old_password").isDirty()){a.push({api:"SYNO.Core.Directory.Domain",method:"set_password",params:this.processDomainParams(),encryption:["password","old_password"],version:1})}a.push({api:"SYNO.Core.NormalUser",method:"set",params:this.processParams(),encryption:["password","old_password"],version:2});this.sendWebAPI({compound:{params:a},encryption:["password"],scope:this,callback:function(h,c,g,e){this.module.clearStatusBusy();if(!h||c.has_fail){var d=SYNO.API.Util.GetFirstError(c);var f=SYNO.API.Errors.core[d.code]||_T("common","error_system");this.module.getMsgBox().alert(this.module.title,f);return false}this.module.doClose()}})},resetForm:function(){this.getForm().reset()},processParams:function(){var a=this.getForm();var b={};var c=a.findField("OTP_enable");if((c.isDirty()&&c.getValue()===false)||(this.OTPenabled&&c.getValue()===false)){b.disableOTP=true}Ext.each(["fullname","old_password","password","email"],function(e){var d=a.findField(e);if(d&&d.isDirty()){b[e]=d.value}},this);return b},processLDAPParams:function(){var a=this.getForm();var b={};b.username=_S("user").split("@")[0];if(a.findField("password").isDirty()){b.password=a.findField("password").value}return b},processDomainParams:function(){var a=this.getForm();var b={};b.password=a.findField("password").value;b.old_password=a.findField("old_password").value;return b},processReturnData:function(g){var d=this.getForm();var e=SYNO.SDS.UserSettings.getProperty("Personal","lang")||"def";d.setValues({username:g.username,fullname:g.fullname,email:g.email,OTP_enable:g.OTP_enable,OTP_enforced:g.OTP_enforced,language:e,dateFormat:SYNO.SDS.DateTimeUtils.GetDateFormat(),timeFormat:SYNO.SDS.DateTimeUtils.GetTimeFormat(),password:"12345678",password2:"87654321"});this.startValidate=true;if((_S("demo_mode")&&"admin"===_S("user"))||true===g.disallowchpasswd||(this.isLDAP()&&""!==g.change_password_url)){SYNO.SDS.Utils.DisplayField(d,"password",false);SYNO.SDS.Utils.DisplayField(d,"password2",false)}this.getForm().findField("username").label.setHeight(this.getForm().findField("username").getEl().getHeight());this.isUserInfoEditable=g.editable;if(this.isDomain()&&!this.isUserInfoEditable){d.findField("email").disable();d.findField("fullname").disable()}else{if(!this.isUserInfoEditable){d.findField("password").disable();d.findField("password2").disable();d.findField("email").disable();d.findField("fullname").disable()}}if(this.isLDAP()){if(""!==g.change_password_url){var b=d.findField("username").getValue();var c=Ext.urlAppend(g.change_password_url,Ext.urlEncode({action:"chprofile",uid:b}));var i=String.format("<u><a href='{0}' target='blank' tabIndex='-1'>{1}</a></u>",c,_T("common","here"));var h=String.format(_T("ldap","change_password_desc"),i);d.findField("fullname").disable();d.findField("email").disable();d.setValues({change_password_url:h})}d.findField("email").disable();d.findField("fullname").disable();this.startValidate=false}var f=d.findField("OTP_enable");var a=d.findField("OTP_enforced");if(f){if(a&&a.getValue()==="true"){f.disable();this.otp_settings_btn.enable()}else{f.addListener("check",this.onCheckOTPenable,this)}if(f.getValue()===true){this.OTPenabled=true;this.otp_settings_btn.enable()}}},getLangStore:function(){var b=SYNO.SDS.Utils.getSupportedLanguage(),a;b.unshift(["def",_T("common","sys_default_setting")]);a=new Ext.data.SimpleStore({fields:["value","display"],data:b});return a},loadPasswordRules:function(){if(this.isDomain()){return}this.module.setStatusBusy();this.sendWebAPI({api:"SYNO.Core.User.PasswordPolicy",version:1,method:"get",callback:function(f,d,c,b){this.module.clearStatusBusy();if(f&&d){var a=this;var e=d.strong_password||{};this.strongPassValidator=new SYNO.SDS.Utils.CheckStrongPassword();e.strong_password_enable=(Object.keys(e).length>0);this.strongPassValidator.passwordPolicy=Ext.apply({},e);this.strongPassValidator.initPasswordChecker({getForm:function(){return a.getForm()},getUserAcc:"username",getUserDesc:"fullname",getPasswd:"password",getPasswdConfirm:"password2",getStartValidate:function(){return this.getForm().findField("password").startValidate}})}},scope:this})}});Ext.define("SYNO.SDS.App.MailDialog.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.App.MailDialog.MainWindow",constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.App.MailDialog.MainWindow",{extend:"SYNO.SDS.AppWindow",constructor:function(){this.isSetAttach=false;this.contactCacheData={};this.email_type=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.App.PersonalSettings.Instance","email_type");this.alias=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.App.PersonalSettings.Instance","email_alias");var a=this.fillConfig();this.callParent([a]);this.mon(this,"afterlayout",this.onLoadData,this,{single:true})},fillConfig:function(){Ext.apply(this);var a={owner:this.owner,width:700,autoHeight:true,collapsible:false,resizable:false,showHelp:true,maximizable:false,title:_T("mail","application_title"),buttons:[{btnStyle:"blue",itemId:"submit_button",text:_T("common","send"),handler:this.onBeforeConfirm,disabled:_S("demo_mode"),scope:this},{text:_T("common","cancel"),handler:this.onClose,scope:this}],items:this.initPanel()};return a},initPanel:function(){var e=this;e.store=new Ext.data.JsonStore({fields:["name","address"],data:[],sortInfo:{field:"address",direction:"ASC"}});e.attachmentStore=new Ext.data.JsonStore({fields:["filename","path","filesize","formatsize","deleted"],data:[]});e.comboStore=new Ext.data.ArrayStore({fields:["alias","value","account"],data:[]});var c=new Ext.XTemplate('<tpl for="."><div class="x-combo-list-item" style="height: 53px"><div style="margin-left:10px"><tpl if="name!=address;"><div style="height:20px;margin-top:4px;font-weight:bold;">{name:htmlEncode}</div></tpl><div class="syno-mail-contactaccount">{address:htmlEncode}</div></div></div></tpl>');var f=new Ext.XTemplate('<tpl for="."><div class="x-combo-list-item" style="width:375px;border-color:transparent;"><div style="max-width:250px;overflow:hidden;float:left;text-overflow:ellipsis; white-space:nowrap;">{filename}</div> <div style="margin-left:5px;float:left;">({formatsize})</div></div></tpl>');var h=new Ext.XTemplate('<tpl if"name!=null && name!=&quot;&quot;";>{name:htmlEncode}</tpl><tpl if="name==null || name==&quot;&quot;">{address:htmlEncode}</tpl>');var g=function(j){var i=new RegExp("^"+j.query+"|\\s+"+j.query,"gi");this.store.filterBy(function(k){if(k.data.name&&null!==k.data.name.match(i)){return true}if(k.data.address&&null!==k.data.address.match(i)){return true}return false});j.combo.onLoad();return false};var d=function(j,i){if(""===i){return}j.addNewItem({name:i,address:i},true)};var b={autoFlexcroll:true,autoHeight:true,cls:"mail-dialog-superboxselect",useGradient:false,items:[{xtype:"syno_superboxselect",fieldLabel:_T("mail","mail_to_desc"),expandBtnCls:"mail-dialog-superboxselect-expand",itemId:"mail_to_field",width:465,hideTrigger:true,typeAhead:false,allowBlank:false,displayField:"name",displayFieldTpl:h,valueField:"address",allowAddNewData:true,addNewDataOnBlur:true,mode:"local",tpl:c,listeners:{newitem:d,beforequery:g,scope:this},store:e.store},{xtype:"syno_superboxselect",fieldLabel:_T("mail","mail_cc_desc"),itemId:"mail_cc_field",expandBtnCls:"mail-dialog-superboxselect-expand",width:465,hideTrigger:true,typeAhead:true,displayField:"name",displayFieldTpl:h,valueField:"address",allowAddNewData:true,addNewDataOnBlur:true,mode:"local",tpl:c,listeners:{newitem:d,beforequery:g,scope:this},store:e.store},{xtype:"syno_combobox",fieldLabel:_T("mail","mail_from_desc"),itemId:"mail_from",value:"",displayField:"account",width:465,store:e.comboStore,listeners:{select:function(j,k,i){this.email_type=k.data.value;this.alias=k.data.alias;this.loadContactData(this.email_type,this.alias)},scope:this}},{xtype:"syno_textfield",fieldLabel:_T("mail","mail_subject"),itemId:"mail_subject",width:465},{xtype:"syno_displayfield"},{xtype:"syno_tinymce",itemId:"htmleditor",owner:this,height:200,width:650,mceConfig:{plugins:["textcolor","filestation_attachment","syno_fontselect","syno_fontsizeselect"],toolbar:"syno_fontselect syno_fontsizeselect | forecolor backcolor | bold italic underline | alignleft aligncenter alignright | numlist bullist removeformat | filestation_attachment",statusbar:false,forced_root_block:"div",extended_valid_elements:"img[class|src|border=0|alt|title|hspace|vspace|width|height|align|name|ref|adjust|content_id]",menubar:false},listeners:{beforeAddAttach:this.checkAttach,initialize:this.initAttachment,scope:this}},{xtype:"syno_displayfield"},{xtype:"syno_superboxselect",cls:"mail-ie8-superboxselect",fieldLabel:_T("mail","mail_attachment"),itemId:"mail_attachment",expandBtnCls:"mail-dialog-superboxselect-expand",width:465,hideTrigger:true,typeAhead:false,editable:false,displayField:"filename",valueField:"path",allowAddNewData:true,addNewDataOnBlur:true,mode:"local",displayFieldTpl:f,hidden:!Ext.isIE8,disabled:!Ext.isIE8,store:e.attachmentStore}]};var a=new SYNO.ux.FormPanel(b);this.panel=a;return a},onOpen:function(d){this.appTitle=(Ext.isEmpty(d.appTitle))?"tree:leaf_filebrowser":d.appTitle;this.appName=(Ext.isEmpty(d.appName))?"dsm":d.appName;this.email_type=(Ext.isString(d.email_type))?d.email_type:this.email_type;this.alias=(Ext.isString(d.alias))?d.alias:this.alias;this.taskid=(Ext.isString(d.taskid))?d.taskid:"";this.mailContent=(Ext.isString(d.content))?d.content:"";this.attachmentList=(Ext.isArray(d.data))?d.data:this.parseObjectAttachment(d.data);this.inlineAttachment=(Ext.isObject(d.content_attachment))?this.parseObjectAttachment(d.content_attachment):[];var b=0,c=this.panel.getComponent("htmleditor").getEditor();if(c&&!this.isSetAttach){if(Ext.isIE8){this.addAttachRecord(this.attachmentList)}else{for(b=0;b<this.attachmentList.length;b++){var a=this.attachmentList[b];c.plugins.filestation_attachment.addAttachRecord(a)}}}this.callParent(arguments)},initAttachment:function(d,c){var b=0;c.plugins.filestation_attachment.initMode(c);if(!this.isSetAttach&&this.attachmentList){this.isSetAttach=true;if(Ext.isIE8){this.addAttachRecord(this.attachmentList)}else{for(b=0;b<this.attachmentList.length;b++){var a=this.attachmentList[b];c.plugins.filestation_attachment.addAttachRecord(a)}}}},onBeforeConfirm:function(){if(""===this.panel.getComponent("mail_to_field").getValue()){this.getMsgBox().alert("Title",_T("mail","mailto_alert"));return}if(""===this.panel.getComponent("mail_subject").getValue()){this.getMsgBox().confirm("Title",_T("mail","mail_subject_alert"),function(a){if("yes"===a){this.onConfirm()}},this);return}this.onConfirm()},onConfirm:function(){var g=this;var j=this.panel.getComponent("mail_to_field").getValue().split(",");var a=this.panel.getComponent("mail_cc_field").getValue();var h=this.panel.getComponent("mail_subject").getValue();var e=this.BodyValueGet();var c=0,d=[],f;var k=this.getAttachArray();for(c=0;c<k.length;c++){f=k[c];d.push({path:f.path,filesize:f.filesize,symlink:(Ext.isEmpty(f.symlink))?"":f.symlink,app_name:(Ext.isEmpty(f.app_name))?"dsm":f.app_name,deleted:(Ext.isEmpty(f.deleted))?false:f.deleted})}var b={app_name:this.appName,app_title:this.appTitle,email_type:this.email_type,alias:this.alias,to:Ext.encode(j),subject:h,body:e,attachment:Ext.encode(d),inline_attachment:Ext.encode(this.inlineAttachment)};if(!Ext.isEmpty(a)){b.cc=Ext.encode(a.split(","))}if(this.taskid&&""!==this.taskid){b.taskid=this.taskid}this.setStatusBusy();this.sendWebAPI({api:"SYNO.PersonMailAccount.Mail",method:"send",version:1,params:b,callback:function(n,i,l){if(n){g.onAddBkgTask(i.taskid);this.canClosed=true;this.close()}else{var m=SYNO.SDS.App.MailDialog.Utils.APIErrorGet(i.code);g.getMsgBox().alert("Title",m)}this.clearStatusBusy()},scope:this})},onAddBkgTask:function(a){var d=this.panel.getComponent("mail_from").getValue();var c=this.panel.getComponent("mail_to_field").getValue().split(",");var b=Ext.util.Format.htmlEncode(this.panel.getComponent("mail_subject").getValue());SYNO.SDS.MailTaskMgr.addWebAPITask({id:a,title:b||d,sender:d,reciever:c,subject:b,query:{api:"SYNO.PersonMailAccount.Mail",method:"status",version:1,params:{taskid:a}},cancel:{api:"SYNO.PersonMailAccount.Mail",method:"stop",version:1,params:{taskid:a}}})},setFormData:function(g){var c=0,e=this,b=[];var f=g.to.concat(g.cc);var a=null;for(c=0;c<f.length;c++){a=f[c];b.push({name:a,address:a})}this.store.loadData(b,true);this.panel.getComponent("mail_to_field").setValue(g.to.toString());this.panel.getComponent("mail_cc_field").setValue(g.cc.toString());this.panel.getComponent("mail_subject").setValue(g.subject);this.BodyValueSet(g.body);if(Ext.isIE8){this.addAttachRecord(g.attachment)}else{var d=e.panel.getComponent("htmleditor").getEditor();for(c=0;c<g.attachment.length;c++){a=g.attachment[c];d.plugins.filestation_attachment.addAttachRecord({path:a.path,filesize:a.filesize})}}if(!Ext.isEmpty(g.inline_attachment)){this.inlineAttachment=g.inline_attachment}},onLoadData:function(){var a=[];a.push({api:"SYNO.PersonMailAccount",method:"get",version:1});a.push({api:"SYNO.PersonMailAccount.Contacts",method:"list",version:1,params:{email_type:this.email_type,alias:this.alias}});if(this.taskid){a.push({api:"SYNO.PersonMailAccount.Mail",method:"status",version:1,params:{taskid:this.taskid}})}this.setStatusBusy();this.sendWebAPI({params:{},compound:{params:a},scope:this,callback:function(f,b,e,c){if(f){this.setAccountData(b.result);if(this.taskid){if(b.result[2].error){var d=SYNO.SDS.App.MailDialog.Utils.APIErrorGet(b.result[2].error.code);this.getMsgBox().alert("Title",d)}else{this.setFormData(b.result[2].data)}}}else{this.getMsgBox().alert("Title",_T("error","error_error_system"))}this.clearStatusBusy()}})},setAccountData:function(e){var f=0,b,k=false;var a,c,l={},g="confirm";this.BodyValueSet(this.mailContent);if(e[0].error){b=SYNO.SDS.App.MailDialog.Utils.APIErrorGet(e[0].error.code);this.getMsgBox().alert("Title",b,function(){this.doClose()},this);return}a=e[0].data.data;for(f=0;f<a.length;f++){var d=a[f];var h,j;if(d.is_default){l.account=d.sender_account||d.account;j=SYNO.SDS.App.MailDialog.Utils.getEmailProviderName(d.email_type);l.account=l.account+" ("+j+")";l.alias=d.alias;l.email_type=d.email_type}if(d.email_type==="synomail"&&!this.isSynoMailClientEnable()){continue}h=d.sender_account||d.account;j=SYNO.SDS.App.MailDialog.Utils.getEmailProviderName(d.email_type);h=h+" ("+j+")";this.comboStore.loadData([[d.alias,d.email_type,h]],true)}if(0===a.length){if(true===_S("standalone")){b=_T("mail","mail_setup_in_dsm");g="alert"}else{b=_T("mail","mail_setup_hint")}k=true}if(l.email_type==="synomail"&&!this.isSynoMailClientEnable()){b=_T("mail","default_alert");k=true}if(k){this.getMsgBox()[g]("Title",b,function(i){if("yes"===i){SYNO.SDS.AppLaunch("SYNO.SDS.App.PersonalSettings.Instance",{tab:"emailAccountForm"})}this.doClose()},this);return}this.panel.getComponent("mail_from").setValue(l.account);if(e[1].error){b=SYNO.SDS.App.MailDialog.Utils.APIErrorGet(e[1].error.code);b=String.format(b,this.email_type);this.setStatusError({text:b,clear:true});return}c=e[1].data.result;this.contactCacheData[this.alias]=c;this.store.loadData(c,true)},checkAttach:function(d,k,m,n){var e,c,a,l=0,g=0;var h=m.records;var f=this.getAttachArray();var b=SYNO.SDS.App.MailDialog.Utils.getAttachLimitByType(this.email_type);if(Ext.isEmpty(this.email_type)){return true}for(e=0;e<f.size();e++){g++;l+=f[e].filesize;for(c=0;c<h.size();c++){if(h[c].data.path===f[e].path){g--;l-=f[e].filesize;break}}}if(10<g+h.size()){a=String.format(_T("mail","filenum_limit_alert"),10);this.getMsgBox().alert("Title",a);return false}for(e=0;e<h.size();e++){if(h[e].data.isdir){a=_T("mail","filedir_limit_alert");this.getMsgBox().alert("Title",a);return false}l+=h[e].data.filesize}if(b*1024*1024<l){a=String.format(_T("mail","filesize_limit_alert"),b);this.getMsgBox().alert("Title",a);return false}if(Ext.isIE8){this.addAttachRecord(m.records,k);return false}return true},addAttachRecord:function(a,b){var c=this.panel.getComponent("mail_attachment");a.each(function(d){var e={};if(Ext.isDefined(d.path)){e.path=d.path;e.filename=e.path.substring(e.path.lastIndexOf("/")+1);e.filesize=d.filesize;e.formatsize=Ext.util.Format.fileSize(d.filesize);e.deleted=(Ext.isEmpty(d.deleted))?false:d.deleted}else{e.path=d.get("path");e.filename=e.path.substring(e.path.lastIndexOf("/")+1);e.filesize=d.get("filesize");e.formatsize=Ext.util.Format.fileSize(d.get("filesize"))}c.addNewItem(e)});if(Ext.isDefined(b)){b.close()}},getAttachArray:function(){var a=[];if(Ext.isIE8){var c=this.panel.getComponent("mail_attachment");var b=c.getSelectedRecords();b.each(function(d){a.push(d.data)})}else{a=this.panel.getComponent("htmleditor").getEditor().plugins.filestation_attachment.getAttachArray()}return a},BodyValueGet:function(){var b=this.panel.getComponent("htmleditor").getDoc();Ext.iterate(b.querySelectorAll("img,input[content_id]"),function(d,c){var e=d.getAttribute("content_id");if(e){e="cid:"+e;d.setAttribute("src",e)}});var a=b.body.innerHTML;return a},BodyValueSet:function(a){var b=this.panel.getComponent("htmleditor").getDoc();b.body.innerHTML=a},parseObjectAttachment:function(c){var a=[],b=this.appName;if(!Ext.isObject(c)){return a}Ext.iterate(c,function(d,e){a.push({app_name:b,path:e.name,symlink:e.symlink,filesize:e.size,cid:d,deleted:e.remove})});return a},loadContactData:function(b,a){if(this.contactCacheData[a]){this.store.loadData(this.contactCacheData[a]);return}this.setStatusBusy();this.sendWebAPI({api:"SYNO.PersonMailAccount.Contacts",method:"list",version:1,params:{email_type:b,alias:a},callback:function(f,c,d){if(f){this.contactCacheData[a]=c.result;this.store.loadData(c.result)}else{var e=SYNO.SDS.App.MailDialog.Utils.APIErrorGet(c.code);e=String.format(e,this.email_type);this.setStatusError({text:e,clear:true})}this.clearStatusBusy()},scope:this})},onClose:function(){if(this.canClosed){this.callParent(arguments);return true}this.getMsgBox().confirm("Title",_T("mail","mail_leave_desc"),function(a){if("yes"===a){this.onBeforeClose()}},this);return false},onBeforeClose:function(){var c=0,e=[],b;var a=this.getAttachArray();if("dsm"===this.appName){this.canClosed=true;this.close();return}for(c=0;c<a.length;c++){b=a[c];e.push({path:b.path,filesize:b.filesize,symlink:(Ext.isEmpty(b.symlink))?"":b.symlink,app_name:(Ext.isEmpty(b.app_name))?"dsm":b.app_name,deleted:(Ext.isEmpty(b.deleted))?false:b.deleted})}var d={attachment:Ext.encode(e),inline_attachment:Ext.encode(this.inlineAttachment)};this.setStatusBusy();this.sendWebAPI({api:"SYNO.PersonMailAccount.Mail",method:"clean",version:1,params:d,callback:function(h,f,g){this.clearStatusBusy();this.canClosed=true;this.close()},scope:this})},onClickHelp:function(){var a="SYNO.SDS.App.FileStation3.Instance:FileBrowser/emailaccount.html";SYNO.SDS.AppLaunch("SYNO.SDS.HelpBrowser.Application",{topic:a},false)},isSynoMailClientEnable:function(){return SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.MailClient.Application")}});Ext.namespace("SYNO.SDS.App.MailDialog.Utils");Ext.apply(SYNO.SDS.App.MailDialog.Utils,{className:"SYNO.SDS.App.MailDialog.Application",launchFn:function(d){var e=0,c=0,f=[],g;var a=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.App.PersonalSettings.Instance","email_type");var b=SYNO.SDS.App.MailDialog.Utils.getAttachLimitByType(a);if(10<d.size()){g=String.format(_T("mail","filenum_limit_alert"),10);this.ownerCt.getMsgBox().alert("Title",g);return}for(e=0;e<d.size();e++){if(d[e].data.isdir){g=_T("mail","filedir_limit_alert");this.ownerCt.getMsgBox().alert("Title",g);return}c+=d[e].data.filesize}if(!Ext.isEmpty(a)&&b*1024*1024<c){g=String.format(_T("mail","filesize_limit_alert"),b);this.ownerCt.getMsgBox().alert("Title",g);return}for(e=0;e<d.size();e++){f.push(d[e].data)}SYNO.SDS.AppLaunch("SYNO.SDS.App.MailDialog.Application",{data:f})},launchMailFn:function(a){SYNO.SDS.AppLaunch("SYNO.SDS.App.MailDialog.Application",a)},checkFn:function(b,a){if(1===a.size()&&a[0].data.isdir){return false}return true},getAttachLimitByType:function(a){if("gmail"===a){return 25}else{if("hotmail"===a){return 25}else{if("yahoomail"===a){return 25}else{if("aolmail"===a){return 25}else{return 15}}}}},APIErrorGet:function(a){switch(a){case 116:return _JSLIBSTR("uicommon","error_demo");case 8001:case 8002:case 8003:case 8004:return _T("error","error_error_system");case 8005:return _T("error","error_privilege_not_enough");case 8006:case 8007:case 8008:case 8009:case 8010:case 8011:return _T("error","error_error_system");case 8012:return _T("mail","sync_expire");case 8013:return _T("error","error_error_system");default:return _T("error","error_error_system")}},getEmailProviderName:function(a){if("gmail"===a){return"Gmail"}else{if("hotmail"===a){return"Outlook"}else{if("yahoomail"===a){return"Yahoo!"}else{if("aolmail"===a){return"AOL"}else{if("synomail"===a){return"MailPlus"}else{return"Custom"}}}}}}});Ext.define("SYNO.SDS.App.PersonalSettings.MailForm",{extend:"SYNO.ux.GridPanel",constructor:function(a){var b=this.fillConfig(a);this.callParent([b]);this.mon(this,"afterlayout",this.onLoadAccountData,this,{single:true})},fillConfig:function(a){Ext.apply(this,a||{});this.pageSize=50;var b={title:_T("mail","mail_account"),itemId:"emailAccountForm",store:this.createStore(),cm:this.initColumnMode(),tbar:this.initToolBar(),bbar:this.initBottomToolBar(),pageSize:this.pageSize,loadMask:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{selectionchange:function(g){var d=true,c=true,e=true;if(0<g.selections.length){var f=g.selections.items[0];d=!this.isAccountCanEdit(f);c=false;e=d||f.get("is_default")}this.setToolBarDisable([d,c,e])},scope:this}}),listeners:{dblclick:{fn:this.onEditAccount,scope:this},rowcontextmenu:{fn:function(g,d,f){if(!this.contextMenu){this.createContextMenu()}if(0<this.selModel.selections.length){var e=this.selModel.selections.items[0];var c=!this.isAccountCanEdit(e);this.contextMenu.getComponent("edit").setDisabled(c);this.contextMenu.getComponent("set_default").setDisabled(c)}this.getSelectionModel().selectRow(d);this.contextMenu.showAt(f.xy)},scope:this},sortchange:{fn:function(){this.swapDefaultAccountToTop()},scope:this}}};return b},initToolBar:function(){this.newBtn=new SYNO.ux.Button({itemId:"new_btn",text:_T("common","add"),handler:this.onNewAccount,disabled:_S("demo_mode"),scope:this});this.editBtn=new SYNO.ux.Button({itemId:"edit_btn",text:_T("common","alt_edit"),handler:this.onEditAccount,scope:this,disabled:true});this.deleteBtn=new SYNO.ux.Button({itemId:"delete_btn",text:_T("common","delete"),handler:this.onDeleteAccount,scope:this,disabled:true});this.setBtn=new SYNO.ux.Button({itemId:"set_default_btn",text:_T("mail","set_default"),handler:this.onSetDefaultAccount,scope:this,disabled:true});var a=new Ext.Toolbar({border:false,items:[this.newBtn,this.editBtn,this.deleteBtn,this.setBtn]});return a},initBottomToolBar:function(){var a=new SYNO.ux.PagingToolbar({pageSize:this.pageSize,store:this.store,loadMask:true,displayInfo:true,showRefreshBtn:true});this.bbar=a;return a},initColumnMode:function(){var a=new Ext.grid.ColumnModel([{header:_T("notification","label_smtp_provider"),dataIndex:"email_type",width:120,sortable:true,renderer:function(h,e,b,d,f,c){var g;if("gmail"===h){g="Gmail"}else{if("hotmail"===h){g="Outlook"}else{if("yahoomail"===h){g="Yahoo!"}else{if("aolmail"===h){g="AOL"}else{if("synomail"==h){g="MailPlus"}else{g="Customize"}}}}}return g}},{header:_T("mail","application_title"),dataIndex:"account",sortable:true,width:250,renderer:function(g,e,b,d,f,c){if(b.data.auth&&"custom"!=b.data.email_type){return g}else{return b.data.sender_account}}},{header:_T("common","status"),dataIndex:"state",sortable:false,width:120,renderer:function(h,e,b,d,f,c){switch(h){case 1:return("gmail"!==b.data.email_type)?_T("mail","contact_synced"):_T("mail","mail_gmail_status");case 0:var g="-";if("synomail"===b.data.email_type&&!this.isSynoMailClientEnable()){g=_T("common","disabled")}return g;case -1:return _T("error","error_auth");case -2:return _T("mail","mail_smtp_failed");default:return _T("download","download_status_unknown")}},scope:this},{header:_T("mail","default_use"),dataIndex:"is_default",sortable:false,width:120,renderer:function(g,e,b,d,f,c){if(g){e.css+="syno-mail-default-use ";e.attr+=String.format('aria-label="{0}"',_T("mail","default_account"))}return""}}]);return a},createStore:function(){var a=new Ext.data.Store({autoDestroy:true,autoLoad:false,proxy:new SYNO.API.Proxy({api:"SYNO.PersonMailAccount",method:"get",version:1}),reader:new Ext.data.JsonReader({root:"data"},[{name:"alias"},{name:"email_type"},{name:"account"},{name:"passwd"},{name:"sender_name"},{name:"sender_account"},{name:"host"},{name:"port"},{name:"auth"},{name:"tls"},{name:"state"},{name:"is_default"}]),paramNames:{start:"offset",limit:"limit"},listeners:{load:{fn:function(){if(0===this.store.getTotalCount()){this.maskPanel(true);return}this.swapDefaultAccountToTop()},scope:this},exception:{fn:function(){var b;if(_S("demo_mode")){b=_JSLIBSTR("uicommon","error_demo")}else{b=_T("error","error_error_system")}this.ownerCt.ownerCt.getMsgBox().alert("",b)},scope:this}}});this.store=a;return a},createContextMenu:function(){var a=new SYNO.ux.Menu({items:[{itemId:"edit",text:_T("common","alt_edit")},{itemId:"delete",text:_T("common","delete")},{itemId:"set_default",text:_T("mail","set_default")||"Set default"}],listeners:{itemclick:function(b){switch(b.itemId){case"edit":this.onEditAccount();break;case"delete":this.onDeleteAccount();break;case"set_default":this.onSetDefaultAccount();break;default:break}},scope:this}});this.contextMenu=a},maskPanel:function(a){if(a){this.bbar.mask();this.getView().el.mask(_T("mail","no_account_alert")||"Please click Add button to add email account")}else{this.bbar.unmask();this.getView().el.unmask()}},onLoadAccountData:function(){var a=this.store.getSortState();this.maskPanel(false);this.store.load({params:{offset:0,limit:this.pageSize,sort_by:a?a.field:"",sort_direction:a?a.direction:""}})},onNewAccount:function(){var a={owner:this.module,module:this,appInstance:this.module.appInstance,blFirstCreate:(0===this.store.data.items.length)};var b=new SYNO.SDS.App.PersonalSettings.EmailAccountWizard(a);this.mon(b,"beforeclose",this.onLoadAccountData,this);b.onOpen()},swapDefaultAccountToTop:function(){var a=this.getDefaultUseRecord();if(a){this.store.remove(a,true);this.store.insert(0,a)}},getDefaultUseRecord:function(){var a=0;var b=this.store.data.items;for(a=0;a<b.size();a++){if(b[a].data.is_default){return b[a]}}return null},onEditAccount:function(){var b=this.getSelectionModel().getSelections();if(!b||0===b.length){return}if(!this.isAccountCanEdit(b[0])){return}var a=new SYNO.SDS.App.PersonalSettings.MailEditDialog({owner:this.ownerCt.ownerCt,formData:b[0].data});this.mon(a,"beforeclose",this.onLoadAccountData,this);a.show()},onDeleteAccount:function(){var a=this.getSelectionModel().getSelections();if(!a||0===a.length){return}if(a[0].data&&a[0].data.is_default&&1!=this.store.data.items.length){this.ownerCt.ownerCt.getMsgBox().alert("",_T("mail","delete_default_alert"));return}this.ownerCt.ownerCt.setStatusBusy();this.sendWebAPI({api:"SYNO.PersonMailAccount",method:"delete",version:1,params:{email_type:a[0].data.email_type,alias:a[0].data.alias},callback:function(d,b,c){this.ownerCt.ownerCt.clearStatusBusy();if(!d){this.ownerCt.ownerCt.getMsgBox().alert("",_T("error","error_error_system"))}else{if(a[0].data.is_default){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.App.PersonalSettings.Instance","email_type","");SYNO.SDS.UserSettings.setProperty("SYNO.SDS.App.PersonalSettings.Instance","email_alias","");SYNO.SDS.UserSettings.syncSave()}this.onLoadAccountData()}},scope:this})},onSetDefaultAccount:function(){var a=this.getSelectionModel().getSelections();if(!Ext.isDefined(a)){return}this.ownerCt.ownerCt.setStatusBusy();this.sendWebAPI({api:"SYNO.PersonMailAccount",method:"update",version:1,params:{email_type:a[0].data.email_type,alias:a[0].data.alias,is_default:true},callback:function(d,b,c){this.ownerCt.ownerCt.clearStatusBusy();if(!d){this.ownerCt.ownerCt.getMsgBox().alert("",_T("error","error_error_system"))}else{SYNO.SDS.UserSettings.setProperty("SYNO.SDS.App.PersonalSettings.Instance","email_type",a[0].data.email_type);SYNO.SDS.UserSettings.setProperty("SYNO.SDS.App.PersonalSettings.Instance","email_alias",a[0].data.alias);SYNO.SDS.UserSettings.syncSave();this.onLoadAccountData()}},scope:this})},setToolBarDisable:function(a){this.editBtn.setDisabled(a[0]);this.deleteBtn.setDisabled(a[1]);this.setBtn.setDisabled(a[2])},applyForm:function(){return true},isAccountCanEdit:function(a){if(a.get("email_type")==="yahoomail"||a.get("email_type")==="aolmail"){return false}if(a.get("email_type")==="synomail"&&!this.isSynoMailClientEnable()){return false}return true},isSynoMailClientEnable:function(){return SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.MailClient.Application")}});Ext.define("SYNO.SDS.App.PersonalSettings.MailEditDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.saveData={};var b=this.fillConfig(a);this.callParent([b]);this.mon(this,"afterlayout",this.setDataValues,this,{single:this})},fillConfig:function(a){Ext.apply(this,a||{});this.emailConfig=SYNO.SDS.App.PersonalSettings.EmailAccountWizard.Utils.getEmailConfig(this.formData.email_type);this.commitBtn=new SYNO.ux.Button({btnStyle:"blue",text:_T("common","commit"),scope:this,handler:this.onBeforeApply});var b={owner:this.owner,width:520,minWidth:450,autoHeight:true,collapsible:false,autoScroll:false,constrainHeader:true,title:_T("common","alt_edit"),layout:"fit",items:this.initPanel(),buttons:[this.commitBtn,{text:_T("common","close"),scope:this,handler:this.close}],listeners:{beforeclose:this.onBeforeClose,scope:this}};return b},initPanel:function(){var a;var c=("gmail"!==this.formData.email_type);var b=("custom"!==this.formData.email_type&&"aolmail"!==this.formData.email_type&&"synomail"!==this.formData.email_type);if("custom"===this.formData.email_type){a=SYNO.SDS.App.PersonalSettings.EmailAccountWizard.Utils.getCustomProviderConfig();a.height=280}else{if("synomail"===this.formData.email_type){a=SYNO.SDS.App.PersonalSettings.EmailAccountWizard.Utils.getSynoMailConfig();a.height=110}else{a=SYNO.SDS.App.PersonalSettings.EmailAccountWizard.Utils.getNormalProviderConfig(c);a.height=(c)?150:110}}this.syncBtn=new SYNO.ux.Button({itemId:"sync_contact",text:this.emailConfig.btn_text,handler:this.onSyncClick,scope:this});this.msgField=new SYNO.ux.DisplayField({itemId:"msg_field",htmlEncode:false});a.trackResetOnLoad=true;a.items.push({xtype:"compositefield",itemId:"sync_composite",hideLabel:true,hidden:!b,disabled:!b,items:[this.syncBtn,this.msgField]});this.panel=new SYNO.ux.FormPanel(a);return this.panel},setDataValues:function(){var c=this.panel.getComponent("sender_name");var a;if("custom"===this.formData.email_type){var b;b=new SYNO.ux.Utils.EnableCheckGroup(this.panel.form,"auth",["account","passwd"]);if(this.formData.auth){this.formData.passwd="00000000"}else{this.formData.account="";this.formData.passwd=""}a=_T("notification","label_smtp_sender_mail");SYNO.SDS.Utils.AddTip(c.getEl(),String.format(_T("mail","sender_name_hint"),a))}else{if("synomail"!==this.formData.email_type){this.formData.passwd="00000000";if(this.formData.state===1){this.syncBtn.setText(this.emailConfig.unsync_text)}a=_T("notification","alert_smtp_user");SYNO.SDS.Utils.AddTip(c.getEl(),String.format(_T("mail","sender_name_hint"),a))}}this.panel.form.setValues(this.formData)},isNeedTestConnect:function(a){return("gmail"!==a&&"synomail"!==a)},onBeforeApply:function(){var b=this.panel.form.getValues();Ext.apply(this.saveData,b);this.saveData.email_type=this.formData.email_type;this.saveData.alias=this.formData.alias;this.saveData.auth=this.saveData.auth||"true";this.saveData.tls=this.saveData.tls||"true";this.saveData.test_connect=this.isNeedTestConnect(this.saveData.email_type);if(!this.panel.form.isDirty()&&!Ext.isDefined(this.saveData.access_token)){this.close();return}if(!this.panel.form.isValid()){this.getMsgBox().alert("",_T("common","forminvalid"));return}var d=this.panel.getComponent("passwd");if(d&&d.isDirty()){this.saveData.passwd=this.panel.getComponent("passwd").getValue()}else{delete this.saveData.passwd}this.saveData.new_alias=this.panel.getComponent("account").getValue()||this.panel.getComponent("sender_account").getValue();if("custom"===this.saveData.email_type){this.saveData.new_alias=this.panel.getComponent("host").getValue()+"_"+this.saveData.new_alias}this.saveData.sender_name=this.saveData.sender_name||this.saveData.sender_account||this.saveData.account;var a=SYNO.SDS.App.PersonalSettings.EmailAccountWizard.Utils.getEmailProviderName(this.saveData.email_type);var c=String.format(_T("mail","email_setting_alert"),this.saveData.account,a);if(SYNO.SDS.App.PersonalSettings.EmailAccountWizard.Utils.isNeedAlert(this.saveData.account,this.saveData.email_type)){this.getMsgBox().confirm("",c,function(e){if("yes"===e){this.onApply()}},this);return}this.onApply()},onApply:function(){this.setStatusBusy();this.sendWebAPI({api:"SYNO.PersonMailAccount",method:"update",version:1,params:this.saveData,encryption:["passwd"],callback:function(c,b,a){this.clearStatusBusy();if(!c){this.getMsgBox().alert("",this.getAPIError(b.code));return}if(this.saveData.alias===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.App.PersonalSettings.Instance","email_alias")){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.App.PersonalSettings.Instance","email_alias",this.saveData.new_alias);SYNO.SDS.UserSettings.syncSave()}this.close()},scope:this})},onBeforeClose:function(){this.doClosePopup()},onSyncClick:function(a){if(this.emailConfig.btn_text===a.getText()||this.formData.email_type==="gmail"){this.onSyncContacts(this.formData.email_type)}else{this.onCancelSyncContacts()}},onSyncContacts:function(a){var e="_mailFormOAuthCallback";this.register(this.onSyncCallback.createDelegate(this),e);var c=window.location.href.indexOf("/",window.location.protocol.length+2);var d=window.location.href.slice(0,c)+"/webman/modules/PersonalSettings/index_ds.php";var b="https://synooauth.synology.com/email/login.php?callback="+e+"&host="+d+"&type="+a;this.popup=window.open(b,"mywindow","menubar=1,resizable=0,width=600,height=520, top=100, left=300");this.addPopupTimer(this)},onSyncCallback:function(c){var b=new Date();var a=parseInt(b.getTime()/1000,10)+parseInt(c.expires_in,10)-100;this.saveData.access_token=c.token;this.saveData.refresh_token=c.refresh_token;this.saveData.expires_in=a.toString();this.syncBtn.setText(this.emailConfig.unsync_text);this.showSyncMessage();this.onBeforeApply()},onCancelSyncContacts:function(){this.saveData.access_token="";this.saveData.refresh_token="";this.saveData.expires_in="";this.syncBtn.setText(this.emailConfig.btn_text);this.commitBtn.setDisabled(this.emailConfig.cancel)},showSyncMessage:function(){var b='<span class="syno-ux-note">'+_T("mail","sync_success")+"</span>";this.msgField.setValue(b);this.doLayout();var a=new Ext.util.DelayedTask(function(){if(Ext.isDefined(this.msgField.el.dom)){this.msgField.setValue("")}},this);a.delay(3000)},getAPIError:function(a){switch(a){case 116:return _JSLIBSTR("common","error_demo");case 8007:return _T("mail","account_already_saved");case 8011:return _T("mail","mail_setting_error");default:return _T("error","error_error_system")}},register:function(c,b){if(Ext.isIE||Ext.isIE11){window[b]=c}else{var a=this;this.receiveMessage=function(f){var d=f.browserEvent;if(d.origin!==window.location.origin||/setImmediate/.test(d.data)){return}var g=JSON.parse(d.data);if(g.callback!==b){return}c.call(a,g)};Ext.EventManager.addListener(window,"message",this.receiveMessage)}},unregister:function(){if(Ext.isIE||Ext.isIE11){return}Ext.EventManager.removeListener(window,"message",this.receiveMessage)},addPopupTimer:function(b){if(b.popup&&!b.popup.closed){var a=1000;var c=window.setInterval(function(){if(b.popup.closed){b.unregister();window.clearInterval(c);c=null}},a)}},doClosePopup:function(){if(this.popup&&!this.popup.closed){this.popup.close()}}});Ext.define("SYNO.SDS.App.PersonalSettings.QuotaGrid",{extend:"SYNO.ux.GridPanel",constructor:function(d){var b=_D("support_share_quota","no")==="yes";var e=_D("support_share_user_quota","no")==="yes";var c;if(e){c=new SYNO.API.Store({autoDestroy:true,appWindow:d.module,api:"SYNO.Core.PersonalSettings",method:"quota",version:1,idProperty:"name",totalProperty:"total",reader:new SYNO.ux.data.TreeReader({root:"items",fields:[{name:"name",mapping:"name"},{name:"share_quota",mapping:"share_quota"},{name:"share_used",mapping:"share_used"},{name:"quota",mapping:"quota"},{name:"used",mapping:"used"}]})})}else{c=new SYNO.API.JsonStore({autoDestroy:true,appWindow:d.module,api:"SYNO.Core.PersonalSettings",method:"quota",version:1,root:"items",totalProperty:"total",idProperty:"name",fields:[{name:"name"},{name:"quota"},{name:"used"}]})}var a={itemId:"quota",title:_T("user","user_quota_capacity"),autoExpandColumn:"used",enableHdMenu:false,enableColumnMove:false,store:c,colModel:new Ext.grid.ColumnModel({columns:[{header:e?_T("common","volume_share"):_T("user","user_volume"),dataIndex:"name",width:e?160:100,align:e?"left":"center",treeCol:e,renderer:function(f){if(f.indexOf("share:")!==-1){return f.replace("share:","")}else{if("X"==f.charAt(0)){return String.format("{0} {1}({2})",_T("volume","volume"),f.substring(1),_T("volume","volume_disk_source_ebox"))}}return String.format("{0} {1}",_T("volume","volume"),f)}},{id:"share_quota",header:_T("share","share_quota"),dataIndex:"share_quota",align:"center",hidden:!b,renderer:function(f){if(0===f){return _T("user","user_quota_nolimit")}else{if("-"===f){return"-"}else{if(undefined===f||"NotSupport"===f){return""}}}return SYNO.SDS.Utils.CapacityRender(f,0)}},{id:"share_used",header:_T("share","share_size"),dataIndex:"share_used",align:"center",hidden:!b,renderer:function(f){if("-"===f){return"-"}else{if(undefined===f||"NotSupport"===f){return""}}return SYNO.SDS.Utils.CapacityRender(f,3)}},{header:b?_T("personal_settings","user_quota_capacity"):_T("user","user_quota_capacity"),dataIndex:"quota",align:"center",renderer:function(f){if(0===f){return _T("user","user_quota_nolimit")}else{if("NotSupport"===f){return""}}return SYNO.SDS.Utils.CapacityRender(f,0)}},{id:"used",header:_T("user","acnt_used_cap"),dataIndex:"used",align:b?"center":"left",renderer:function(f){if("NotSupport"===f){return""}else{return SYNO.SDS.Utils.CapacityRender(f,3)}}}]}),sm:new Ext.grid.RowSelectionModel(),listeners:{afterlayout:{single:true,scope:this,fn:this.onAfterLayout}}};if(e){a.view=new SYNO.ux.FleXcroll.grid.TreeView({useArrows:true,staticTree:false})}this.callParent([Ext.apply(a,d)])},onAfterLayout:function(){this.getStore().load()}});Ext.namespace("SYNO.SDS.App.PersonalSettings");SYNO.SDS.App.PersonalSettings.CustomizeForm=Ext.extend(Ext.form.FormPanel,{imageSelectId:null,newImage:false,wallpaperSelector:null,constructor:function(c){var g=SYNO.SDS.ThemeProvider.getThemeCls()===SYNO.SDS.DSM.Themer.BUSINESS;var b=function(){var i=SYNO.SDS.UserSettings.getProperty("Desktop","appMenuStyle");if(!Ext.isEmpty(i)){return i}if(g){i="classical"}else{i="fullscreen"}return i};var e=function(){var i=SYNO.SDS.UserSettings.getProperty("Desktop","desktopStyle");if(!Ext.isEmpty(i)){return i}if(g){i="classical"}else{i="normal"}return i};var a=b();var f=(a==="classical")?"classical":"fullscreen";var d=e();var h=SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper");this.isESM=(_D("support_ESM")==="yes");SYNO.SDS.App.PersonalSettings.CustomizeForm.superclass.constructor.call(this,Ext.apply({trackResetOnLoad:true,itemId:"desktop",title:_T("common","desktop"),cls:"syno-sds-personal-option-form",labelWidth:170,listeners:{afterlayout:{single:true,scope:this,fn:this.onAfterLayout}},items:[{fieldLabel:_T("personal_settings","menu_style"),itemId:"menu_style",name:"menu_style",xtype:"syno_combobox",hidden:this.isESM,value:f,width:190,forceSelection:true,allowBlank:false,displayField:"display",valueField:"value",store:new Ext.data.ArrayStore({fields:["display","value"],data:[[_T("personal_settings","menu_style_fullscreen"),"fullscreen"],[_T("personal_settings","menu_style_dropdown"),"classical"]]}),listeners:{select:{fn:this.onChangeMenuStyle,scope:this,buffer:100}}},{fieldLabel:_T("personal_settings","classical_desktop"),itemId:"classical_desktop",name:"classical_desktop",xtype:"syno_combobox",hidden:this.isESM,width:190,forceSelection:true,allowBlank:false,value:d,displayField:"display",valueField:"value",store:new Ext.data.ArrayStore({fields:["display","value"],data:[[_T("personal_settings","desktop_style_normal"),"normal"],[_T("personal_settings","desktop_style_classical"),"classical"]]})},{itemId:"customize_color",name:"customize_color",xtype:"syno_checkbox",boxLabel:_T("personal_settings","customize_color")},{xtype:"syno_colorfield",fieldLabel:_T("personal_settings","text_color"),itemCls:"color_field",itemId:"text_color",name:"text_color",width:190,value:"#FFFFFF"},{xtype:"syno_colorfield",fieldLabel:_T("personal_settings","background_color"),itemCls:"color_field",itemId:"background_color",name:"background_color",width:190,value:"#FFFFFF"},{itemId:"customize_wallpaper",name:"customize_wallpaper",xtype:"syno_checkbox",boxLabel:_T("personal_settings","customize_wallpaper")},{itemId:"wallpaper_thumbnail",xtype:"box",cls:"thumb-customize",autoEl:{tag:"img"}},{itemCls:"wallpaper-filename",itemId:"wallpaper_filename",name:"wallpaper_filename",xtype:"syno_displayfield",hideLabel:false,hidden:_S("diskless"),value:""},{xtype:"syno_compositefield",itemCls:"wallpaper-select-btn-container",items:[{cls:"wallpaper-select-btn",id:this.imageSelectId=Ext.id(),xtype:"syno_button",hidden:_S("diskless"),text:_T("personal_settings","select_image"),scope:this,handler:this.onSelectWallpaper}]},{cls:"wallpaper-position",itemId:"wallpaper_position",name:"wallpaper_position",xtype:"syno_combobox",hidden:_S("diskless"),value:"fill",width:190,forceSelection:true,allowBlank:false,displayField:"display",valueField:"value",store:new Ext.data.ArrayStore({fields:["display","value"],data:[[_T("dsmoption","login_background_position_fill"),"fill"],[_T("dsmoption","login_background_position_center"),"center"],[_T("dsmoption","login_background_position_fit"),"fit"],[_T("dsmoption","login_background_position_stretch"),"stretch"],[_T("dsmoption","login_background_position_tile"),"tile"]]}),listeners:{select:{fn:this.onChangeSettings,scope:this,buffer:100}}},{cellCls:"wallpaper-cell-last",itemId:"wallpaper_path",name:"wallpaper_path",xtype:"hidden",value:""},{itemId:"wallpaper_ext",name:"wallpaper_ext",xtype:"hidden",value:""},{itemId:"wallpaper_type",name:"wallpaper_type",xtype:"hidden",value:""}]},c));if(!Ext.isEmpty(h)&&Ext.isBoolean(h.newImage)){SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper").newImage=false}this.origConfig=Ext.apply({},SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper")||{});Ext.apply(this.origConfig,{classical_desktop:d,menu_style:f});this.desktopStyleComboBox=this.getComponent("classical_desktop");this.customizeWallpaper=this.getComponent("customize_wallpaper");this.wallpaperPath=this.getComponent("wallpaper_path");this.wallpaperExt=this.getComponent("wallpaper_ext");this.wallpaperType=this.getComponent("wallpaper_type");this.wallpaperThumbnail=this.getComponent("wallpaper_thumbnail");this.wallpaperFileName=this.getComponent("wallpaper_filename");this.menuStyleFiled=this.getComponent("menu_style")},onAfterLayout:function(){var b,a=this.getForm();b=new SYNO.SDS.Utils.EnableCheckGroup(a,"customize_color",["text_color","background_color"]);b=new SYNO.SDS.Utils.EnableCheckGroup(a,"customize_wallpaper",[this.imageSelectId,"wallpaper_position"]);if("admin"===_S("user")){SYNO.SDS.Utils.DisplayField(this.getForm(),"email",false)}a.setValues(this.origConfig);this.origConfig.wallpaper=1+(this.origConfig.wallpaper||0);this.wallpaperThumbnail.getEl().dom.src=Ext.urlAppend("webapi/entry.cgi",Ext.urlEncode({api:"SYNO.Core.PersonalSettings",method:"wallpaper",version:1,thumbnail:true,id:this.origConfig.wallpaper}));this.getComponent("customize_color").on("check",this.onChangeSettings,this);this.getComponent("customize_wallpaper").on("check",this.onChangeSettings,this);this.getComponent("text_color").on("valid",this.onChangeSettings,this);this.getComponent("background_color").on("valid",this.onChangeSettings,this)},applyForm:function(){var a=this.getForm();if(!a.isDirty()){return}if(!a.isValid()){this.module.getMsgBox().alert(this.module.title,_T("common","forminvalid"));return false}this.applySettings()},applySettings:function(){var b={},d={},a={};Ext.apply(d,this.getForm().getValues());Ext.apply(a,SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper")||{});if(!this.customizeWallpaper.getValue()){delete (d.wallpaper_path);delete (d.wallpaper_ext);delete (d.wallpaper_type)}d.newImage=this.newImage;Ext.apply(b,a);Ext.apply(b,d,{customize_color:false,customize_wallpaper:false});b.wallpaper=1+(b.wallpaper||0);b.customize_color=this.parseBool(b.customize_color);b.customize_wallpaper=this.parseBool(b.customize_wallpaper);SYNO.SDS.UserSettings.setProperty("Desktop","wallpaper",b);if(!this.isESM){var c=this.menuStyleFiled.getValue();SYNO.SDS.UserSettings.setProperty("Desktop","appMenuStyle",c);SYNO.SDS._ActiveMenu=Ext.getClassByName(SYNO.SDS.Injector.resolve("getAppMenuClass"))}SYNO.SDS.UserSettings.syncSave();delete (b.newImage);SYNO.SDS.UserSettings.setProperty("Desktop","wallpaper",b)},onChangeMenuStyle:function(){var a=this.menuStyleFiled.getValue();SYNO.SDS.AppView.destroy();if(a==="classical"){SYNO.SDS.AppView=new SYNO.SDS.Classic._AppView()}else{SYNO.SDS.AppView=new SYNO.SDS._AppView()}},onChangeSettings:function(b){var c=Ext.apply({},this.getForm().getValues()),a=JSON.stringify(c);if(!b&&this._lastFormValues===a){return}this._lastFormValues=a;if(!this.customizeWallpaper.getValue()){delete (c.wallpaper_path);delete (c.wallpaper_ext);delete (c.wallpaper_type);c.customize_wallpaper=false}if(!this.getComponent("text_color").isValid()){c.text_color="#FFFFFF"}if(!this.getComponent("background_color").isValid()){c.background_color="#FFFFFF"}c.newImage=this.newImage;this.origConfig.wallpaper=1+(this.origConfig.wallpaper||0);c.wallpaper=this.origConfig.wallpaper;c.customize_color=this.parseBool(c.customize_color);c.customize_wallpaper=this.parseBool(c.customize_wallpaper);if(true!==_S("standalone")){if(!c.newImage){c.wallpaper_path=""}SYNO.SDS.Desktop.setBackground(c);SYNO.SDS.Desktop.updateTextColor(c)}},parseBool:function(a){if(a==="true"||a==="on"||a===true){return true}return false},onSelectWallpaper:function(){if(this.wallpaperSelector){this.wallpaperSelector.show()}else{this.wallpaperSelector=new SYNO.SDS.Utils.ImageSelector({owner:this.module,maxImageSizeKB:8*1024,enumCluster:true},"desktop","background");this.wallpaperSelector.mon(this.wallpaperSelector,"choose",this.onSelectWallpaperDone,this);this.wallpaperSelector.open()}},onSelectWallpaperDone:function(b){this.newImage=true;this.wallpaperPath.setValue(b.data.path);this.wallpaperExt.setValue(b.data.type);this.wallpaperType.setValue(b.data.apply_type);var a=Ext.util.Format.ellipsis(b.data.filename,30,true);this.wallpaperFileName.setValue(a);this.wallpaperThumbnail.getEl().dom.src=b.data.url;this.wallpaperSelector.hide();this.onChangeSettings(true)},restoreOrigSettings:function(){if(true!==_S("standalone")){SYNO.SDS.Desktop.setBackground(this.origConfig);SYNO.SDS.Desktop.updateTextColor(this.origConfig)}if(!this.isESM){SYNO.SDS.AppView.destroy();SYNO.SDS.AppView=new SYNO.SDS._ActiveMenu()}}});Ext.define("SYNO.SDS.App.PersonalSettings.OtherForm",{extend:"Ext.form.FormPanel",constructor:function(b){var a=[{boxLabel:_T("personal_settings","disable_logout_confirm"),name:"disableLogoutConfirm"},{boxLabel:_T("personal_settings","remember_window_state"),name:"rememberWindowState"},{boxLabel:_T("personal_settings","enable_taskbar_thumbnail"),name:"enableTaskbarThumbnail"},{boxLabel:_T("hotkey_manager","enable_desktop_hotkeys"),name:"enableDeskHotkeys"},{boxLabel:_T("personal_settings","disable_accessibility"),name:"disableAccessibility"}];this.hasNotification=window.Notification&&(window.Notification.permission!=="denied");if(this.hasNotification){a.push({name:"enableDesktopNotification",boxLabel:_T("notification","enable_chrome_desktop_notification")})}a.push({boxLabel:_T("personal_settings","enable_pilot_view"),name:"enablePilotView"});this.callParent([Ext.apply(SYNO.LayoutConfig.fill({trackResetOnLoad:true,itemId:"others",title:_T("helptoc","personal_others"),listeners:{afterlayout:{single:true,scope:this,fn:this.loadForm}},defaultType:"syno_checkbox",items:a}),b)]);this.mon(this,"afterlayout",function(){if(this.hasNotification){SYNO.SDS.Utils.AddTip(this.getForm().findField("enableDesktopNotification").getEl(),_T("notification","chrome_desktop_notification_note"))}},this,{single:true})},loadForm:function(){var a=SYNO.SDS.UserSettings;this.getForm().setValues({disableLogoutConfirm:a.getProperty("Desktop","disableLogoutConfirm")!==false,rememberWindowState:a.getProperty("Desktop","rememberWindowState")||false,enableTaskbarThumbnail:a.getProperty("Desktop","enableTaskbarThumbnail")===false?false:true,enableDesktopNotification:a.getProperty("Desktop","enableDesktopNotification")||false,enablePilotView:a.getProperty("Desktop","enablePilotView")||false,enableDeskHotkeys:a.getProperty("Desktop","hotkey_disabled")===true?false:true,disableAccessibility:a.getProperty("Desktop","disableAccessibility")||false});this.form.findField("enableTaskbarThumbnail").setVisible(SYNO.SDS.UIFeatures.test("previewBox"))},applyForm:function(){var a=this.getForm();if(!a.isDirty()){return}var h=this.form.findField("disableLogoutConfirm").getValue(),b=this.form.findField("rememberWindowState").getValue(),i=this.form.findField("enableTaskbarThumbnail").getValue(),d=this.hasNotification?this.form.findField("enableDesktopNotification").getValue():SYNO.SDS.UserSettings.getProperty("Desktop","enableDesktopNotification")||false,e=this.form.findField("enablePilotView").getValue(),f=this.form.findField("enableDeskHotkeys").getValue(),j=this.form.findField("disableAccessibility").getValue(),g=Ext.fly("sds-taskbar-preview-button"),c=SYNO.SDS.UserSettings;c.setProperty("Desktop","disableLogoutConfirm",h);c.setProperty("Desktop","rememberWindowState",b);c.setProperty("Desktop","enableTaskbarThumbnail",i);c.setProperty("Desktop","enableDesktopNotification",d);c.setProperty("Desktop","enablePilotView",e);c.setProperty("Desktop","hotkey_disabled",!f);c.setProperty("Desktop","disableAccessibility",j);if(a.findField("enablePilotView")&&a.findField("enablePilotView").isDirty()){g.setVisibilityMode(Ext.Element.DISPLAY);g.setVisible(e);SYNO.SDS.TaskBar.doLayout()}if(a.findField("enableDeskHotkeys")&&a.findField("enableDeskHotkeys").isDirty()){SYNO.SDS.Desktop.hotkeyPlugin.setHotkeyEnabled(f)}if(a.findField("disableAccessibility")&&a.findField("disableAccessibility").isDirty()){SYNO.SDS.initAccesibilityPlugin()}this.getForm().setValues({disableLogoutConfirm:h,rememberWindowState:b})}});Ext.namespace("SYNO.SDS.App.PersonalSettings");Ext.define("SYNO.SDS.App.PersonalSettings.PPhotoForm",{extend:"Ext.form.FormPanel",userPhotoLaunchBtnId:undefined,userPhotoReindexBtnId:undefined,userPhotoReindexMsgId:undefined,seqApplyAction:null,constructor:function(a){this.callParent([Ext.apply(SYNO.LayoutConfig.fill({url:"/webapi/entry.cgi",itemId:"pphoto",method:"POST",trackResetOnLoad:true,title:_T("service","service_photo_personal_station"),listeners:{activate:{scope:this,fn:this.onActivate},deactivate:{scope:this,fn:this.onDeactivate},destroy:{single:true,scope:this,fn:this.onDestroy},afterlayout:{single:true,scope:this,fn:this.onAfterLayout},beforeaction:{scope:this,fn:this.onBeforeAction},actioncomplete:{scope:this,fn:this.onActionComplete},actionfailed:{scope:this,fn:this.onActionFailed}},items:[{xtype:"syno_displayfield",value:String.format(_T("service","service_desc_photo_personal_setting"),_S("user"),_S("user"),_S("user"),_S("user")),htmlEncode:false},{xtype:"syno_checkbox",name:"user_photo_enable",boxLabel:_T("service","service_photo_personal_enable")+" - "+_S("user")},{xtype:"syno_checkbox",name:"user_album_public",indent:1,boxLabel:_T("service","service_photo_public")},{xtype:"displayfield",text:""},{xtype:"panel",border:false,items:[{xtype:"compositefield",items:[{xtype:"syno_button",text:String.format(_T("common","launch"),_T("service","service_photo_personal_station")),id:this.userPhotoLaunchBtnId=Ext.id(),scope:this,handler:function(c,b){SYNO.SDS.WindowLaunch("SYNO.SDS.PersonalPhotoStation")}},{xtype:"syno_button",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",id:this.userPhotoReindexBtnId=Ext.id(),text:_T("service","service_photo_reindex"),scope:this,handler:this.onClickReindexBtn},{synotype:"desc",id:this.userPhotoReindexMsgId=Ext.id(),value:"<font color='#0000FF'>"+_T("mediaservice","media_data_reindexing")+"</font>"}]}]}]}),a)])},onActivate:function(){if(undefined===this.pollingTask){this.pollingTask=this.addWebAPITask({id:"pphotoPollingTask",api:"SYNO.Core.PersonalSettings",method:"photo",version:1,params:{action:"load",reindex:true},scope:this,callback:function(d,b,c,a){this.updateUI(b.reindexing)},interval:5000});this.pollingTask.start(true)}},onDeactivate:function(){if(undefined!==this.pollingTask){this.pollingTask.remove();this.pollingTask=undefined}},onDestroy:function(){this.onDeactivate()},updateUI:function(a){Ext.getCmp(this.userPhotoReindexMsgId).setVisible(a);Ext.getCmp(this.userPhotoReindexBtnId).setDisabled(_S("demo_mode")||a)},onClickReindexBtn:function(){this.updateUI(true);SYNO.API.Request({api:"SYNO.Core.PersonalSettings",method:"photo",version:1,params:{action:"apply",reindex:true}})},onAfterLayout:function(){this.updateUI(false);Ext.getCmp(this.userPhotoLaunchBtnId).setDisabled(true);this.getForm().load({params:{api:"SYNO.Core.PersonalSettings",method:"photo",version:1,action:"load"}})},applyForm:function(d,b){var c=this.getForm();var a={};this.seqApplyAction={appFunc:null,appScope:null};if(null!==d&&null!==b){this.seqApplyAction.appFunc=d;this.seqApplyAction.appScope=b}if(!c.isDirty()){if(null!==this.seqApplyAction&&null!==this.seqApplyAction.appFunc){this.seqApplyAction.appFunc.apply(this.seqApplyAction.appScope)}return}a={api:"SYNO.Core.PersonalSettings",method:"photo",version:1,action:"apply"};c.doAction("apply",{params:a})},resetForm:function(){this.getForm().reset()},onBeforeAction:function(a,b){if("submit"===b.type||"apply"===b.type){this.module.setStatusBusy({text:_T("common","saving")})}else{if("load"===b.type){this.module.setStatusBusy()}}},onActionComplete:function(b,c){this.module.clearStatusBusy();Ext.getCmp(this.userPhotoLaunchBtnId).setDisabled(!c.result.data.user_photo_enable);SYNO.SDS.StatusNotifier.setServiceDisabled("SYNO.SDS.PersonalPhotoStation",!c.result.data.user_photo_enable);if("apply"===c.type||"submit"===c.type){var a=String.format('{0} (<a href="http://www.synology.com/support/download/{1}" target="_blank">{2}</a>)',_T("service","pps_enable_warning"),_D("upnpmodelname"),_T("service","pps_download_now"));if(c.result.data.user_photo_enable){this.findAppWindow().getMsgBox().alert(this.module.title,a,function(d){if("ok"===d){this.module.clearStatusBusy();if(null!==this.seqApplyAction&&null!==this.seqApplyAction.appFunc){this.seqApplyAction.appFunc.apply(this.seqApplyAction.appScope)}}},this)}}else{if("load"===c.type){this.module.clearStatusBusy()}}},onActionFailed:function(a,b){var d,c;a.reset();this.module.clearStatusBusy();if(Ext.form.Action.CLIENT_INVALID===b.failureType){d=_T("common","forminvalid")}else{if(Ext.form.Action.CONNECT_FAILURE===b.failureType){d=_T("common","commfail")}else{if(b.result&&Ext.isObject(b.result.errinfo)){c=b.result.errinfo;d=_T(c.sec,c.key);if(d===""){d=String.format("{0}{1}",c.sec,c.key)}if(Ext.isNumber(c.line)){d=String.format("{0} ({1})",d,c.line)}}else{if(Ext.form.Action.SERVER_INVALID===b.failureType){d=_T("error","error_bad_field")}else{d=_T("common","error_system")}}}}this.module.getMsgBox().alert(this.module.title,d)}});Ext.define("SYNO.PersonalSettings.SocialUserContainer",{extend:"Ext.Container",constructor:function(a){var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){Ext.apply(this,a||{});this.defaultIcon="../webman/modules/PersonalSettings/images/social_network_account.png";var b={xtype:"container",width:160,height:244,margins:{top:0,left:0,right:16,bottom:0},items:[{xtype:"box",cls:"blue-status syno-sds-personal-social-account-name",html:this.desc},{xtype:"container",layout:"vbox",cls:"syno-sds-personal-social-account",items:[{xtype:"box",id:this.iconId,itemId:"user_facebook_icon",cls:"thumb-user-icon",autoEl:{tag:"img",src:this.defaultIcon}},{id:this.displayId,xtype:"syno_displayfield",cls:"syno-sds-personal-social-user-name",value:""},{xtype:"container",width:136,cls:"syno-sds-personal-social-btn",items:[{xtype:"syno_button",id:this.btnId,btnStyle:"blue",text:_T("common","login"),handler:this.callback,scope:this.scope}]}]}]};return b},setContent:function(c){var b=Ext.getCmp(this.btnId);var d=Ext.getCmp(this.displayId);var a=Ext.getCmp(this.iconId);a.getEl().dom.src=c.pic;d.setValue(c.name);b.setText(_T("common","logout"));b.removeClass("syno-ux-button-blue");b.addClass("syno-ux-button-default")},clearContent:function(){var b=Ext.getCmp(this.btnId);var c=Ext.getCmp(this.displayId);var a=Ext.getCmp(this.iconId);b.setText(_T("common","login"));b.removeClass("syno-ux-button-default");b.addClass("syno-ux-button-blue");c.setValue("");a.getEl().dom.src=this.defaultIcon}});Ext.define("SYNO.SDS.App.PersonalSettings.SocialForm",{extend:"SYNO.ux.FormPanel",constructor:function(a){var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){Ext.apply(this,a||{});this.iconSize="128";this.facebookField=new SYNO.PersonalSettings.SocialUserContainer({desc:_T("sharing","facebook_desc"),iconId:this.userFacebookIconId=Ext.id(),displayId:this.facebookDisplayId=Ext.id(),btnId:this.facebookBtnId=Ext.id(),callback:this.onFacebookCallback,scope:this});this.googleField=new SYNO.PersonalSettings.SocialUserContainer({desc:_T("sharing","googleplus_desc"),iconId:this.userGoogleIconId=Ext.id(),displayId:this.googleDisplayId=Ext.id(),btnId:this.googleBtnId=Ext.id(),callback:this.onGoogleCallback,scope:this});var b={itemId:"socialAcountForm",name:"socialAcountForm",title:_T("user","social_account"),items:[{xtype:"syno_displayfield",value:_T("user","social_account_desc")},{xtype:"container",layout:"hbox",items:[this.facebookField,this.googleField]}],listeners:{afterrender:function(){var c={data:[{social_type:"Facebook",pic_size:this.iconSize},{social_type:"Google",pic_size:this.iconSize}]};this.ownerCt.ownerCt.setStatusBusy();this.getUserInfo(c)},scope:this}};return b},onFacebookCallback:function(e,c){if(e.getText()===_T("common","login")){window.clickBtn=e;window._loginCallback=this.onLoginFacebook.createDelegate(this);var g="_loginCallback";var b=window.location.href.indexOf("/",window.location.protocol.length+2);var d=window.location.href.slice(0,b)+"/webman/modules/PersonalSettings/index_ds.php";var a="http://update.synology.com/FileStation/facebook/login.php?callback="+g+"&fmHost="+d;window.open(a,"mywindow","menubar=1,resizable=0,width=600,height=520, top=100, left=300")}else{var f={social_type:"Facebook"};this.Logout(f,this.facebookField)}},onLoginFacebook:function(b){var a={social_type:"Facebook",access_token:b.token,social_id:b.uid};this.onSaveAccessToken(a,window.clickBtn)},onGoogleCallback:function(e,c){if(e.getText()===_T("common","login")){window.clickBtn=e;window._loginCallback=this.onLoginGoogle.createDelegate(this);var g="_loginCallback";var b=window.location.href.indexOf("/",window.location.protocol.length+2);var d=window.location.href.slice(0,b)+"/webman/modules/PersonalSettings/index_ds.php";var a="http://update.synology.com/FileStation/google/login.php?callback="+g+"&fmHost="+d;window.open(a,"mywindow","menubar=1,resizable=0,width=630,height=520, top=100, left=300")}else{var f={social_type:"Google"};this.Logout(f,this.googleField)}},onLoginGoogle:function(b){var a={social_type:"Google",access_token:b.token,refresh_token:b.refresh_token,social_id:b.uid};this.onSaveAccessToken(a,window.clickBtn)},onSaveAccessToken:function(c,a){var b=this;b.ownerCt.ownerCt.setStatusBusy();this.sendWebAPI({api:"SYNO.SocialAccount.Token",method:"set",version:1,params:c,callback:function(i,d,e){if(i){var h={data:[{pic_size:this.iconSize,social_type:c.social_type}]};b.getUserInfo(h)}else{var g=_T("common","share");var f=SYNO.API.getErrorString(d.code);this.ownerCt.ownerCt.getMsgBox().alert(g,f);b.ownerCt.ownerCt.clearStatusBusy()}},scope:this})},Logout:function(c,b){var a=this;a.ownerCt.ownerCt.setStatusBusy();this.sendWebAPI({api:"SYNO.SocialAccount.Token",method:"delete",version:1,params:c,callback:function(h,d,e){if(h){b.clearContent();a.ownerCt.ownerCt.clearStatusBusy()}else{var g=_T("common","share");var f=SYNO.API.getErrorString(d.code);this.ownerCt.ownerCt.getMsgBox().alert(g,f);a.ownerCt.ownerCt.clearStatusBusy()}},scope:this})},getUserInfo:function(b){var a=this;this.sendWebAPI({api:"SYNO.SocialAccount",method:"status",version:2,params:b,callback:function(f,d,e){if(f){d=d.result;for(var c=0;c<d.length;c++){if(!d[c].error){if(b.data[c].social_type==="Facebook"){a.facebookField.setContent(d[c])}else{a.googleField.setContent(d[c])}}}}a.ownerCt.ownerCt.clearStatusBusy()},scope:this})}});Ext.namespace("SYNO.SDS.App.PersonalSettings");Ext.define("SYNO.SDS.App.PersonalSettings.SmartBlockTrustDeviceWin",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.owner=a.owner;this.topwin=a.topwin;this.appInst=a.appInst;this.callParent([this.fillConfig(a)])},fillConfig:function(b){this.panel=new SYNO.SDS.App.PersonalSettings.SmartBlockTrustDevicePanel({owner:this,topwin:this.topwin,appInst:this.appInst});var a={title:_T("smartblock","manage_trust_title"),resizable:true,minimizable:false,maximizable:false,closable:true,layout:"fit",width:700,height:490,buttons:[{text:_T("common","close"),handler:this.close,scope:this}],items:[this.panel]};return Ext.apply(a,b)}});Ext.define("SYNO.SDS.App.PersonalSettings.SmartBlockTrustDevicePanel",{extend:"SYNO.ux.GridPanel",constructor:function(a){this.topwin=a.topwin;this.appInst=a.appInst;this.callParent([this.fillConfig(a)])},fillConfig:function(b){this.actionDistrust=new Ext.Action({text:_T("smartblock","action_distrust"),scope:this,handler:this.onDistrust});this.store=new SYNO.API.JsonStore({api:"SYNO.Core.SmartBlock.User",method:"list",version:1,listeners:{scope:this,exception:this.onException},appWindow:this.topwin,root:"devices",idProperty:"id",totalProperty:"total",id:"name",fields:[{name:"id",type:"string"},{name:"time",type:"int"},{name:"ip",type:"string"},{name:"agent",type:"string"}],defaultSortable:true});var a={ds:this.store,cm:new Ext.grid.ColumnModel({defaults:{sortable:true},columns:[{header:_T("smartblock","created_time"),headerHtmlEncode:false,dataIndex:"time",renderer:function(f,d,e){var c=SYNO.SDS.DateTimeFormatter(new Date(f*1000),{type:"datetime"});d.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c},width:100},{header:_T("common","ip_addr"),headerHtmlEncode:false,dataIndex:"ip",renderer:function(e,c,d){c.attr='ext:qtip="'+Ext.util.Format.htmlEncode(e)+'"';return e},width:70},{header:_T("smartblock","user_agent"),headerHtmlEncode:false,dataIndex:"agent",renderer:function(e,c,d){c.attr='ext:qtip="'+Ext.util.Format.htmlEncode(e)+'"';return e},width:230}]}),loadMask:true,autoExpandColumn:"name",enableDragDrop:false,enableColumnMove:false,enableHdMenu:false,selModel:new Ext.grid.RowSelectionModel({singleSelect:false}),tbar:[new SYNO.ux.Button(this.actionDistrust)],bbar:{xtype:"syno_paging",store:this.store,displayButtons:true,displayInfo:true,pageSize:50},listeners:{scope:this,afterRender:function(){this.mask(_T("common","loading"));this.store.load();this.unmask()}}};return Ext.apply(a,b)},onException:function(){this.store.loadData({devices:[],total:0},false)},onDistrust:function(){var a=this.getSelectionModel().getSelections().map(function(b){return b.data.id});if(a.length<=0){return}this.sendWebAPI({api:"SYNO.Core.SmartBlock.User",version:1,method:"distrust",params:{devices:a},scope:this,callback:this.onWebapiDone})},onWebapiDone:function(c,b,a){if(!c){this.getMsgBox().alert("",SYNO.API.getErrorString(b.code))}this.store.load()}});Ext.define("SYNO.SDS.App.PersonalSettings.SmartBlockForm",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(a){this.module=a.module;this.callParent([this.fillConfig(a)])},fillConfig:function(b){this.btnUnlock=new SYNO.ux.Button({xtype:"syno_button",text:_T("smartblock","unlock_self"),disabled:true,scope:this,handler:this.onUnlock});var a={title:_T("tree","leaf_smartblock"),fieldWidth:200,labelWidth:180,listeners:{afterlayout:{single:true,scope:this,fn:this.onAfterLayout}},items:[{xtype:"syno_displayfield",hideLabel:true,value:_T("smartblock","unlock_self_desc")},this.btnUnlock,{xtype:"syno_displayfield",hideLabel:true,value:_T("smartblock","trust_self_desc")},{xtype:"syno_button",text:_T("smartblock","trust_self"),scope:this,handler:this.onTrust},{xtype:"syno_displayfield",hideLabel:true,value:""},{xtype:"syno_button",text:_T("smartblock","smartblock_trust_manage"),scope:this,handler:this.onManage}]};return Ext.apply(a,b)},onAfterLayout:function(){this.loadStatus()},loadStatus:function(){this.module.setStatusBusy();this.sendWebAPI({api:"SYNO.Core.SmartBlock.User",method:"locked",version:1,scope:this,callback:function(c,b,a){this.module.clearStatusBusy();if(c&&b.locked){this.btnUnlock.enable()}}})},onUnlock:function(){this.btnUnlock.disable();this.module.setStatusBusy();this.sendWebAPI({api:"SYNO.Core.SmartBlock.User",version:1,method:"pardon",scope:this,callback:function(d,c,b,a){this.module.clearStatusBusy();this.loadStatus()}})},onTrust:function(){this.module.setStatusBusy();this.sendWebAPI({api:"SYNO.Core.SmartBlock.User",version:1,method:"trust",scope:this,callback:function(d,c,b,a){this.module.clearStatusBusy()}})},onManage:function(){var a=this.module;var b=new SYNO.SDS.App.PersonalSettings.SmartBlockTrustDeviceWin({owner:a,topwin:a,appInst:a.appInstance});b.show()}});Ext.namespace("SYNO.SDS.App.PersonalSettings");Ext.define("SYNO.SDS.App.PersonalSettings.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.App.PersonalSettings.MainWindow",constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.App.PersonalSettings.MainWindow",{extend:"SYNO.SDS.AppWindow",accountPanel:null,quotaGrid:null,customizePanel:null,otherPanel:null,smartblockPanel:null,pphotoPanel:null,mailPanel:null,blIsPPSEnable:false,constructor:function(b){var a=[];this.accountPanel=new SYNO.SDS.App.PersonalSettings.AccountForm({module:this});a.push(this.accountPanel);this.smartblockPanel=new SYNO.SDS.App.PersonalSettings.SmartBlockForm({disabled:true,module:this});a.push(this.smartblockPanel);if("yes"===_D("supportquota","no")){this.quotaGrid=new SYNO.SDS.App.PersonalSettings.QuotaGrid({module:this});a.push(this.quotaGrid)}this.customizePanel=new SYNO.SDS.App.PersonalSettings.CustomizeForm({module:this,baseURL:this.jsConfig.jsBaseURL});a.push(this.customizePanel);this.pphotoPanel=new SYNO.SDS.App.PersonalSettings.PPhotoForm({module:this});this.pphotoPanel.mon(this.pphotoPanel,"afterrender",function(){var c;c=new SYNO.SDS.Utils.EnableCheckGroup(this.pphotoPanel.getForm(),"user_photo_enable",["user_album_public"])},this);a.push(this.pphotoPanel);this.mailPanel=new SYNO.SDS.App.PersonalSettings.MailForm({module:this});a.push(this.mailPanel);this.otherPanel=new SYNO.SDS.App.PersonalSettings.OtherForm({module:this});a.push(this.otherPanel);this.callParent([Ext.apply({dsmStyle:"v5",width:850,height:this.isLDAP()?600:550,resizable:false,maximizable:false,layout:"fit",buttons:[{text:_T("common","apply"),btnStyle:"blue",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onApply,id:this.applyBtnId=Ext.id()},{text:_T("common","cancel"),scope:this,handler:this.close}],items:[{itemId:"panel",xtype:"syno_tabpanel",activeTab:0,plain:true,items:a}]},b)])},onOpen:function(a){this.callParent(arguments);if(a.tab===undefined){this.getComponent("panel").setActiveTab(0)}else{this.getComponent("panel").setActiveTab(a.tab);var b=this.getComponent("panel").getItem(a.tab);if(b&&a.evtName){b.fireEvent(a.evtName)}}},isLDAP:function(){return"ldap"===_S("authType")},onShow:function(){SYNO.API.Request({api:"SYNO.Core.PersonalSettings",method:"photo",version:1,params:{action:"load"},scope:this,callback:function(d,b,c,a){if(!d){this.getComponent("panel").remove(this.pphotoPanel);this.pphotoPanel=null;SYNO.SDS.App.PersonalSettings.MainWindow.superclass.onShow.apply(this,arguments);this.getMsgBox().alert(this.title,_T("common","commfail"))}else{if(undefined!==b.pphoto_enable){this.blIsPPSEnable=b.pphoto_enable}if(!this.blIsPPSEnable){this.getComponent("panel").remove(this.pphotoPanel);this.pphotoPanel=null}else{this.setWidth(930)}SYNO.SDS.App.PersonalSettings.MainWindow.superclass.onShow.apply(this,arguments)}}});SYNO.API.Request({api:"SYNO.Core.SmartBlock.User",version:1,method:"enabled",scope:this,callback:function(d,c,b,a){if(d&&c&&c.enabled){this.smartblockPanel.enable()}}})},onApply:function(){var h,g=false,f=false,a=false;if(this.otherPanel.hasNotification){if(window.Notification.permission==="default"&&this.otherPanel.form.findField("enableDesktopNotification").getValue()===true){window.Notification.requestPermission(function(i){window.Notification.permission=i})}}if(false===this.customizePanel.applyForm()){this.getComponent("panel").activate(this.customizePanel);return}if(false===this.mailPanel.applyForm()){this.getComponent("panel").activate(this.mailPanel);return}var e=this.accountPanel.getForm().findField("dateFormat");if(e&&e.isDirty()){SYNO.SDS.DateTimeUtils.SetUserFormat("date",e.getValue())}var c=this.accountPanel.getForm().findField("timeFormat");if(c&&c.isDirty()){SYNO.SDS.DateTimeUtils.SetUserFormat("time",c.getValue())}var b=this.accountPanel.getForm().findField("language");if(b&&b.isDirty()){SYNO.SDS.UserSettings.setProperty("Personal","lang",b.getValue())}var d=this.customizePanel.desktopStyleComboBox;if(d&&d.isDirty()){SYNO.SDS.UserSettings.setProperty("Desktop","desktopStyle",d.getValue())}g=b&&b.isDirty();f=d&&d.isDirty();a=(e&&e.isDirty())||(c&&c.isDirty());if(g||f||a){SYNO.SDS.UserSettings.syncSave();h=_T("personal_settings","refresh_confirm")+"<ul><br>"+(g?"<li>"+_T("personal_settings","lang_changed")+"</li>":"")+(f?"<li>"+_T("personal_settings","desktop_setting_changed")+"</li>":"")+"</ul>";SYNO.SDS.Desktop.mon(this,"destroy",function(){SYNO.SDS.Desktop.getMsgBox().confirm("",h,function(i){if("yes"===i){window.onbeforeunload=null;window.onbeforeunload=SYNO.SDS.onBeforeUnloadForApplication;location.reload()}},this)})}this.otherPanel.applyForm();if(this.blIsPPSEnable){this.pphotoPanel.applyForm(this.accountPanel.applyForm,this.accountPanel)}else{this.accountPanel.applyForm()}},onClose:function(){var a=false,b=false;if(false===this.callParent(arguments)){return false}if(this.accountPanel.getForm().isDirty()||this.customizePanel.getForm().isDirty()||this.otherPanel.getForm().isDirty()){a=true}if(this.blIsPPSEnable){if(this.pphotoPanel.getForm().isDirty()){b=true}}if(a||b){if(this.accountPanel.getForm().isDirty()){this.getComponent("panel").activate(this.accountPanel)}else{if(this.customizePanel.getForm().isDirty()){this.getComponent("panel").activate(this.customizePanel)}else{if(this.otherPanel.getForm().isDirty()){this.getComponent("panel").activate(this.otherPanel)}else{this.getComponent("panel").activate(this.pphotoPanel)}}}this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(c){if(SYNO.SDS.AppView.isVisible()){return false}else{if("yes"===c){if(this.customizePanel.getForm().isDirty()){this.customizePanel.restoreOrigSettings()}this.doClose()}}},this);return false}return true},getHelpParam:function(){switch(this.getComponent("panel").getActiveTab().itemId){case"account":return"MainMenu/account.html";case"quota":return"MainMenu/volumeusage.html";case"desktop":return"MainMenu/wallpaper.html";case"pphoto":return"MainMenu/personalphoto.html";case"others":return"MainMenu/others.html";case"socialAcountForm":return"MainMenu/options_socialnetwork.html";case"emailAccountForm":return"MainMenu/emailaccount.html"}return"MainMenu/Options_desc.html"}});