#!/bin/sh

logger -p err -s "Start backing up logs in junior mode"

. /usr/syno/share/environments.sh

IsMountSuccess=no
JuniorLogMnt=/juniorLogMnt
JuniorLogPath="${JuniorLogMnt}/.log.junior"
MaxRotateCount=4

Exit() {
	if [ "yes" = "${IsMountSuccess}" ]; then
		${UMOUNT} "${JuniorLogMnt}"
	fi

	${RMDIR} "${JuniorLogMnt}"
	exit $1
}

MountRootDevice() {
	${MKDIRP} "${JuniorLogMnt}"
	${MOUNT} ${RootDevice} "${JuniorLogMnt}/"
	return $?
}

PrepareLogs() {
	${LS} -Al / >/var/log/ls-result.log
	${PS} afx >/var/log/ps-result.log
	${DMESG} >/var/log/dmesg.log
}

RotateLogs() {
	Filename=${1}; shift
	FirstEmpty=${MaxRotateCount}
	for i in $(${SEQ} ${MaxRotateCount}); do
		if [ ! -f "${Filename}.${i}" ]; then
			FirstEmpty=${i}
			break;
		fi
	done
	for i in $(${SEQ} $((FirstEmpty - 1)) -1 1); do
		${MV} "${Filename}.${i}" "${Filename}.$((i + 1))"
	done
	${MV} "${Filename}" "${Filename}.1"
}

WrapLogs() {
	${MKDIRP} "${JuniorLogPath}"
	RotateLogs "${JuniorLogPath}/logs.tar"
	${TAR} -C / -cf "${JuniorLogPath}/logs.tar" var/log tmp
	return $?
}

if MountRootDevice; then
	IsMountSuccess=yes
else
	logger -p err -s "Failed to mount RootDevice"
	Exit 1
fi

PrepareLogs

if ! WrapLogs; then
	logger -p err -s "Failed to create tarball of logs"
	Exit 2
fi

Exit 0
