#!/bin/sh

# for debug log
UPS_LOG=`/bin/get_key_value /etc/synoinfo.conf upslog`
if [ $? -ne 1 ]; then
	UPS_LOG="/dev/null"
fi

echo "=== [" `date` "] udev check UPS rule ===" >> $UPS_LOG

vendorID=`echo $PRODUCT | awk -F/ '{printf("0x%04s", $1);}' | sed 's: :0:g'`
productID=`echo $PRODUCT | awk -F/ '{printf("0x%04s", $2);}' | sed 's: :0:g'`
echo "Vendor: $vendorID, Product: $productID, Action: $ACTION" >> $UPS_LOG

# table for UPS model
UPS_TABLE=/lib/udev/devicetable/usb.nut-hid

# Synology support list(Vendor ID)
APC="0x51d"                       
MGE="0x463"                                    
CyberPower="0x764"                                           
TrippLite="0x9ae"                                                                  
Belkin="0x50d"                                                              
Liebert="0x6da"           
PowerCOM="0xd9f"                                       
UPSList="$APC $MGE $CyberPower $TrippLite $Belkin $Liebert $PowerCOM"

# Black List
# Reason:
# Belkin_F5U002: printer
# ...
Belkin_F5U002="50d/2/104"
blackList="$BelkinF5U002"

isInBlackList()
{
	if [ -z "$1" ]; then
		return 1
	fi
	
	for dev in $blackList; do
		if [ "x$dev" = "x$1" ]; then
			echo "$1 is in the black list" >> $UPS_LOG
			return 0
		fi
	done
	return 1		
}

if [ -f ${UPS_TABLE} ]; then
	grep "libhidups      0x0003      $vendorID   $productID" $UPS_TABLE > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		if ! isInBlackList $PRODUCT; then 
			logger -p user.err -t "udev" "[UPS] $ACTION USB UPS(PRODUCT=$PRODUCT)"
			echo "$ACTION USB UPS(PRODUCT=$PRODUCT)" >> $UPS_LOG
			echo "support"
			exit 0
		fi
	fi
fi

echo "Device($PRODUCT) is not supported UPS..." >> $UPS_LOG
echo "unsupported"
exit 0


