#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_OP_RESULT_X
###############################################################

#At begining, acquire package settings
FILE_INDEX_BINARY=/usr/syno/bin/fileindex

FILEINDEX_PKG_NAME="Fileindex"
FILEINDEX_PKG_VERSION="1.0"
FILEINDEX_PKG_VENDOR="Synology Inc."
SDK_MODVER="2.0"

PauseAllShare() {
	INDEX=1;
	NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
		eval "FILEINDEX_SHARE_NAME=\$SHARE_NAME_$INDEX"
		${FILE_INDEX_BINARY} -a share_pause -s "${FILEINDEX_SHARE_NAME}"
		INDEX=$((INDEX + 1))
	done
}

CheckShareDeleted() {
	# Only hooked when shares are deleted successfully
	INDEX=1;
	NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
		eval "SHARE_OP_RESULT=\$SHARE_OP_RESULT_$INDEX"
		eval "FILEINDEX_SHARE_NAME=\$SHARE_NAME_$INDEX"
		if [ "0x0000" = "${SHARE_OP_RESULT}" ]; then
			${FILE_INDEX_BINARY} -a share_remove -s "${FILEINDEX_SHARE_NAME}"
		else
			${FILE_INDEX_BINARY} -a share_resume -s "${FILEINDEX_SHARE_NAME}"
		fi
		INDEX=$((INDEX + 1))
	done
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${FILEINDEX_PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${FILEINDEX_PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${FILEINDEX_PKG_VENDOR}
	;;
	--pre)
		#Actions before share delete
		PauseAllShare
	;;
	--post)
		#Actions after share delete
		CheckShareDeleted
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
