#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       SHARE_NAME, ENC_ACTION={encrypt|decrypt}, RESULT
###############################################################

#At begining, acquire package settings
FILE_INDEX_BINARY=/usr/syno/bin/fileindex

FILEINDEX_PKG_NAME="Fileindex"
FILEINDEX_PKG_VERSION="1.0"
FILEINDEX_PKG_VENDOR="Synology Inc."
SDK_MODVER="2.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${FILEINDEX_PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${FILEINDEX_PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${FILEINDEX_PKG_VENDOR}
	;;
	--pre)
		#Actions before share encrypt action
		if [ "encrypt" = "${ENC_ACTION}" ]; then
			${FILE_INDEX_BINARY} -a share_pause  -s "${SHARE_NAME}"
		fi
	;;
	--post)
		#Actions after share encrypt action
		if [ "encrypt" = "${ENC_ACTION}" ]; then
			if [ "0" != "${RESULT}" ]; then
				${FILE_INDEX_BINARY} -a share_resume -s "${SHARE_NAME}"
			fi
		elif [ "decrypt" = "${ENC_ACTION}" ]; then
			if [ "0" = "${RESULT}" ]; then
				${FILE_INDEX_BINARY} -a share_resume -s "${SHARE_NAME}"
			fi
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
