#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareUpdate() SYNOShareCreate() SYNOShareClone()
#   Usable environment variable:
#       SHARE_NAME, RESULT, SHARE_FILEINDEXED, ORIGIN_SHARE_FILEINDEXED
###############################################################

#At begining, acquire package settings
FILE_INDEX_BINARY=/usr/syno/bin/fileindex

FILEINDEX_PKG_NAME="Fileindex"
FILEINDEX_PKG_VERSION="1.0"
FILEINDEX_PKG_VENDOR="Synology Inc."
SDK_MODVER="2.0"

CheckShareNameChange() {
	# if origin share name is empty, skip it
	if [ "" = "${ORIGIN_SHARE_NAME}" ] ; then
		return
	fi

	# share name changed or share path changed
	if [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ] ||
	   [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ]; then
		IS_RENAME=1
	fi;
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${FILEINDEX_PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${FILEINDEX_PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${FILEINDEX_PKG_VENDOR}
	;;
	--pre)
		#Actions before share set
		IS_RENAME=0

		#Check hook condition
		CheckShareNameChange

		if [ "1" = "${IS_RENAME}" ]; then
			${FILE_INDEX_BINARY} -a share_pause  -s "${ORIGIN_SHARE_NAME}"
		fi
	;;
	--post)
		#Actions after share set
		IS_RENAME=0

		#Check hook condition
		CheckShareNameChange

		if [ "1" = "${IS_RENAME}" ]; then
			if [ "0" = "${RESULT}" ]; then
				${FILE_INDEX_BINARY} -a share_rename -o ${ORIGIN_SHARE_NAME} -s ${SHARE_NAME}
				${FILE_INDEX_BINARY} -a share_resume  -s "${SHARE_NAME}"
				${FILE_INDEX_BINARY} -a reindex -p "/${SHARE_NAME}"
			else
				${FILE_INDEX_BINARY} -a share_resume  -s "${ORIGIN_SHARE_NAME}"
			fi
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
