#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareSnapXXXX()
#   XXXX: Create, Restore, Clone
#   Usable environment variable:
#       SHARE_NAME, SHARE_PATH, NEW_SHARE_NAME, NEW_SHARE_PATH, SNAPSHOT, ACTION, ENC_STATUS, RESULT
###############################################################

#At begining, acquire package settings
FILE_INDEX_BINARY=/usr/syno/bin/fileindex

FILEINDEX_PKG_NAME="Fileindex"
FILEINDEX_PKG_VERSION="1.0"
FILEINDEX_PKG_VENDOR="Synology Inc."
FILEINDEX_PKG_MODVER="2.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version. Right now, Share module is 2.0
		echo ${FILEINDEX_PKG_MODVER}
	;;
	--name)
		#Print name
		echo ${FILEINDEX_PKG_NAME}
	;;
	--pkg-ver)
		echo ${FILEINDEX_PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${FILEINDEX_PKG_VENDOR}
	;;
	--pre)
		#Actions before share restore
		case $ACTION in
		CREATE)
			;;
		RESTORE)
			${FILE_INDEX_BINARY} -a share_pause -s "${SHARE_NAME}"
			;;
		CLONE_SHARE)
			;;
		CLONE_SNAP)
			;;
		*)
			;;
		esac
	;;
	--post)
		#Actions after share restore
		case $ACTION in
		CREATE)
			;;
		RESTORE)
			${FILE_INDEX_BINARY} -a share_resume -s "${SHARE_NAME}"
			${FILE_INDEX_BINARY} -a reindex -p "/${SHARE_NAME}"
			;;
		CLONE_SHARE)
			;;
		CLONE_SNAP)
			;;
		*)
			;;
		esac
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
