#!/usr/bin/env python
# coding: utf-8
# Copyright (c) 2000-2015 Synology Inc. All rights reserved.

from utils import *
from datetime import *

class RuleDictResult(DictResult):
    _non_comp_version = ['1.0-0~5.0-4490', '5.0', '5.1', '5.2-5533~5.2-5682',
            ## router
            '5.2-5150~5.2-5249', '5.2-5700~5.2-5789', '5.2-6000~5.2-7099']
    _group = [GROUP_HOME, GROUP_COMPANY]
    _category = CATEGORY_SYSTEM_CHECK
    _severity = LEVEL_WARNING
    _strId = "rule_dsm_integrity_check"

    _selfcheckLogPath = "/var/log/selfcheck/dsm.hash.result.for.integrity.rule1"
    _dataverifierLogPath = "/var/log/selfcheck/dsm.integrity.check.result.rule1"
    _checkFailedFiles = []
    _notConsistFiles = []
    _WhiteList = ['/bin/zarafa-admin', '/bin/zarafa-fsck', '/bin/zarafa-passwd', '/bin/zarafa-archiver', '/bin/zarafa-gateway', '/bin/zarafa-server', '/bin/zarafa-autorespond', '/bin/zarafa-ical', '/bin/zarafa-spooler', '/bin/zarafa-dagent', '/bin/zarafa-monitor', '/bin/zarafa-stats', '/bin/zarafa-search']

    def getStatus(self):
        # Step 1. check and store the files which failed to pass synoselfcheck
        if os.path.exists(self._selfcheckLogPath):
            with SynoCriticalSection() as cs:
                os.unlink(self._selfcheckLogPath)
        if os.path.exists(self._dataverifierLogPath):
            with SynoCriticalSection() as cs:
                os.unlink(self._dataverifierLogPath)

        with SynoCriticalSection() as cs:
            execute("/usr/syno/bin/synoselfcheck -h -o dsm.hash.result.for.integrity.rule1 dsm full")

        try:
            with SynoCriticalSection() as cs:
                _selfcheckLog = open(self._selfcheckLogPath, 'r')

            for line in _selfcheckLog:
                if not line.strip():
                    continue

                filename = line.split(" ")[0]

                if filename in self._WhiteList:
                    continue

                if filename not in self._checkFailedFiles:
                    self._checkFailedFiles.append(filename)

            _selfcheckLog.close()
        except Exception as e:
            SYSLOG(syslog.LOG_ERR, "[integrity_check_inconsist] Failed to do synoselfcheck: %s" % e)
            return SZ_ERROR

        # Step 2. check consistency
        try:
            with SynoCriticalSection() as cs:
                _dataverifierLog = open(self._dataverifierLogPath, 'w')

            for filename in self._checkFailedFiles:
                _log = "check file: %s, " % str(filename)
                _dataverifierLog.write(_log)
                cmd = "/usr/syno/bin/synodataverifier --check-file-consistency %s | grep -c 'Check OK'" % str(filename)
                with SynoCriticalSection() as cs:
                    ret = execute(cmd)

                match_cnt = int(ret[0])
                if 0 == match_cnt:
                    _log = "[Fail] NOT consist on md0\n"
                    _dataverifierLog.write(_log)
                    self._notConsistFiles.append(filename)
                elif 1 == match_cnt:
                    _log = "[Pass] consist on md0\n"
                    _dataverifierLog.write(_log)
                else:
                    _log = "[Fail] check consistency error\n"
                    _dataverifierLog.write(_log)
                    self._notConsistFiles.append(filename)

            _dataverifierLog.close()
        except Exception as e:
            SYSLOG(syslog.LOG_ERR, "[integrity_check_inconsist] Failed to do synodataverifier: %s" % e)
            return SZ_ERROR

        return SZ_PASS if len(self._notConsistFiles) == 0 else SZ_FAIL

    def getMethod(self):
        return {
            METHOD_ACTION: METHOD_ACTION_LINK,
            METHOD_ACTION_VAL: 'SYNO.SDS.StorageManager.Instance:SYNO.SDS.StorageManager.Disk.Main',
            METHOD_LINK_APP_STR: 'helptoc:disk_manager'
        }

    def getAction(self):
        return {ACTION_STR_KEY: 'action', ACTION_REPLACE_VAR: {
            '_FILES_': ', '.join(self._notConsistFiles)
        }}
