<?php
/* Copyright (c) 2011 Synology Inc. All rights reserved. */

class SynoFileHostingBaiduPan {
	private $Url;
	private $HostInfo;
	private $BAIDUPAN_COOKIE = '/tmp/baidupan.cookie';
	private $userAgent = "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.57 Safari/537.36";
	private $ERROR_CAPTCHA = -19;
	private $BaiduRefererUrl = "http://pan.baidu.com/wap/";
	private $directDownloadPrefix = "d.pcs.baidu.com";

	public function __construct($Url) {
		$this->Url = $Url;
		$this->HostInfo = $HostInfo;
	}

	public function GetDownloadInfo() {
		$ret = FALSE;
		$parseArray = array();
		$parseArray = parse_url($this->Url);
		if($this->directDownloadPrefix === $parseArray['host']) {
			$ret = $this->directDownload();
		} else {
			$ret = $this->getDownloadLink();
		}
End:
		return $ret;
	}

	private function directDownload() {
		$ret = FALSE;
		if(FALSE === ($ret = $this->getFinalUrl($this->Url, $this->BaiduRefererUrl))) {
			goto End;
		}
End:
		return $ret;
	}

	private function parseInfoFromRetContent($retContent = FALSE){
		$ret = FALSE;
		if(FALSE === $retContent){
			LogError("Content returned by Baidu Pan is false");
			goto End;
		}
		preg_match('/FileUtils\.share_uk=\"(\d+)\"\;/', $retContent, $shareUK);
		preg_match('/FileUtils\.share_id=\"(\d+)\"\;/', $retContent, $shareID);
		preg_match('/fs_id\D+(\d+)\D+app_id/', $retContent, $fsID);
		preg_match('/FileUtils\.share_timestamp=\"(\d+)\"/', $retContent, $shareTimeStamp); 
		preg_match('/FileUtils.share_sign=\"(\w+)\"/', $retContent, $shareSign);
		if(empty($shareUK[1]) || empty($shareID[1]) || empty($fsID[1]) || empty($shareTimeStamp[1]) || empty($shareSign[1]) ){
			LogError("Parsing error in Baidu Pan");
			goto End;
		}
		$link="http://pan.baidu.com/share/download?channel=chunlei&clienttype=0&web=1&uk=$shareUK[1]&shareid=$shareID[1]&timestamp=$shareTimeStamp[1]&sign=$shareSign[1]&fid_list=[\"$fsID[1]\"]&channel=chunlei&clienttype=0&web=1";
		$ret = $link;
End:
		return $ret;
	}

		/*get final url*/
	private function getFinalUrl($requestUrl,$refererUrl) {
		$ret = FALSE;
		$curlOption = array(CURL_OPTION_SAVECOOKIEFILE=>$this->BAIDUPAN_COOKIE,
							CURL_OPTION_LOADCOOKIEFILE=>$this->BAIDUPAN_COOKIE,
							CURL_OPTION_FOLLOWLOCATION=>TRUE);
		$curl = GenerateCurl($requestUrl, $curlOption);
		curl_setopt($curl, CURLOPT_NOBODY, TRUE);
		curl_setopt($curl, CURLOPT_REFERER, $refererUrl);
		curl_setopt($curl, CURLOPT_USERAGENT, $this->userAgent);
		$DownloadInfo = curl_exec($curl);
		$curlInfo = curl_getinfo($curl);
		curl_close($curl);

		if (200 != $curlInfo['http_code']){
			$ret[DOWNLOAD_ERROR] = ERR_FILE_NO_EXIST;
			goto End;
		}
		$ret[DOWNLOAD_URL] = trim($curlInfo['url']);
		$parseArray = array();
		$parseArray = parse_url($ret[DOWNLOAD_URL]);
		parse_str($parseArray['query'], $queryArray);
		if(!empty($queryArray['fn'])){
			$fileName = urldecode($queryArray['fn']);
			$fileName = html_entity_decode(trim($fileName), ENT_QUOTES);
			$fileName = EscapeChange($fileName);
			$ret[DOWNLOAD_FILENAME] = $fileName;
		}
End:
		return $ret;
	}


	private function getDownloadLink()
	{
		$ret = FALSE;
		$curlOption = array(CURL_OPTION_SAVECOOKIEFILE=>$this->BAIDUPAN_COOKIE,
							CURL_OPTION_LOADCOOKIEFILE=>$this->BAIDUPAN_COOKIE);
		$curl = GenerateCurl($this->Url,$curlOption);
		curl_setopt($curl, CURLOPT_USERAGENT, $this->userAgent);
		$retContent = curl_exec($curl);
		curl_close($curl);
		$requestLink = $this->parseInfoFromRetContent($retContent);
		if(FALSE === $requestLink){
			goto End;
		}

		/*get dlink*/
		$curlOption = array(CURL_OPTION_SAVECOOKIEFILE=>$this->BAIDUPAN_COOKIE,
							CURL_OPTION_LOADCOOKIEFILE=>$this->BAIDUPAN_COOKIE);
		$curl = GenerateCurl($requestLink, $curlOption);
		curl_setopt($curl, CURLOPT_REFERER, $this->Url);
		curl_setopt($curl, CURLOPT_USERAGENT, $this->userAgent);
		$retContent = curl_exec($curl);
		curl_close($curl);
		if(false === $retContent){
			LogError("Return false when ask info");
			goto End;
		}
		$retJsonObj = json_decode($retContent, true);
		$errorNo = $retJsonObj["errno"];
		$retDLink = $retJsonObj["dlink"];
		if($this->ERROR_CAPTCHA == $errorNo){
			$ret[DOWNLOAD_COUNT] = '7200';
			$ret[DOWNLOAD_ISQUERYAGAIN] = '1';
			$ret[INFO_NAME] = trim($this->HostInfo[INFO_NAME]);
			goto End;
		}

		if(FALSE === ($ret = $this->getFinalUrl($retDLink, $requestLink))) {
			goto End;
		}
End:
		return $ret;
	}
}
?>
