<?php
/* Copyright (c) 2014 Synology Inc. All rights reserved. */

class SynoGoFileMe extends abstractSynoFileHosting {

	private $MAINURL = 'http://gofile.me/';

	public function GetDownloadInfo() {
		$DownloadData = $this->createData("DownloadData");
		$browser = NULL;

		if (!preg_match('/'. str_replace( '/', '\/', $this->MAINURL).'(\w*)\/(\w*)/', $this->Url, $matches)) {
			$DownloadData->error = ERR_FILE_NO_EXIST;
			goto End;
		}

		$query_url = $this->MAINURL."Redirect.php?server_ID=".$matches[1]."&sharing_ID=".$matches[2];

		$browser = new SynoBrowser();

		if (200 != $browser->browse($query_url)) {
			$httpRetCode = $browser->getHttpStatus();
			$DownloadData->error = ERR_UNKNOWN;
			if (404 == $httpRetCode) {
				$DownloadData->error = ERR_FILE_NO_EXIST;
			}
			goto End;
		}

		if (preg_match('/(pwd_iframe)/i', $browser, $matches)) {
			$DownloadData->error = ERR_REQUIRED_ACCOUNT;
			goto End;
		}

		if (!preg_match('/((https?:\/\/?|www[.])[^\s()<>]+)/i', $browser, $matches)) {
			$DownloadData->error = ERR_UNKNOWN;
			goto End;
		}

		$DownloadData->downloadurl = $matches[1];

		if (preg_match('/<div class = \'filename\'> ([^<]*)/', $browser, $matches)) {
			$DownloadData->filename = $matches[1];
		}
End:
		if ($browser) {
			$browser->clear();
		}
		return $DownloadData;
	}
}
?>
