#!/bin/sh
# Copyright (c) 2000-2011 Synology Inc. All rights reserved.

PACKAGE_DIR="/var/packages/DownloadStation"
PACKAGE_TARGET_DIR="${PACKAGE_DIR}/target"
PACKAGE_ETC_DIR="${PACKAGE_DIR}/etc"
Scheduler="${PACKAGE_TARGET_DIR}/sbin/scheduler"
PidFile="/var/run/scheduler.pid"
KERNEL_VERSION=`uname -r`
SwapScript="/usr/syno/bin/swapaction"
PSQL="/usr/bin/psql"

MAXDISKS=`/bin/get_key_value /etc.defaults/synoinfo.conf maxdisks`
if [ ${MAXDISKS} -eq 0 ]; then
	DISKLESS="yes"
fi

MvLnKnownMet()
{
	FILES="known.met known2.met known2_64.met"
	SZD_AMULE="${PACKAGE_ETC_DIR}/amule"
	SZD_DOWNLOAD="/var/services/download"

	for f in $FILES; do
		rm -rf $SZD_AMULE/$f >/dev/null 2>&1
		ln -s $SZD_DOWNLOAD/$f $SZD_AMULE/$f
	done
}

ExecSqlCommand()
{
	$PSQL -U postgres download -c "$1" > /dev/null 2>&1
}

CheckIfDaemonAlive()
{
	if [ -f "$1" ]; then
		local processPid=`cat $1`
		kill -0 ${processPid} > /dev/null 2>&1
		if [ "0" = "$?" ]; then
			true
			return
		fi
	fi
	false
}

case $1 in
"start")
	SupportDL=`/bin/get_key_value /etc.defaults/synoinfo.conf support_download`
	case "$SupportDL" in
	[Yy][Ee][Ss])
		;;
	*)
		echo "Download Station is not support here."
		exit
		;;
	esac
	/usr/syno/sbin/synoservicecfg --is-enabled pgsql
	# in service framework, function 'is-enabled' will retrun 1 if service is enabled
	# $? == 0 means service is not enabled
	if [ $? -eq 0 ]; then
		echo "PGSQL service is disabled. Skip..."
		exit 1
	fi

	download_path="`/usr/bin/readlink /var/services/download`"
	Ret=$?
	if [ $Ret -eq 0 -a ! -d "$download_path" ]; then
		if [ "`echo ${download_path} | cut -d'/' -f3`" = "@download" ]; then
			path_to_check="/`echo ${download_path} | cut -d'/' -f2`/usbshare/@download"
			if [ -d "${path_to_check}" ]; then
				rm -f /var/services/download
				ln -sf $path_to_check /var/services/download
			fi
		fi
	fi

	if CheckIfDaemonAlive "$PidFile"; then
		echo "scheduler already exists"
		exit
	fi

	echo "test sysconf table in download db"
	ExecSqlCommand "SELECT 1 from sysconf"
	Ret=$?
	if [ $Ret != 0 ]; then
		if [ $Ret = 1 ]; then
			echo "Drop old database"
			su -l postgres -c "/usr/syno/pgsql/bin/dropdb download"
			if [ $? != 0 ]; then
				echo "Failed to drop old database"
				exit
			fi
		fi
	fi

	echo "Update download queue table and set all pid to -1"
	ExecSqlCommand "UPDATE download_queue SET pid=-1"
	Ret=$?
	if [ $Ret = 2 ]; then
		su -l postgres -c "/usr/syno/pgsql/bin/createdb download"
		if [ $? != 0 ]; then
			echo "Failed to create database"
			exit
		fi
		Ret=1
	fi

	if [ $Ret = 1 ]; then
		su -l postgres -c "/usr/bin/psql download < ${PACKAGE_TARGET_DIR}/scripts/sql/download.pgsql"
		if [ $? != 0 ]; then
			echo "Failed to initial download database"
			exit
		fi
	fi
	# For upgrade pgsql, create function and trigger without check their existence
	ExecSqlCommand "CREATE FUNCTION \"SYNODownloadTrigger\"() RETURNS \"trigger\" AS '/var/packages/DownloadStation/target/lib/libsynotrigger.so' LANGUAGE 'c' IMMUTABLE;"
	ExecSqlCommand "CREATE TRIGGER \"HaveTaskTrigger\" AFTER INSERT OR UPDATE ON user_setting FOR EACH STATEMENT EXECUTE PROCEDURE \"SYNODownloadTrigger\"();"
	ExecSqlCommand "CREATE TRIGGER \"HaveTaskTrigger\" AFTER INSERT OR UPDATE ON download_queue FOR EACH STATEMENT EXECUTE PROCEDURE public.\"SYNODownloadTrigger\"();"

	upgrades=`find ${PACKAGE_TARGET_DIR}/scripts/sql/upgrade/ -name "*.sh" | sort`
	for ThisArg in $upgrades;
	do
		$ThisArg
	done

	# Set the status TASK_DOWNLOADING, TASK_FINISHING, TASK_PRESEEDING, TASK_SEEDING to TASK_WAITING
	ExecSqlCommand "UPDATE download_queue SET status=1 WHERE status=2 or status=4 or status=7 or status=8"
	if [ "x${DISKLESS}" = "xyes" ]; then
		$SwapScript on &
	fi

	# Set is_updating to FALSE for all RSS task
	ExecSqlCommand "UPDATE rss_feed SET is_updating='FALSE'"
	if [ $? != 0 ]; then
		echo "Failed to set is_updating to FALSE"
	fi

	echo "Starting Download Station scheduler daemon ..."
	case "$KERNEL_VERSION" in
	"2.4.22-uc0" | "2.6.24")
		# skip adjust max fd of ppc and 824x
		;;
	*)
	ulimit -n 2048
		;;
	esac
	MvLnKnownMet

	$Scheduler

	/usr/bin/renice -20 `/bin/ps -I | /bin/grep kswapd | /bin/grep -v grep | /usr/bin/awk '{print $1}'`
	;;
"stop")
	if [ "x${DISKLESS}" = "xyes" ]; then
		$SwapScript off
	fi
	
	[ -f "$PidFile" ] || exit
	Pid=`cat $PidFile`
	echo "Stopping scheduler ..."
	kill -TERM $Pid > /dev/null 2>&1
	
	# check whether the scheduler is alive
	Count=1
	IsAlive=1
	while [  $Count -le 20 ]
	do
		kill -0 $Pid > /dev/null 2>&1
		if [ $? = 1 ]; then
			IsAlive=0
			break;
		fi
		
		Count=`expr $Count + 1`
		sleep 1	
	done
	
	if [ $IsAlive = 1 ]; then
		echo "Unusual situation: kill scheduler forcedly" >> /var/log/messages
		killall -9 scheduler > /dev/null 2>&1
	fi
	killall -9 transmissiond > /dev/null 2>&1
	killall -9 amuled > /dev/null 2>&1
	killall -9 synoamulecgid > /dev/null 2>&1
	rm /tmp/amule_reply.fifo.* > /dev/null 2>&1
        

	/usr/bin/renice -5 `/bin/ps -I | /bin/grep kswapd | /bin/grep -v grep | /usr/bin/awk '{print $1}'`
	;;
"restart")
	$0 stop
	sleep 1
	$0 start
	;;
*)
	echo "Usage: $0 start|stop|restart"
	;;
esac
