<?
/* Copyright (c) 2011 Synology Inc. All rights reserved. */
define('SEARCH_PLUGIN_CLS_PREFIX', 'SynoDLMSearch');
define('DEFAULT_SEARCH_PLUGIN_DIR', dirname(realpath($argv[0])) . "/" . 'plugins');
define('USER_SEARCH_PLUGIN_DIR', '/var/packages/DownloadStation/etc/download/userplugins');
define('SEARCH_ACCOUNT_CONF', '/var/packages/DownloadStation/etc/download/btsearch.conf');
define('DOWNLOAD_STATION_USER_AGENT', "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/535 (KHTML, like Gecko) Chrome/14 Safari/535");
define('DOWNLOAD_TIMEOUT', 20);
define('SEARCH_RESULT_TABLE_STMT',
'CREATE TABLE search_results (
	result_id INTEGER PRIMARY KEY NOT NULL,
	title TEXT,
	dlurl TEXT,
	size REAL,
	date TEXT,
	page TEXT,
	hash TEXT,
	seeds INTEGER DEFAULT 0,
	leechs INTEGER DEFAULT 0,
	peers INTEGER DEFAULT 0,
	category TEXT,
	provider TEXT,
	provider_id TEXT
)');
define('DEFAULT_OUTPUT_DB', 'searchresult.sdb');
define('ERR_INSTPLUGIN_UNKNOWN', 1);
define('ERR_INSTPLUGIN_EXIST', 2);
define('ERR_INSTPLUGIN_INVALID_PLUGIN', 3);
define('ERR_UPATE_FAIL', 4);
define('DOWNLOAD_USERNAME', 'username');
define('DOWNLOAD_PASSWORD', 'password');
define('DOWNLOAD_URL', 'downloadurl');
define('DOWNLOAD_COOKIE', 'cookiepath');
include_once('lib/simplepie.inc');
include_once('lib/idn/idna_convert.class.php');

$gVerbose = FALSE;
function LogError($msg) {
	global $gVerbose;
	syslog(LOG_ERR, $msg);
	if($gVerbose) {
		echo $msg . "\n";
	}
}

function LogInfo($msg) {
	global $gVerbose;
	syslog(LOG_INFO, $msg);
	if($gVerbose) {
		echo $msg . "\n";
	}
}
function ConvertFileSize($s) {
	$fs = trim($s);
	$unit = substr($fs, -2);
	$size = floatval($fs);
	if(strcasecmp($unit, 'MB') == 0) {
		$size = $size*1024.0*1024.0;
	}
	else if(strcasecmp($unit, 'GB') == 0) {
		$size = $size*1024.0*1024.0*1024.0;
	}
	else if(strcasecmp($unit, 'KB') == 0) {
		$size = $size*1024.0;
	}
	return $size;

}

function ExecCmd($binaryPath, array $parameters, &$output = NULL, &$returnValue = NULL)
{
	static $skipEscape = array('>', '<', '|', '&');

	if (!is_string($binaryPath) || !is_array($parameters)) {
		return;
	}

	$escapedArguments = array();
	foreach ($parameters as $param) {
		if (in_array($param, $skipEscape)) {
			$escapedArguments[] = $param;
		} else {
			$cmd = '';
			foreach (explode('*', $param) as $key => $value) {
				if ($key !== 0) {
					$cmd .= '*';
				}
				$cmd .= escapeshellarg($value);
			}
			$escapedArguments[] = $cmd;
		}
	}

	$cmd = escapeshellarg($binaryPath) . " " . implode(' ', $escapedArguments);
	return exec($cmd, $output, $returnValue);
}

?>
