<?php
define ('PLUGIN_DIR', '/var/packages/DownloadStation/target/xunleiplugin/');
define ('XUNLEI_PLUGIN_CONF_DIR', '/var/packages/DownloadStation/etc/download/xunlei.conf');
define ('ERRCODE_SHIFT_NUM', 399);
define ('SUCCESS', 0);
define ('ERR_COMMON', 400);
define ('ERR_FAIL_LOGIN',401);
define ('ERR_USER_NOT_LOGIN',402);
define ('ERR_FAIL_READ_CONF',403);
define ('ERR_ACCOUNT_EMPTY',451);
define ('PYTHON', '/usr/bin/python');
define ('TASK_ID', 'taskId');
define ('TASK_DATE', 'date');
define ('TASK_PROGRESS', 'progress');
define ('TASK_SIZE', 'size');
define ('TASK_STATUS', 'status');
define ('TASK_FILENAME', 'filename');
define ('TASK_COMPLETED', 'completed');
define ('TASK_TIMELEFT', 'timeleft');
define ('TASK_SPEED', 'speed');
define ('TASK_ORIURL', 'url');
define ('TASK_REMAIN', 'remain');

function ExecCmd($binaryPath, array $parameters, &$output = NULL, &$returnValue = NULL)
{
	static $skipEscape = array('>', '<', '|', '&');

	if (!is_string($binaryPath) || !is_array($parameters)) {
		return;
	}

	$escapedArguments = array();
	foreach ($parameters as $param) {
		if (in_array($param, $skipEscape)) {
			$escapedArguments[] = $param;
		} else {
			$cmd = '';
			foreach (explode('*', $param) as $key => $value) {
				if ($key !== 0) {
					$cmd .= '*';
				}
				$cmd .= escapeshellarg($value);
			}
			$escapedArguments[] = $cmd;
		}
	}

	$cmd = escapeshellarg($binaryPath) . " " . implode(' ', $escapedArguments);
	return exec($cmd, $output, $returnValue);
}
?>
