<?php
include_once(PLUGIN_DIR . 'common.php');
define ('IAMBUS_PATH',PLUGIN_DIR . 'iambus/');
define ('RETRY_TIMES', 3);
class SynoXunleiPluginIambus {

	private $_account;
	private $_password;

	private $COMMAND;
	private $COOKIE;
	private $IAMBUS;

	public function __construct($account, $password) {
		$this->IAMBUS = IAMBUS_PATH . 'lixian_cli.py';
		$this->COOKIE = IAMBUS_PATH . 'xunlei_lixian_cookies';
		$this->COMMAND = PYTHON ." ". $this->IAMBUS;
		$this->_account = $account;
		$this->_password = $password;
	}

	public function ListTaskInfoPlugin($type, &$retData) {
		$retCode;
		$cmd = $this->COMMAND . " list --speed --size --progress --date --no-colors";
		if ("downloading" == $type) {
			$cmd = $cmd . " --all";
		} else {
			$cmd = $cmd . " " . escapeshellarg("--".$type);
		}
		for ($i = 0; $i < RETRY_TIMES; $i++) {
			$this -> ExecCmd($cmd, $output, $retCode);
			if (ERR_USER_NOT_LOGIN == $retCode) {
				$this -> RetryIfNotLogin($cmd, $output, $retCode);
				if (SUCCESS == $retCode) {
					$retData = $this->ParseTaskOutput($output, $type);
				}
				break;
			}
			if (SUCCESS == $retCode) {
				$retData = $this->ParseTaskOutput($output, $type);
				break;
			}
		}
		return $retCode;
	}
	private function MappingStatus($status) {
		$fmtStatus = "";
		if ("downloading" === $status) {
			$fmtStatus = "TASK_DOWNLOADING";
		} else if ("pending" === $status) {
			$fmtStatus = "TASK_PAUSED";
		} else if ("completed" === $status) {
			$fmtStatus = "TASK_FINISHED";
		} else if ("waiting" === $status) {
			$fmtStatus = "TASK_WAITING";
		} else if ("deleted" === $status) {
			$fmtStatus = "TASK_DELETED";
		} else if ("expired" === $status) {
			$fmtStatus = "TASK_EXPIRED";
		} else if ("failed" === $status) {
			$fmtStatus = "TASK_ERROR";
		} else {
			$fmtStatus = $status;
		}
		return $fmtStatus;
	}
	private function ConvertSpeedToByte($fmtSpeed) {
		$speed = (float) $fmtSpeed;
		if (stristr($fmtSpeed, 'G')) {
			$speed = $speed *1024*1024*1024;
		} else if (stristr($fmtSpeed, 'M')) {
			$speed = $speed *1024*1024;
		} else if (stristr($fmtSpeed, 'K')) {
			$speed = $speed *1024;
		}
		return $speed;
	}
	private function ParseTaskOutput($output, $type) {
		$jsonOutput = json_decode($output[0], true);
		$taskList = array();

		if(!is_array($jsonOutput)) {
			goto End;
		}

		foreach ($jsonOutput as $task) {
			$fmtTask[TASK_ID] = $task["id"];
			if (NULL == $fmtTask[TASK_ID]) {
				continue;
			}
			if ("deleted" == $type) {
				$fmtTask[TASK_STATUS] = $this->MappingStatus("deleted");
			} else if ("expired" == $type) {
				$fmtTask[TASK_STATUS] = $this->MappingStatus("expired");
			} else {
				$fmtTask[TASK_STATUS] = $this->MappingStatus($task['status']);
			}
			$fmtTask[TASK_SIZE] = (float)$task['size'];
			$fmtTask[TASK_PROGRESS] = $task['progress'];
			$fmtTask[TASK_DATE] = $task['date'];//text string

			if ('TASK_FINISHED' === $fmtTask[TASK_STATUS] ||
				'TASK_ERROR' === $fmtTask[TASK_STATUS]) {
				$fmtTask[TASK_SPEED] = -1;
			} else {
				$fmtTask[TASK_SPEED] = $this->ConvertSpeedToByte($task['speed']);
			}

			$progress = str_replace("%", "", $fmtTask[TASK_PROGRESS]);
			$progress = (float)$progress / 100;
			$fmtTask[TASK_COMPLETED] = ceil($progress * $fmtTask[TASK_SIZE]);
			$fmtTask[TASK_REMAIN] =  $fmtTask[TASK_SIZE] - $fmtTask[TASK_COMPLETED];

			if (empty($fmtTask[TASK_SPEED]) || $fmtTask[TASK_SPEED] != -1) {
				$fmtTask[TASK_TIMELEFT] = ceil($fmtTask[TASK_REMAIN] /$fmtTask[TASK_SPEED]);
			} else {
				$fmtTask[TASK_TIMELEFT] = -1;
			}
			$fmtTask[TASK_FILENAME] = $task['name'];
			$fmtTask[TASK_ORIURL] = $task['oriurl'];

			if ("downloading" == $type) {
				if ("TASK_DOWNLOADING" == $fmtTask[TASK_STATUS]) {
					array_push($taskList, $fmtTask);
				}
			} else {
				array_push($taskList, $fmtTask);
			}
		}
End:
		return $taskList;
	}

	public function addMultiTasksPlugin($dlLinks) {
		foreach ($dlLinks as &$link) {
			$link = escapeshellarg($link);
		}
		$dlLinks = implode(" ", $dlLinks);
		$cmd = $this->COMMAND . " add " . $dlLinks;

		$this -> ExecCmd($cmd, $output, $retCode);
		if (ERR_USER_NOT_LOGIN == $retCode) {
			$this -> RetryIfNotLogin($cmd, $output, $retCode);
		}
		return $retCode;
	}
	public function AddTaskByFilePlugin($filePath, $type) {
		$option = "";
		if ("txt" === $type) {
			$option = "--input=";
		}
		$cmd = $this->COMMAND. " add ". $option .escapeshellarg($filePath);
		$this -> ExecCmd($cmd, $output, $retCode);

		if (ERR_USER_NOT_LOGIN == $retCode) {
			$this -> RetryIfNotLogin($cmd, $output, $retCode);
		}
		return $retCode;
	}

	public function PauseMultiTasksPlugin($taskIds) {
		foreach ($taskIds as &$taskId) {
			$taskId = escapeshellarg($taskId);
		}
		$taskIds = implode(" ", $taskIds);
		$cmd = $this->COMMAND . " pause " . $taskIds;
		$this -> ExecCmd($cmd, $output, $retCode);

		if (ERR_USER_NOT_LOGIN == $retCode) {
			$this -> RetryIfNotLogin($cmd, $output, $retCode);
		}
		return $retCode;
	}

	public function DeleteMultiTasksPlugin($taskIds) {
		foreach ($taskIds as &$taskId) {
			$taskId = escapeshellarg($taskId);
		}
		$taskIds = implode(" ", $taskIds);
		$cmd = $this->COMMAND . " delete " . $taskIds;
		$this -> ExecCmd($cmd, $output, $retCode);

		if (ERR_USER_NOT_LOGIN == $retCode) {
			$this -> RetryIfNotLogin($cmd, $output, $retCode);
		}
		return $retCode;
	}

	public function RestartMultiTasksPlugin($taskIds, $status) {
		foreach ($taskIds as &$taskId) {
			$taskId = escapeshellarg($taskId);
		}
		$taskIds = implode(" ", $taskIds);
		$cmd = $this -> COMMAND;
		if ('deleted' === $status || 'expired' === $status) {
			$cmd = $cmd . " readd --" . $status ." ";
		} else {
			$cmd = $cmd . " restart ";
		}
		$cmd = $cmd .$taskIds;
		$this -> ExecCmd($cmd, $output, $retCode);

		if (ERR_USER_NOT_LOGIN == $retCode) {
			$this -> RetryIfNotLogin($cmd, $output, $retCode);
		}
		return $retCode;
	}

	public function VerifyXunleiLixianAccountPlugin($account, $password) {
		if (file_exists($this->COOKIE)) {
			unlink($this->COOKIE);
		}
		$cmd = $this -> COMMAND.' login '.escapeshellarg($account).' '.escapeshellarg($password);
		$this -> ExecCmd($cmd, $output, $retCode);

		if (ERR_USER_NOT_LOGIN == $retCode) {
			$this -> RetryIfNotLogin($cmd, $output, $retCode);
		}
		return $retCode;
	}
	public function LoginXunleiLixianPlugin() {
		$cmd = $this -> COMMAND.' login '.escapeshellarg($this-> _account).' '.escapeshellarg($this->_password);
		$this -> ExecCmd($cmd, $output, $retCode);

		return $retCode;
	}

	public function GetDownloadURLPlugin($taskIds, &$retData) {
		$taskList = array();
		$item;
		foreach ($taskIds as &$taskId) {
			$taskId = escapeshellarg($taskId);
		}
		$taskIds = implode(" ", $taskIds);
		$cmd = $this -> COMMAND . " list " . " --no-status --download-url " . $taskIds;
		$this -> ExecCmd($cmd, $output, $retCode);
		if(SUCCESS != $retCode) {
			goto End;
		}

		$btTaskIdList = array();
		$downloadURLList = array();
		$jsonOutput = json_decode($output[0], true);
		if (0 == sizeof($jsonOutput)) {
			$retCode = ERR_COMMON;
			goto End;
		}
		foreach ($jsonOutput as $task) {
			$item["downloadurl"] = $task["downloadurl"];
			if ("None" === $item["downloadurl"]) {
				array_push($btTaskIdList, $task["id"]);
				continue;
			}

			$item["filename"] = $task["name"];
			$item["cookiepath"] = $this->COOKIE;
			$item["isSingleFile"] = true;

			array_push($taskList, $item);
		}

		for ($i = 0; $i < sizeof($btTaskIdList); $i++) {
			$retCode = $this->ParseBtTaskDownloadURL($btTaskIdList[$i], $taskList);
			if (SUCCESS != $retCode) {
				goto End;
			}
		}

		$retData = $taskList;
		$retCode = SUCCESS;
End:
		return $retCode;
	}

	private function ParseBtTaskDownloadURL($taskID, &$taskList) {
		$cmd = $this -> COMMAND . " export-download-urls " .escapeshellarg($taskID);
		$retBtTask;
		$btSubTaskArray = array();
		$btSubTask;
		$this -> ExecCmd($cmd, $output, $retCode);

		if(SUCCESS != $retCode) {
			goto End;
		}
		$jsonOutput = json_decode($output[0], true);
		//[downloadurl filename taskname]
		if (0 == sizeof($jsonOutput)) {
			$retCode = ERR_COMMON;
			goto End;
		} else if (1 == sizeof($jsonOutput)) {
			$btTask = $jsonOutput[0];
			$retBtTask["isSingleFile"] = true;
			$retBtTask["filename"] = $btTask[1];
			$retBtTask["downloadurl"] = $btTask[0];
		} else {
			$retBtTask["isSingleFile"] = false;
			foreach ($jsonOutput as $btTask) {
				//echo $btTask["downloadurl"];
				$btSubTask["downloadurl"] = $btTask[0];
				$btSubTask["filename"] = $btTask[1];
				array_push($btSubTaskArray, $btSubTask);
			}
			$retBtTask["subTasks"] = $btSubTaskArray;
		}
		$retBtTask["taskname"] = $jsonOutput[0]["2"];
		$retBtTask["cookiepath"] = $this->COOKIE;

		array_push($taskList, $retBtTask);
End:
		return $retCode;
	}

	public function GetTaskDetailPlugin($Id, $type, &$retData) {
		$cmd = $this->COMMAND . " list ". escapeshellarg($Id) . " --speed --status --size --progress --date --no-colors --original-url";
		if ("downloading" == $type) {
			$cmd = $cmd . " --all";
		} else {
			$cmd = $cmd . " " . escapeshellarg("--".$type);
		}
		$this -> ExecCmd($cmd, $output, $retCode);
		if(SUCCESS != $retCode) {
			goto End;
		}
		if (ERR_USER_NOT_LOGIN == $retCode) {
			$this -> RetryIfNotLogin($cmd, $output, $retCode);
		}

		$retData = $this->ParseTaskOutput($output, NULL);
End:
		return $retCode;
	}

	/* python's error code is 0~127
	 * syno_webapi define error code starts from 400
	 */
	private function ShiftErrCode($errCode) {
		if (SUCCESS == $errCode) {
			return SUCCESS;
		} else {
			return $errCode + ERRCODE_SHIFT_NUM;
		}
	}

	private function ExecCmd($cmd, &$output, &$retCode) {
		exec($cmd, $output, $retCode);
		$retCode = $this -> ShiftErrCode($retCode);
	}

	private function RetryIfNotLogin($cmd, &$output, &$retCode) {
		$loginRetVal = $this->LoginXunleiLixianPlugin();
		if (SUCCESS != $loginRetVal) {
			$output = NULL;
			$retCode = $loginRetVal;
		} else {
			$output = "";
			$this-> ExecCmd($cmd, $output, $retCode);
		}
	}
}

?>
