#!/usr/bin/env python

from lixian_commands.util import *
import lixian_help
import sys

from lixian_commands.login import login
from lixian_commands.logout import logout
from lixian_commands.download import download_task
from lixian_commands.list import list_task
from lixian_commands.add import add_task
from lixian_commands.delete import delete_task
from lixian_commands.pause import pause_task
from lixian_commands.restart import restart_task
from lixian_commands.rename import rename_task
from lixian_commands.readd import readd_task
from lixian_commands.info import lixian_info
from lixian_commands.config import lx_config
from lixian_commands.help import lx_help

def execute_command(args=sys.argv[1:]):
	import lixian_plugins # load plugins at import
	if not args:
		usage()
		sys.exit(1)
	command = args[0]
	if command.startswith('-'):
		if command in ('-h', '--help'):
			usage(lixian_help.welcome_help)
		elif command in ('-v', '--version'):
			print '0.0.x'
		else:
			usage()
			sys.exit(1)
		sys.exit(0)
	import lixian_alias
	command = lixian_alias.to_alias(command)
	commands = {'login': login,
	            'logout': logout,
	            'download': download_task,
	            'list': list_task,
	            'add': add_task,
	            'delete': delete_task,
	            'pause': pause_task,
	            'restart': restart_task,
	            'rename': rename_task,
	            'readd': readd_task,
	            'info': lixian_info,
	            'config': lx_config,
	            'help': lx_help}
	import lixian_plugins.commands
	commands.update(lixian_plugins.commands.commands)
	if command not in commands:
		usage()
		sys.exit(1)
	if '-h' in args or '--help' in args:
		lx_help([command])
	else:
	#SYNO
		try:
			commands[command](args[1:])
		except RuntimeError,e:
			if 'login failed' == e.message:
				print 2
				sys.exit(2)
			elif 'user is not logged in' == e.message:
				print 3
				sys.exit(3)
			elif -1 != e.message.find('Unsupported'):
				print 5
				sys.exit(5)
			elif 'Nothing to delete' == e.message:
				print 6
				sys.exit(6)
			elif 'Invalid response' == e.message:
				print 8
				sys.exit(8)
			elif 'Torrent file is too big' == e.message:
				print 12
				sys.exit(12)
			else:
				print 1
				sys.exit(1)
			raise
		except Exception,e:
			if 'Probably login failed' == e.message:
				print 2
				sys.exit(2)
			elif -1 != e.message.find('not an acceptable ed2k link'):
				print 7
				sys.exit(7)
			elif -1 != e.message.find('Torrent file not found on xunlei cloud'):
				print 9
				sys.exit(9)
			elif -1 != e.message.find('No task found'):
				print 10
				sys.exit(10)
			elif 'No .torrent file found' == e.message:
				print 11
				sys.exit(11)
			elif -1 != e.message.find('File doesn\'t exist'):
				print 13
				sys.exit(13)
			elif -1 != e.message.find('verifycode'):
				print 14
				sys.exit(14)
			elif -1 != e.message.find('Not a vip account'):
				print 15
				sys.exit(15)
			else:
				print 1
				sys.exit(1)
			raise
		except LookupError,e:
			if -1 != e.message.find('Too many results'):
				print 14
				sys.exit(14)
			raise
		sys.exit(0)
	#SYNO END
if __name__ == '__main__':
	execute_command()


