#SYNO
import json
#SYNO END
__all__ = ['parse_login', 'parse_colors', 'parse_logging', 'parse_size', 'create_client', 'output_tasks', 'usage']

from lixian_cli_parser import *
from lixian_config import get_config
from lixian_config import LIXIAN_DEFAULT_COOKIES
from lixian_encoding import default_encoding, to_native
from lixian_colors import colors
from getpass import getpass
import lixian_help
import re
@command_line_value('username', default=get_config('username'))
@command_line_value('password', default=get_config('password'))
@command_line_value('cookies', default=LIXIAN_DEFAULT_COOKIES)
@command_line_value('verification-code-handler', default=get_config('verification-code-handler'))
@command_line_value('verification-code-path', default=get_config('verification-code-path'))
def parse_login(args):
	if args.password == '-':
		args.password = getpass('Password: ')
	if args.cookies == '-':
		args._args['cookies'] = None
	return args

@command_line_option('colors', default=get_config('colors', True))
def parse_colors(args):
	pass

@command_line_value('log-level', default=get_config('log-level'))
@command_line_value('log-path', default=get_config('log-path'))
@command_line_option('debug')
@command_line_option('trace')
def parse_logging(args):
	path = args.log_path
	level = args.log_level
	if args.trace:
		level = 'trace'
	elif args.debug:
		level = 'debug'
	if path or level:
		import lixian_logging
		level = level or 'info'
		lixian_logging.init_logger(use_colors=args.colors, level=level, path=path)
		logger = lixian_logging.get_logger()
		import lixian
		# inject logger to lixian (this makes lixian.py zero-dependency)
		lixian.logger = logger

@command_line_option('size', default=get_config('size'))
@command_line_option('format-size', default=get_config('format-size'))
def parse_size(args):
	pass

def create_client(args):
	from lixian import XunleiClient
	import lixian_verification_code
	verification_code_reader = lixian_verification_code.default_verification_code_reader(args)
	client = XunleiClient(args.username, args.password, args.cookies, verification_code_reader=verification_code_reader)
	if args.page_size:
		client.page_size = int(args.page_size)
	return client


def output_tasks(tasks, columns, args, top=True):
	#SYNO
	taskList=[]
	client = create_client(args)
	for i, t in enumerate(tasks):
		status_colors = {
		'waiting': 'yellow',
		'downloading': 'magenta',
		'completed':'green',
		'pending':'cyan',
		'failed':'red',
		}
		c = status_colors[t['status_text']]
		with colors(args.colors).ansi(c)():
			taskItem={}
			for k in columns:
				if k == 'n':
					if top:
						taskItem['index']=t['#']
						#print '#%d\t' % t['#'],
				elif k == 'id':
					taskItem['id']=t.get('index', t['id'])
					#print '%s\t' % t.get('index', t['id']),
				elif k == 'status':
					taskItem['status']=t['status_text']
					#with colors(args.colors).bold():
						#print '%s\t' % t['status_text'],
				elif k == 'size':
					taskItem['size']=str(t['size'])
					#if args.format_size:
					#	from lixian_util import format_size
						#print '%s\t' % format_size(t['size']),
					#else:
						#print '%s\t' % t['size'],
				elif k == 'progress':
					taskItem['progress']=t['progress']
					#print '%s\t' % t['progress'],
				elif k == 'speed':
					taskItem['speed']=t['speed']
					#print '%s\t' % t['speed'],
				elif k == 'date':
					taskItem['date']=t['date']
					#print '%s\t' % t['date'],
				elif k == 'dcid':
					taskItem['dcid']=t['dcid']
					#print '%s\t' % t['dcid'],
				elif k == 'gcid':
					taskItem['gcid']=t['gcid']
					#print '%s\t' % t['gcid'],
				elif k == 'original-url':
					taskItem['oriurl']=t['original_url']
					#print '%s\t' % t['original_url'],
				elif k == 'download-url':
					taskItem['downloadurl']=switch_node(client, str(t['xunlei_url']), 'vod1')
					#print '%s\t' % t['xunlei_url'],
				elif k == 'name':
					taskItem['name']=t['name'].encode(default_encoding)
					#print '%s\t' % t['name'].encode(default_encoding),
				else:
					raise NotImplementedError(k)
			#print
			taskList.append(taskItem)
	print json.dumps(taskList)
	#SYNO END

def resolve_node_url(client, url):
	import urllib2
	request = urllib2.Request(url, headers={'Cookie': 'gdriveid=' + client.get_gdriveid()})
	response = urllib2.urlopen(request, timeout=60)
	response.close()
	return response.geturl()

def switch_node(client, url, node):
	assert re.match(r'^vod\d+$', node)
	import lixian_logging
	logger = lixian_logging.get_logger()
	logger.debug('Download URL: ' + url)
	try:
		url = resolve_node_url(client, url)
		logger.debug('Resolved URL: ' + url)
	except:
		import traceback
		logger.debug(traceback.format_exc())
		return url
	url = re.sub(r'(http://)(vod\d+)(\.t\d+\.lixian\.vip\.xunlei\.com)', r'\1%s\3' % node, url)
	logger.debug('Switch to node URL: ' + url)
	return url
def usage(doc=lixian_help.usage, message=None):
	if hasattr(doc, '__call__'):
		doc = doc()
	if message:
		print to_native(message)
	print to_native(doc).strip()
