#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOGroupDelete()
#	Usable environment variable:
#		GROUP_NAME_N, GROUP_OP_RESULT_N, NITEMS and RESULT
###############################################################

#Include common scripts
. /var/packages/MailServer/target/scripts/MailServerCommon

#At begining, acquire package settings
PackageInfoGet;

ALIAS_DB="/var/packages/MailServer/etc/alias.db"
ConfigGen="/var/packages/MailServer/target/bin/syno_set_config"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo ${MAIL_SERVER_PKG_NAME};
		;;
	--pkg-ver)
		#Print package version
		echo ${MAIL_SERVER_PKG_VERSION};
		;;
	--vendor)
		#Print package vendor
		echo ${MAIL_SERVER_PKG_VENDOR};
		;;
	--pre)
		#noop
		;;
	--post)

	if [ ! -e $ALIAS_DB ]; then
		exit 1;
	fi

	group_idx=1;
	group_cnt=$(($NITEMS + 1));
	while [ "$group_idx" != "$group_cnt" ]
	do
		eval "group_name=\$GROUP_NAME_$group_idx"
		if [ ! -z $group_name ]; then
			`sqlite3 $ALIAS_DB "DELETE FROM alias_info_table WHERE member='$group_name' and type=1;"`
			if [ 0 != $? ]; then
				logger -p 0 "mailserver: [error]: Fail to delete $group_name from alias db"
			fi
		fi

		group_idx=$(($group_idx + 1));
	done
	$ConfigGen alias
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
