#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOGroupSet()
#	Usable environment variable:
#		ORIGIN_GROUP_NAME, GROUP_NAME, and RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
. /var/packages/MailServer/target/scripts/MailServerCommon

#At begining, acquire package settings
PackageInfoGet;

SYNO_GROUP_SET_ACT="group set"

ALIAS_DB="/var/packages/MailServer/etc/alias.db"
ConfigGen="/var/packages/MailServer/target/bin/syno_set_config"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo ${MAIL_SERVER_PKG_NAME};
		;;
	--pkg-ver)
		#Print package version
		echo ${MAIL_SERVER_PKG_VERSION};
		;;
	--vendor)
		#Print package vendor
		echo ${MAIL_SERVER_PKG_VENDOR};
		;;
	--pre)
		#noop
		;;
	--post)

	if [ ! -e $ALIAS_DB ]; then
		exit 1;
	fi

	eval "org_name=\$ORIGIN_GROUP_NAME"
	eval "new_name=\$GROUP_NAME"

	if [ ! -z $org_name ] && [ "$org_name" != "$new_name" ]; then
		`sqlite3 $ALIAS_DB "UPDATE alias_info_table SET member='$new_name' WHERE member='$org_name' and type=1;"`
	fi

	if [ 0 != $? ]; then
		logger -p 0 "mailserver: [error]: Fail to UPDATE $new_name from alias db"
	fi

	$ConfigGen alias
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
