#!/bin/sh

###############################################################
#   This script should be hooked when invoking user delete
#   Usable environment variable:
#       NITEMS, USER_NAME_X, USER_OP_RESULT_X, RESULT
###############################################################

#Include common scripts
. /var/packages/MailServer/target/scripts/MailServerCommon

#At begining, acquire package settings
PackageInfoGet;

ALIAS_DB="/var/packages/MailServer/etc/alias.db"
ConfigGen="/var/packages/MailServer/target/bin/syno_set_config"
case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo ${MAIL_SERVER_PKG_NAME};
		;;
	--pkg-ver)
		#Print package version
		echo ${MAIL_SERVER_PKG_VERSION};
		;;
	--vendor)
		#Print package vendor
		echo ${MAIL_SERVER_PKG_VENDOR};
		;;
	--pre)
		#noop
		;;
	--post)

	if [ ! -e $ALIAS_DB ]; then
		exit 1;
	fi

	usr_idx=1;
	usr_cnt=$(($NITEMS + 1));
	while [ "$usr_idx" != "$usr_cnt" ]
	do
		eval "usr_name=\$USER_NAME_$usr_idx"

		if [ ! -z $usr_name ]; then
			`sqlite3 $ALIAS_DB "DELETE FROM alias_info_table WHERE member='$usr_name' and type=0;"`
			if [ 0 != $? ]; then
				logger -p 0 "mailserver: [error]: Fail to delete $usr_name from alias db"
			fi
		fi

		usr_idx=$(($usr_idx + 1));
	done
    $ConfigGen alias
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
