#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOUserSet()
#	Usable environment variable:
#		NITEMS, ORIGIN_USER_NAME_{n}, USER_NAME_{n}, UID_{n},
#		USER_OP_RESULT_{n}, RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
. /var/packages/MailServer/target/scripts/MailServerCommon

#At begining, acquire package settings
PackageInfoGet;

SYNO_USER_SET_ACT="user set"

ALIAS_DB="/var/packages/MailServer/etc/alias.db"
ConfigGen="/var/packages/MailServer/target/bin/syno_set_config"
MailServerConf="/var/packages/MailServer/etc/mailserver.conf"
AccountType=`/bin/get_key_value ${MailServerConf} account_type`
: ${AccountType:="local"}

UpdateAlias()
{
	if [ ! -z $org_name ] && [ "$org_name" != "$new_name" ]; then
		valid=`echo $new_name | grep -e "^[a-zA-Z0-9\.\-\_]*$" | wc -l`
		if [ $valid = 1 ]; then
			`sqlite3 $ALIAS_DB "UPDATE alias_info_table SET member='$new_name' WHERE member='$org_name' and type=0;"`
		else
			`sqlite3 $ALIAS_DB "DELETE FROM alias_info_table WHERE member='$org_name' and type=0;"`
		fi
		if [ 0 != $? ]; then
			logger -p 0 "mailserver: [error]: Fail to UPDATE $new_name from alias db"
		fi
	fi
}

UpdateAutoReply()
{
	VACATION="/var/services/homes/$new_name/.vacation.msg"
	if [ ! -z $org_name ] && [ -e ${VACATION} ]; then
		sed s/"From:\"$org_name\""/"From:\"$new_name\""/g ${VACATION} > /tmp/reply.tmp
		mv /tmp/reply.tmp ${VACATION}
	fi
}

UpdateAutoForward()
{
	FORWARD="/var/services/homes/$new_name/.forward"
	orgTmp="\\\\"$org_name
	newTmp="\\\\"$new_name
	if [ ! -z $org_name ] && [ -e ${FORWARD} ]; then
		cat ${FORWARD} | sed s/"$orgTmp"/"$newTmp"/g | sed s/"vacation $org_name"/"vacation $new_name"/g > /tmp/forward.tmp
		mv /tmp/forward.tmp ${FORWARD}
	fi
}


case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo ${MAIL_SERVER_PKG_NAME};
		;;
	--pkg-ver)
		#Print package version
		echo ${MAIL_SERVER_PKG_VERSION};
		;;
	--vendor)
		#Print package vendor
		echo ${MAIL_SERVER_PKG_VENDOR};
		;;
	--pre)
		#noop
		;;
	--post)

	if [ ! -e $ALIAS_DB ]; then
		exit 1;
	fi

	usr_idx=1;
	usr_cnt=$(($NITEMS + 1));
	while [ "$usr_idx" != "$usr_cnt" ]
	do
		eval "org_name=\$ORIGIN_USER_NAME_$usr_idx"
		eval "new_name=\$USER_NAME_$usr_idx"

		UpdateAlias
		UpdateAutoReply
		UpdateAutoForward

		usr_idx=$(($usr_idx + 1));
	done

	#if edit, then regen aliases
	if [ ! -z $org_name ] && [ "$org_name" != "$new_name" ]; then
		$ConfigGen alias
	fi

	#gen new user login map, only if enable restrict sender and account is local
	restrictSender=`/bin/get_key_value ${MailServerConf} restrict_sender`
	if [ x"${restrictSender}" = x"yes" -a x"${AccountType}" = x"local" ]; then
		/var/packages/MailServer/target/bin/syno_gen_login_map
	fi

		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
