#!/bin/sh

. /var/packages/MailServer/target/scripts/MailServerCommon

SDK_MOD_VER="1.0"

generate_cert_trust_chain()
{
	local key="/usr/syno/etc/ssl/ssl.key/server.key"
	local crt="/usr/syno/etc/ssl/ssl.crt/server.crt"
	local ca="/usr/syno/etc/ssl/ssl.intercrt/server-ca.crt"
	local cert_chain="/var/packages/MailServer/target/etc/ssl/mailserver_ssl.pem"

	mkdir -p "/var/packages/MailServer/target/etc/ssl/"

	rm ${cert_chain}

	cat ${key} > ${cert_chain}
	echo -e "\n" >> ${cert_chain}

	cat ${crt} >> ${cert_chain}
	echo -e "\n" >> ${cert_chain}

	if [ -f ${ca} ]; then
		cat ${ca} >> ${cert_chain}
	fi

	chmod 700 ${cert_chain}
}

PackageInfoGet

case $1 in
	--sdk-mod-ver)
		echo ${SDK_MOD_VER};
		;;
	--name)
		#Print package name
		echo ${MAIL_SERVER_PKG_NAME};
		;;
	--vendor)
		#Print package vendor
		echo ${MAIL_SERVER_PKG_VERSION};
		;;
	--pre)
		;;
	--post|--regen)
		generate_cert_trust_chain
		;;
	*)
	;;
esac
