#!/bin/sh
MAILCONF="/var/packages/MailServer/etc/mailserver.conf"
SYNOINFO="/etc/synoinfo.conf"
SPAMLIST="/var/packages/MailServer/etc/spamlist.conf"

DEFAULT_DNSBL="dnsbl.sorbs.net"

if [ -e $MAILCONF ] && [ -e $SPAMLIST ]; then
	exit 1;
fi

if [ ! -e $MAILCONF ]; then
	SmtpEnabled=`/bin/get_key_value $SYNOINFO smtp_enabled`
	Hostname=`/bin/get_key_value $SYNOINFO mailstation_hostname`
	SmtpAuth=`/bin/get_key_value $SYNOINFO smtpd_sasl_auth_enable`
	MessageSizeLimit=`/bin/get_key_value $SYNOINFO message_size_limit`
	SpamfilterEnabled=`/bin/get_key_value $SYNOINFO spamfilter_enabled`

	if [ -z $SmtpEnabled ]; then
		SmtpEnabled="no"
	fi

	if [ -z $SmtpAuth ]; then
		SmtpAuth="yes"
	fi

	if [ -z $MessageSizeLimit ]; then
		MessageSizeLimit="10"
	fi

	if [ -z $SpamfilterEnabled ]; then
		SpamfilterEnabled="no"
	fi

	echo "smtp_enabled=\"$SmtpEnabled\"" > $MAILCONF
	echo "smtp_hostname=\"$Hostname\"" >> $MAILCONF
	echo "smtp_auth_enabled=\"$SmtpAuth\"" >> $MAILCONF
	echo "message_limit=\"$MessageSizeLimit\"" >> $MAILCONF
	#set default
	echo "canonical_domain=\"\"" >> $MAILCONF
	echo "smtp_relay_enabled=\"no\"" >> $MAILCONF
	echo "smtp_relay_server=\"\"" >> $MAILCONF
	echo "smtp_relay_server_port=\"\"" >> $MAILCONF
	echo "smtp_relay_auth_enabled=\"no\"" >> $MAILCONF
	echo "smtp_relay_secure_conn=\"no\"" >> $MAILCONF
	echo "smtp_relay_account=\"\"" >> $MAILCONF
	echo "smtp_relay_password=\"\"" >> $MAILCONF
	echo "spam_enable=\"$SpamfilterEnabled\"" >> $MAILCONF
	echo "spam_greylist_enable=\"no\"" >> $MAILCONF
	echo "spam_dnsbl_enable=\"no\"" >> $MAILCONF

	#protocol
	for key in pop3 pop3s imap imaps; do
		Enabled=`/bin/get_key_value $SYNOINFO ${key}_enabled`
		if [ -z $Enabled ]; then
			Enabled="no"
		fi
		echo "${key}_enabled=\"${Enabled}\"" >> $MAILCONF
	done
fi

if [ ! -e $SPAMLIST ]; then
	echo "[RBL server]" > $SPAMLIST
	echo $DEFAULT_DNSBL >> $SPAMLIST
	echo "[RHSBL server]" >> $SPAMLIST
	echo "[White List]" >> $SPAMLIST
fi
exit 0
