#!/bin/sh
DOVECOT=/var/packages/MailServer/target/sbin/dovecot
dovecot_base=`$DOVECOT -a|grep '^base_dir: '|sed 's/^base_dir: //'`
dovecot_pid=$dovecot_base/master.pid

stop(){
	${DOVECOT} stop
}

start() {

	echo "Starting Dovecot..."
	$DOVECOT
}

case "$1" in
	start)
		start
		;;
	stop)
		stop
		;;
	restart)
		stop
		sleep 1
		start
		;;
	*)
		echo "Usage: $0 {start|stop|restart}" >&2
		exit 1
		;;
esac

exit 0
