#!/bin/sh

MAILSCANNER_PID="/var/run/MailScanner.pid"
MAILSCANNER="/var/packages/MailServer/target/bin/MailScanner/MailScanner"
STARTUP_PID_FILE="/var/run/mailscanner_start.pid"
start()
{
	if [ -f ${STARTUP_PID_FILE} ]; then
		START_PID=`cat ${STARTUP_PID_FILE}`
		START_PROCESS=`cat /proc/${START_PID}/cmdline | grep MailScanner`
		if [ ! -z "${START_PROCESS}" ]; then
			echo "MailScanner is starting"
			exit 0
		fi
	fi

	echo $$ > ${STARTUP_PID_FILE}

	if [ -f ${MAILSCANNER_PID} ]; then
		PID=`cat ${MAILSCANNER_PID}`
		PROCESS=`cat /proc/${PID}/cmdline | grep MailScanner`
	fi

	if [ ! -z "${PROCESS}" ]; then 
		echo "MailScanner is already running"
		exit 0
	fi

	export "PERL5LIB=/var/packages/MailServer/target/lib/perl5/vendor_perl:/var/packages/MailServer/target/lib/perl5/core_perl:/var/packages/MailServer/target/share/perl5/vendor_perl"
	${MAILSCANNER}

	rm ${STARTUP_PID_FILE}
}

restart()
{
	kill -SIGHUP `cat ${MAILSCANNER_PID}`
}

stop()
{
	kill `cat ${MAILSCANNER_PID}`
	rm ${MAILSCANNER_PID}
}

case "$1" in
	start)
		start
		;;
	restart)
		restart
		;;
	stop)
		stop
		;;
esac
