#!/bin/sh

###############################################################
#	This script should be hooked when invoking user delete
#	Usable environment variable:
#		GROUP_NAME_N, GROUP_OP_RESULT_N, NITEMS and RESULT
###############################################################

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		version=`/var/packages/MailServer/target/hook/AliasGroupDelete.sh --sdk-mod-ver`
		echo "$version";
		;;
	--name)
		#Print package name
		name=`/var/packages/MailServer/target/hook/AliasGroupDelete.sh --name`
		echo "${name}";
		;;
	--pkg-ver)
		#Print package version
		pkg_ver=`/var/packages/MailServer/target/hook/AliasGroupDelete.sh --pkg-ver`
		echo "$pkg_ver";
		;;
	--vendor)
		#Print package vendor
		vendor=`/var/packages/MailServer/target/hook/AliasGroupDelete.sh --vendor`
		echo "$vendor";
		;;
	--pre)
		/var/packages/MailServer/target/hook/AliasGroupDelete.sh --pre &
		;;
	--post)
		/var/packages/MailServer/target/hook/AliasGroupDelete.sh --post &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
