#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOGroupSet()
#	Usable environment variable:
#		ORIGIN_GROUP_NAME, GROUP_NAME, and RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################
case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		version=`/var/packages/MailServer/target/hook/AliasGroupUpdate.sh --sdk-mod-ver`
		echo "$version";
		;;
	--name)
		#Print package name
		name=`/var/packages/MailServer/target/hook/AliasGroupUpdate.sh --name`
		echo "$name";
		;;
	--pkg-ver)
		#Print package version
		pkg_ver=`/var/packages/MailServer/target/hook/AliasGroupUpdate.sh --pkg-ver`
		echo "$pkg_ver";
		;;
	--vendor)
		#Print package vendor
		vendor=`/var/packages/MailServer/target/hook/AliasGroupUpdate.sh --vendor`
		echo "$vendor";
		;;
	--pre)
		/var/packages/MailServer/target/hook/AliasGroupUpdate.sh --pre &
		;;
	--post)
		/var/packages/MailServer/target/hook/AliasGroupUpdate.sh --post &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
