#!/bin/sh

###############################################################
#	This script should be hooked when invoking user delete
#	Usable environment variable:
#		NITEMS, USER_NAME_X, USER_OP_RESULT_X, RESULT
###############################################################

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		version=`/var/packages/MailServer/target/hook/AliasUserDelete.sh --sdk-mod-ver`
		echo "$version";
		;;
	--name)
		#Print package name
		name=`/var/packages/MailServer/target/hook/AliasUserDelete.sh --name`
		echo "${name}";
		;;
	--pkg-ver)
		#Print package version
		pkg_ver=`/var/packages/MailServer/target/hook/AliasUserDelete.sh --pkg-ver`
		echo "$pkg_ver";
		;;
	--vendor)
		#Print package vendor
		vendor=`/var/packages/MailServer/target/hook/AliasUserDelete.sh --vendor`
		echo "$vendor";
		;;
	--pre)
		/var/packages/MailServer/target/hook/AliasUserDelete.sh --pre &
		;;
	--post)
		/var/packages/MailServer/target/hook/AliasUserDelete.sh --post &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
