#!/bin/sh
PID_SPAMD=/var/run/spamd.pid
SPAMD=/var/packages/MailServer/target/bin/spamd
SpamEnable=`/bin/get_key_value $MailServerConf spam_enable`

start() 
{
	echo "Starting SPAMD"
	${SPAMD} -d -r ${PID_SPAMD}
}

stop()
{
	if [ -f ${PID_SPAMD} ]; then
		kill `cat ${PID_SPAMD}`
	fi
}

case "$1" in
	start)
		start
		;;
	stop)
		stop
		;;
	restart)
		stop
		sleep 1
		start
		;;
	*)
		echo "Usage: $0 {start|stop|reload}" >&2
		exit 1
		;;
esac

exit 0
