#!/bin/bash
SYNOPKG=/usr/syno/bin/synopkg

replaceString() {
	local text="$1"
	local idx=0
	shift 1
	for val in "$@"; do
		text="${text//\{$idx\}/$val}"
		let idx=1+$idx
	done
	echo "$text"
}

FOUND_DB_TITLE="MariaDB 10-Datenbank wiederherstellen oder erstellen"
DECIDE_RESTORE_DESC="Wählen Sie eine der folgenden Aktionen aus:"
RESTORE_DESC="Vorhandene Datenbank wiederherstellen"
CREATE_NEW_DESC="Neue Datenbank erstellen"
WIZARD_SET_DATA_TITLE="MariaDB 10 einrichten"
DB_NEW_PASSWORD="Neues Passwort"
DB_CONFIRM_PASSWORD="Passwort bestätigen"
PORT="Port"
BAD_PORT=$(replaceString "Die Portnummer muss zwischen {0} und {1} liegen." 1024 65535)

MYSQLDB_ESSENTIAL_TABLE="user db host tables_priv columns_priv func"

ChkDB() {
	local mysqlPath=$1
	for tbl in ${MYSQLDB_ESSENTIAL_TABLE}; do
		if [ ! -f ${mysqlPath}/mysql/${tbl}.frm -o ! -f ${mysqlPath}/mysql/${tbl}.MYI -o ! -f ${mysqlPath}/mysql/${tbl}.MYD ]; then
			return 1
			break;
		fi
	done
	return 0
}

ChkExecEnv() {
	local mysqlSubPath=

	if [ "yes" = "$IS_USBSTATION" ]; then
		mysqlSubPath="@sharebin/@database/mariadb10"
		volRegExp='/volumeUSB[1-9]/usbshare'
	else
		mysqlSubPath="@database/mariadb10"
		volRegExp='/volume[1-9]'
	fi

	for volume in `grep -e " $volRegExp " /proc/mounts | awk '{ print $2 }'`; do
		if [ -d "${volume}/${mysqlSubPath}" ]; then
			return $(ChkDB "${volume}/${mysqlSubPath}")
		fi
	done
	return 1
}

RESTORE_PAGE=$(/bin/cat<<EOF
{
	"step_title": "${FOUND_DB_TITLE}",
	"items": [{
		"type": "singleselect",
		"desc": "${DECIDE_RESTORE_DESC}",
		"subitems": [{
			"desc": "${RESTORE_DESC}",
			"defaultValue": true
		}, {
			"key": "pkgwizard_create",
			"desc": "${CREATE_NEW_DESC}",
			"defaultValue": false
		}]
	}]
}
EOF
)

ALL_NEW_INSTALL_PAGE=$(/bin/cat<<EOF
{
	"step_title": "${WIZARD_SET_DATA_TITLE}",
	"items": [{
		"type": "password",
		"subitems": [{
			"key": "pkgwizard_new_root_password",
			"desc": "${DB_NEW_PASSWORD}",
			"validator": {
				"allowBlank": false
			}
		}, {
			"desc": "${DB_CONFIRM_PASSWORD}",
			"validator": {
				"fn": "{return arguments[0] === document.getElementsByName(\"pkgwizard_new_root_password\")[0].value;}"
			}
		}]
	}, {
		"type": "textfield",
		"subitems": [{
			"key": "pkgwizard_port",
			"desc": "${PORT}",
			"defaultValue": "3307",
			"invalidText": "${BAD_PORT}",
			"validator": {
				"allowBlank": false,
				"fn": "{var port=parseInt(arguments[0], 10); return (1024 <= port && port <= 65535);}"
			}
		}]
	}]
}
EOF
)

main() {
	if ChkExecEnv; then
		echo "[${RESTORE_PAGE}]" >> "${SYNOPKG_TEMP_LOGFILE}"
	else
		echo "[${ALL_NEW_INSTALL_PAGE}]" >> "${SYNOPKG_TEMP_LOGFILE}"
	fi
}
main "$@"
