/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.namespace("SYNO.SDS.MediaServer");Ext.define("SYNO.SDS.MediaServer.DiagnosisDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.module=a.module;this.owner=a.owner;this.ns=SYNO.SDS.MediaServer;this.cgiURL=this.owner.getAbsoluteURL("cgi/mediaserv.cgi");this.panel=this.createPanel();var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={width:500,height:250,title:this.ns._M("button","btn_diagnosis_mediaservice"),layout:"fit",items:this.panel,buttons:[{disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","alt_apply"),btnStyle:"blue",scope:this,handler:this.applySetting},{text:_T("common","alt_cancel"),scope:this,handler:function(){this.close()}}]};Ext.apply(b,a);return b},createPanel:function(){var b={url:this.cgiURL,trackResetOnLoad:true,border:false,listeners:{scope:this,actioncomplete:this.onActionComplete},items:[{xtype:"syno_fieldset",title:this.ns._M("diagnose","debuglog_label"),items:[{xtype:"syno_checkbox",name:"dmslog",boxLabel:this.ns._M("diagnose","debuglog_mediaservice")},{xtype:"syno_compositefield",width:300,hideLabel:true,items:[{disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",xtype:"syno_button",id:this.downloadLogBtnId=Ext.id(),text:this.ns._M("button","btn_debuglog_mediaservice"),scope:this,handler:this.startDownloadLog},{disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",xtype:"syno_button",id:this.clearLogBtnId=Ext.id(),text:_T("log","log_clear"),scope:this,handler:this.startClearLog},{xtype:"syno_displayfield",value:""}]}]}]};SYNO.LayoutConfig.fill(b);var a=new SYNO.ux.FormPanel(b);this.form=a.getForm();return a},load:function(){this.form.load({params:{action:"loadlogconf"}});this.show()},startDownloadLog:function(){var a=Ext.urlAppend(this.cgiURL,"action=downloadlog");var b=document.getElementById("syno-download-frame");if(!b){b=Ext.DomHelper.append(document.body,{tag:"iframe",id:"syno-download-frame",frameBorder:0,width:0,height:0,css:"display: none; visibility: hidden; height: 1px",src:a})}else{b.src=a}},startClearLog:function(){this.setStatusBusy({text:_T("common","saving")});Ext.Ajax.request({url:this.cgiURL,params:{action:"clearlog"},scope:this,callback:function(b,c,a){this.clearStatusBusy();if(c){this.alertMsg(this.ns._M("diagnose","log_is_clear"))}else{this.alertMsg(_T("common","error_system"))}}})},applySetting:function(){var a={action:"applylogconf"};Ext.apply(a,this.form.getValues());if(!this.form.isDirty()){this.close()}this.setStatusBusy({text:_T("common","saving")});Ext.Ajax.request({scope:this,method:"POST",url:this.cgiURL,params:a,callback:function(c,d,b){this.clearStatusBusy();if(!d){this.alertMsg(_T("common","error_system"))}else{this.close()}}})},onActionComplete:function(a,b){this.clearStatusBusy();if(b.type==="apply"){if(!b.success){this.alertMsg(_T("common","commfail"))}else{this.close()}}},alertMsg:function(a){this.getMsgBox().alert(_T("tree","leaf_mediaservice"),a)}});Ext.namespace("SYNO.SDS.MediaServer");Ext.apply(SYNO.SDS.MediaServer,{_M:function(b,a){return _TT("SYNO.SDS.MediaServer.AppInstance",b,a)},TemplateText:{custom1:_TT("SYNO.SDS.MediaServer.AppInstance","menu","menu_custom"),custom2:_TT("SYNO.SDS.MediaServer.AppInstance","menu","menu_custom_2"),custom3:_TT("SYNO.SDS.MediaServer.AppInstance","menu","menu_custom_3")},TabTitle:{music:_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_music"),photo:_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_photos"),video:_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_video")},CategoryText:{album:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_album"),album_index:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_album_index"),artist:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_artist"),artist_index:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_artist_index"),albumartist:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_albumartist"),albumartist_index:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_albumartist_index"),composer:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_composer"),composer_index:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_composer_index"),genre:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_genre"),year:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_year"),month:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_month"),yearmon:_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonth"),yearmonday:_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonday"),timetaken:_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_photo_timetaken"),timetaken_year:_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_year_timetaken"),timetaken_yearmon:_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonth_timetaken")},getActualChildNodes:function(c){var b=[];for(var a=0;a<c.length;a++){if("#text"==c[a].nodeName||3==c[a].nodeType){continue}b.push(c[a])}return b},encodeXMLSpecialChar:function(a){var b=Ext.util.Format.htmlEncode(a);b=b.replace(/'/g,"&apos;");return b},getDomFirstNode:function(c,a){var b=a.getElementsByTagName(c);if(b.length===0){return null}return b[0]},getDomFirstNodeValue:function(e,b,a){var c=SYNO.SDS.MediaServer.getDomFirstNode(e,b);var d;if(!c){d=null}else{if(!c.firstChild){d=""}else{d=c.firstChild.nodeValue}}return((d===null||d===undefined)?a:d)},formErrinfoString:function(c,a){var d=Ext.isString(a)?a:"";if(c&&c.success!==true&&c.errinfo){var b=c.errinfo;d=_T(b.sec,b.key);if(d===""){d=String.format("{0}:{1}",b.sec,b.key)}if(Ext.isNumber(b.line)){d=String.format("{0} ({1})",d,b.line)}}return d},reportAjaxResponse:function(g,b,a,d){var f="";var e=null;if(!g){f=_T("common","commfail")}else{if(Ext.isString(b.responseText)){try{e=Ext.decode(b.responseText)}catch(c){SYNO.Debug("exception: responseText:",b.responseText);f="Unknown exception"}}f=this.formErrinfoString(e,f)}if(f&&a){d=d||this;a.call(d,f)}return e},clearInvalidOnDisabled:function(a){a.items.each(function(d,b,c){if(d.isFormField&&d.clearInvalid){d.mon(d,"disable",d.clearInvalid,d)}})},getMediaIndexedPageLink:function(){if(SYNO.SDS.isNSM){return String.format('<a href="#" onclick="{0}">{1}</a>',"SYNO.SDS.AppLaunch('SYNO.SDS.NSMUSBStorage.Instance', {fn: 'SYNO.SDS.NSMUSBStorage.MediaIndex.Main'});",_T("tree","leaf_media_library"))}return String.format('<a href="#" onclick="{0}">{1}</a>',"SYNO.SDS.AppLaunch('SYNO.SDS.AdminCenter.Application', {fn: 'SYNO.SDS.AdminCenter.MediaIndex.Main'});",_T("tree","leaf_media_library"))}});Ext.namespace("SYNO.SDS.MediaServer");Ext.define("SYNO.SDS.MediaServer.FolderTreeDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.module=a.module;this.owner=a.owner;this.mediaType=a.mediaType;this.ns=SYNO.SDS.MediaServer;this.cgiURL=this.owner.getAbsoluteURL("cgi/file_share.cgi");this.panel=this.createPanel();var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={title:this.ns._M("foldertree","select_folder"),width:500,height:500,layout:"fit",items:this.panel,tbar:{id:this.tbarId=Ext.id(),items:[{xtype:"syno_button",text:_T("common","refresh"),scope:this,handler:this.reloadTree}]},buttons:[{text:_T("common","alt_apply"),btnStyle:"blue",scope:this,handler:this.saveSelection},{text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};Ext.apply(b,a);return b},createPanel:function(){var b={loader:{dataUrl:this.cgiURL,baseParams:{action:"getshares",media:this.mediaType}},autoScroll:true,animate:false,useArrows:true,trackMouseOver:false,border:false,root:{text:String.format('<span style="font-weight:bold;">{0}</span>',_S("hostname")),draggable:false,expanded:true,allowDrop:false,id:"fm_root",cls:"syno-mediaserver-no-icon"},listeners:{scope:this,beforeload:function(){this.setStatusBusy()},load:function(c){this.blVisibleNode=this.hasVisibleNode(c);if("fm_root"===c.id&&!this.blVisibleNode){Ext.getCmp(this.tbarId).setDisabled(true);this.panel.el.mask(this.ns._M("customize","prompt_no_indexed_folder").replace("__INDEX__",this.ns.getMediaIndexedPageLink()),"syno-ux-mask-info")}this.clearStatusBusy()}}};var a=new SYNO.ux.TreePanel(b);return a},hasVisibleNode:function(c){var a=false;for(var b=0;b<c.childNodes.length;b++){if(false===c.childNodes[b].hidden){a=true;break}}return a},reloadTree:function(){this.panel.getRootNode().reload()},saveSelection:function(){if(!this.blVisibleNode){this.close();return}var b=this.panel.getSelectionModel();var a=b.getSelectedNode();if(a&&a.id){this.fdrName=a.id}else{this.getMsgBox().alert(this.title,this.ns._M("foldertree","select_one"));return}this.close()},resetDialog:function(){this.fdrName=null},load:function(){this.resetDialog();var a=this.panel.getSelectionModel();a.clearSelections();this.show()},getParameters:function(){var a={};a.fdrName=this.fdrName;return a},onCancel:function(){this.close()}});Ext.namespace("SYNO.SDS.MediaServer");SYNO.SDS.MediaServer.TreeDropZone=Ext.extend(Ext.tree.TreeDropZone,{onNodeOver:function(b,d,a,c){return this.dropAllowed},onNodeDrop:function(a,o,n,v){var r=0;var k=a.node;var l=k.getDepth()-1;var m={node:this.tree.root,next:null};var p=m;var q=this.tree.root;var u=null;var t=null;var j=this.scope;if(v.node){if(-1==l){return false}var g=v.node;var b=g.getDepth()-1;if(l==b){return false}u=null;var e=null;t=null;var h=null;var s=null;for(r=0;1==q.childNodes.length;r++,q=q.childNodes[0]){u=j.createCategoryTreeNode(q.childNodes[0].id);p.next={node:u,next:null};if(r==b){e=p.next;h=p}else{if(r==l){t=p.next;s=p}}p=p.next}if(b>l){h.next=e.next;s.next=e;e.next=t}else{if(l>b){h.next=e.next;e.next=t.next;t.next=e}}if(!(j.checkInvalidCategoryCombine(m))){return false}}else{if(v.selections){if(1!=v.selections.length){return false}var f=v.selections[0].get("category");var d=j.createCategoryTreeNode(f);u=null;t=null;for(r=0;1==q.childNodes.length;r++,q=q.childNodes[0]){u=j.createCategoryTreeNode(q.childNodes[0].id);p.next={node:u,next:null};if(r==l){t=p.next}p=p.next}if(-1==l){t=m}var w={node:d,next:t.next};t.next=w;if(!(j.checkInvalidCategoryCombine(m))){return false}j.delCategoryFromGrid(d.id);var c=j.gridStore.getSortState();j.gridStore.sort(c.field,c.direction)}else{return false}}j.rebuildUITree(this.tree,m);j.rebuildDOMTree(m);return true}});Ext.define("SYNO.SDS.MediaServer.MenuEditDialog",{extend:"SYNO.SDS.ModalWindow",defaultLabelWidth:100,oCategoryData:{music:[["album",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_album")],["album_index",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_album_index")],["artist",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_artist")],["artist_index",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_artist_index")],["albumartist",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_albumartist")],["albumartist_index",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_albumartist_index")],["composer",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_composer")],["composer_index",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_composer_index")],["genre",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_music_genre")],["year",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_year")],["yearmon",_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonth")],["yearmonday",_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonday")]],photo:[["year",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_year")],["month",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_month")],["yearmon",_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonth")],["yearmonday",_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonday")],["timetaken",_TT("SYNO.SDS.MediaServer.AppInstance","customize","category_photo_timetaken")],["timetaken_year",_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_year_timetaken")],["timetaken_yearmon",_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonth_timetaken")]],video:[["yearmon",_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonth")],["yearmonday",_TT("SYNO.SDS.MediaServer.AppInstance","customize","class_yearmonday")]]},oCategory:{music:["album","album_index","artist","artist_index","albumartist","albumartist_index","composer","composer_index","genre","year","yearmon","yearmonday"],photo:["year","month","yearmon","yearmonday"],video:["yearmon","yearmonday"]},constructor:function(a){this.module=a.module;this.owner=a.owner;this.ns=SYNO.SDS.MediaServer;this.cgiURL=this.owner.getAbsoluteURL("cgi/mediaserv.cgi");this.panel=this.createPanel();var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={width:600,height:560,minWidth:300,minHeight:250,title:_T("common","alt_edit"),layout:"fit",items:this.panel,buttons:[{text:_T("common","alt_apply"),btnStyle:"blue",scope:this,handler:this.applySetting},{text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};Ext.apply(b,a);return b},createNameAndTypeConfig:function(){var a={xtype:"syno_fieldset",itemId:"nametype",fieldWidth:250,title:this.ns._M("customize","generic_setting"),labelWidth:this.defaultLabelWidth,synodefaults:{width:235},items:[{xtype:"syno_textfield",name:"ruletitle",fieldLabel:_T("common","name"),maxlength:255,allowBlank:false},{xtype:"syno_combobox",id:this.ruleTypeComboId=Ext.id(),name:"ruletype",fieldLabel:this.ns._M("customize","type"),store:[[0,0]],listeners:{scope:this,select:this.onComboSelect}},{xtype:"syno_displayfield",name:"pldesc",hidden:true,value:this.ns._M("customize","playlist_desc")}]};return a},createRecentTakeConfig:function(){var a={xtype:"syno_fieldset",itemId:"recenttake",title:this.ns._M("customize","rule_setting"),labelWidth:this.defaultLabelWidth,items:[{xtype:"syno_numberfield",name:"recenttakeday",fieldLabel:this.ns._M("customize","recent_day"),minValue:1,maxValue:365,width:50}]};return a},createRecentAddConfig:function(){var a={xtype:"syno_fieldset",itemId:"recentadd",title:this.ns._M("customize","rule_setting"),labelWidth:this.defaultLabelWidth,items:[{xtype:"syno_numberfield",name:"recentaddday",fieldLabel:this.ns._M("customize","recent_day"),minValue:1,maxValue:365,width:50}]};return a},createRootPathConfig:function(){var a={xtype:"syno_fieldset",itemId:"storage",title:this.ns._M("customize","root_directory_setting"),hideMode:"display",labelWidth:this.defaultLabelWidth,items:[{xtype:"syno_radio",checked:true,name:"folder_selector",id:this.allIndexFolderId=Ext.id(),boxLabel:this.ns._M("customize","apply_to_all_indexed_folder"),scope:this,handler:function(c,b){if(true===b){this.form.findField("folderpath").setValue("/")}else{this.form.findField("folderpath").setValue(this.origShownPath)}}},{xtype:"syno_radio",name:"folder_selector",id:this.altIndexFolderId=Ext.id(),boxLabel:this.ns._M("customize","root_directory_path")},{xtype:"syno_compositefield",hideLabel:true,indent:1,items:[{xtype:"syno_textfield",width:300,readOnly:true,name:"folderpath"},{xtype:"syno_button",id:this.editPathBtnId=Ext.id(),text:this.ns._M("customize","change_root_path"),scope:this,handler:this.editPathBtnHandler}]}]};return a},createCategoryConfig:function(){this.gridStore=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:[{name:"category",mapping:0},{name:"display",mapping:1}],sortInfo:{field:"category",direction:"ASC"}});this.rootNode=new Ext.tree.TreeNode({text:this.ns._M("customize","menu_level"),id:"category_root",draggable:false});var a={xtype:"syno_panel",itemId:"categoryedit",layout:"border",border:false,height:180,items:[{region:"west",split:true,collapsible:false,width:250,minSize:100,maxSize:400,xtype:"syno_treepanel",itemId:"tree",cls:"x-tree-noicon",useArrows:true,animate:false,enableDD:true,ddGroup:"catDD",tbar:{style:"padding-left: 4px; padding-top: 4px; padding-bottom: 4px; border-bottom-width: 0px;",items:[{xtype:"syno_button",text:this.ns._M("customize","category_up"),scope:this,handler:this.MoveUpCategory},{xtype:"syno_button",text:this.ns._M("customize","category_down"),scope:this,handler:this.MoveDownCategory}]},root:this.rootNode,selModel:new Ext.tree.DefaultSelectionModel({listeners:{scope:this,beforeselect:this.onTreeBeforeSelect}}),listeners:{scope:this,afterrender:this.onTreePanelAfterRender,beforecollapsenode:function(c,b,d){if(c.id==="category_root"&&c.childNodes.length===0){return true}return false}}},{region:"center",xtype:"syno_gridpanel",itemId:"grid",columns:[{id:"category",header:this.ns._M("customize","category_type"),dataIndex:"display",sortable:true}],store:this.gridStore,enableHdMenu:false,enableDragDrop:true,ddGroup:"catDD",listeners:{scope:this,afterrender:this.onGridPanelAfterRender}}]};return a},createPanel:function(){var b={url:this.cgiURL,trackResetOnLoad:true,border:false,listeners:{scope:this,actioncomplete:this.onActionComplete},items:[this.createNameAndTypeConfig(),this.createRecentTakeConfig(),this.createRecentAddConfig(),this.createRootPathConfig(),this.createCategoryConfig()]};SYNO.LayoutConfig.fill(b);var a=new SYNO.ux.FormPanel(b);this.form=a.getForm();this.tree=a.getComponent("categoryedit").getComponent("tree");a.mon(a,"afterlayout",function(c,d){var e=new SYNO.SDS.Utils.EnableCheckGroup(c.getForm(),"folder_selector","",[this.editPathBtnId,"folderpath"])},this,{single:true});return a},load:function(b){this.leafEntryNode=b.leafEntryNode;this.entryRoot=b.entryRoot;this.menuConfig=b.menuConfig;this.mediaType=b.mediaType;this.template=b.template;this.categoryRoot=null;this.ruleType=null;this.dmsLangText=b.text;this.blSaveMenu=false;this.origCatList=[];this.ruleTypeStore=Ext.getCmp(this.ruleTypeComboId).getStore();this.ruleTypeStore.loadData(this.getRuleTypeData(this.mediaType));this.setNameTypeUI();var a=this.leafEntryNode.getAttribute("x_type")||this.leafEntryNode.getAttribute("type");this.showRuleUI(a,true);this.show()},getRuleTypeData:function(a){switch(a){case"music":return[["category",this.ns._M("customize","rule_categoryfolder")],["index_storagefolder",this.ns._M("customize","by_allfolders")],["storage",this.ns._M("customize","rule_storagefolder")],["smartplaylist",this.ns._M("customize","class_smart_playlist")],["playlist",this.ns._M("customize","class_music_playlist")],["recentadd",this.ns._M("customize","class_recent_added")],["radio",this.ns._M("customize","class_internet_radio")]];case"photo":return[["category",this.ns._M("customize","rule_categoryfolder")],["index_storagefolder",this.ns._M("customize","by_allfolders")],["storage",this.ns._M("customize","rule_storagefolder")],["recentadd",this.ns._M("customize","class_recent_added")],["recenttake",this.ns._M("customize","class_recent_taken")]];case"video":return[["category",this.ns._M("customize","rule_categoryfolder")],["index_storagefolder",this.ns._M("customize","by_allfolders")],["storage",this.ns._M("customize","rule_storagefolder")],["recentadd",this.ns._M("customize","class_recent_added")]];default:return[]}},setNameTypeUI:function(){var c=this.ns.getDomFirstNodeValue("title",this.leafEntryNode,null);if(!Ext.isString(c)){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}var a=c.replace(/{(\w+)}/,"$1");c=this.dmsLangText.mediaservice[a]||c;var b=this.leafEntryNode.getAttribute("x_type")||this.leafEntryNode.getAttribute("type");if("categoryfolder"==b){b="category"}else{if("storagefolder"==b){b="storage"}}this.ruleType=b;this.form.setValues({ruletitle:c,ruletype:b})},showRuleUI:function(b,c){var a=this.form.findField("pldesc");if("smartplaylist"==b){a.setValue(this.ns._M("customize","smart_playlist_desc"));a.show()}else{if("playlist"==b){a.setValue(this.ns._M("customize","playlist_desc"));a.show()}else{a.hide()}}this.form.clearInvalid();if("category"===b||"categoryfolder"===b){this.setSize(600,560);this.setDisplay("categoryedit");this.setCategoryFolderUI();if(c){this.storeOriginalCategoryList()}this.setRootPathUI()}else{if("recenttake"===b||"recentadd"===b){this.setSize(600,337);this.setDisplay(b);this.setRecentTakeAddUI(b);this.form.clearInvalid()}else{if("storage"===b||"storagefolder"===b){this.setSize(600,350);this.setRootPathUI();this.setDisplay("storage")}else{this.setSize(600,270);this.setDisplay()}}}},setDisplay:function(d){var a=["categoryedit","recenttake","recentadd","storage"];Ext.each(a,function(h,f,g){var e=this.panel.getComponent(h);if(e){e.hide()}},this);var b=this.panel.getComponent(d);if(!b){return}b.show();if(d==="storage"){Ext.getCmp(this.allIndexFolderId).hide()}if(d==="categoryedit"){var c=this.panel.getComponent("storage");if(c){c.show()}Ext.getCmp(this.allIndexFolderId).show()}},setCategoryFolderUI:function(){this.gridStore.loadData(this.oCategoryData[this.mediaType]);var c=this.leafEntryNode.getElementsByTagName("categories");if(this.rootNode.childNodes.length===1){this.rootNode.removeChild(this.rootNode.childNodes[0])}var b=this.rootNode;if(c.length===1){this.categoryRoot=c[0];var d=this.ns.getActualChildNodes(c[0].childNodes);var f=null;var a=null;var e=null;Ext.each(d,function(i,g,h){e=i.childNodes[0].nodeValue;if(i.getAttribute("index")==="1"){e+="_index"}f=this.gridStore.getById(e);if(f){this.gridStore.remove(f)}a=this.createCategoryTreeNode(e);b.appendChild(a);b=a},this);this.rootNode.expand()}},setRecentTakeAddUI:function(b){var a=this.leafEntryNode.getAttribute("x_day");if(b==="recenttake"){this.form.setValues({recenttakeday:a})}else{if(b==="recentadd"){this.form.setValues({recentaddday:a})}else{return}}},setRootPathUI:function(){var c=this.ns.getDomFirstNodeValue("directory",this.leafEntryNode,null);if(!Ext.isString(c)){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}var a=this.leafEntryNode.getAttribute("media");Ext.getCmp(this.allIndexFolderId).setValue(false);Ext.getCmp(this.altIndexFolderId).setValue(true);var b="";if(c===":@AllIndexFiles@"){b+="/";Ext.getCmp(this.allIndexFolderId).setValue(true);Ext.getCmp(this.altIndexFolderId).setValue(false)}else{if(c[0]===":"){b+="/"+c.substring(1)}else{if(c[0]==="/"){b+=c}else{b+="/"+a+"/"+c}}}this.form.findField("folderpath").setValue(b);this.origShownPath=b},storeOriginalCategoryList:function(){this.origCatList=[];var a=this.leafEntryNode.getElementsByTagName("categories");if(a.length===1){var b=this.ns.getActualChildNodes(a[0].childNodes);Ext.each(b,function(e,c,d){var f=e.childNodes[0].nodeValue;if(e.getAttribute("index")==="1"){f+="_index"}this.origCatList.push(f)},this)}},setRecentTakeAddDOM:function(c){var b=null;if("recenttake"===c){b=this.form.findField("recenttakeday").getValue()}else{if("recentadd"===c){b=this.form.findField("recentaddday").getValue()}else{return}}var a=this.leafEntryNode.getElementsByTagName("rulelist");if(1!==a.length){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}var d=a[0].getElementsByTagName("rule");if(1!==d.length){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}if("recenttake"===c){d[0].childNodes[0].nodeValue="now()-timetaken < interval '"+b+" day'"}else{if("recentadd"===c){d[0].childNodes[0].nodeValue="now()-date < interval '"+b+" day'"}else{return}}this.leafEntryNode.setAttribute("x_day",b)},setRootPathDOM:function(){var c=this.form.findField("folderpath").getValue();var b=this.leafEntryNode.getElementsByTagName("directory");if(1!=b.length){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}var a="";if("/"===c){a+=":@AllIndexFiles@"}else{if("/"===c[0]&&-1===c.indexOf("/",1)){a+=":"+c.substring(1)}else{a+=c}}b[0].childNodes[0].nodeValue=a},isSaveMenu:function(){return this.blSaveMenu},isDirtyByItemId:function(c){var a=this.panel.getComponent(c);if(!a){throw"invalid itemId: "+c}var b=false;a.items.each(function(f,d,e){if(Ext.isFunction(f.isDirty)&&f.isDirty()){b=true;return false}},this);return b},isValidByItemId:function(c){var a=this.panel.getComponent(c);if(!a){throw"invalid itemId: "+c}var b=true;a.items.each(function(f,d,e){if(Ext.isFunction(f.isValid)&&!f.isValid()){b=false;return false}},this);return b},isCategoryListChanged:function(){var c=this.leafEntryNode.getElementsByTagName("categories");if(0===c.length){if(0===this.origCatList.length){return false}else{return true}}if(1!==c.length){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return false}var d=this.ns.getActualChildNodes(c[0].childNodes);if(d.length!=this.origCatList.length){return true}var b=0;var e=null;var a=null;for(b=0;b<d.length;b++){e=d[b].childNodes[0].nodeValue;if("1"===d[b].getAttribute("index")){e+="_index"}a=this.origCatList[b];if(a!==e){return true}}return false},applySetting:function(){if(!this.isValidByItemId("nametype")){this.msgAlert(_T("common","forminvalid"));return}var b=false;if(this.isDirtyByItemId("nametype")){b=true}var c=this.leafEntryNode.getElementsByTagName("title");if(c.length!==1){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}var a=this.form.findField("ruletitle");if(a.isDirty()){var f=a.getValue();var e=Ext.util.Format.trim(f);if(!e){this.msgAlert(this.ns._M("error","error_empty_rule_name"));return}c[0].childNodes[0].nodeValue=f}var d=this.leafEntryNode.getAttribute("x_type")||this.leafEntryNode.getAttribute("type");if(d==="recenttake"||d==="recentadd"){if(!this.isValidByItemId(d)){this.msgAlert(_T("common","forminvalid"));return}if(!b&&!this.isValidByItemId(d)){this.close();return}this.setRecentTakeAddDOM(d)}else{if(d==="storagefolder"||d==="categoryfolder"){if(!b&&(this.origShownPath===this.form.findField("folderpath").getValue())){if(d==="storagefolder"||!this.isCategoryListChanged()){this.close();return}}if(d==="storagefolder"&&this.isRootPath()){this.msgAlert(_T("common","forminvalid"));return}this.setRootPathDOM()}else{if(!b){this.close();return}}}this.blSaveMenu=true;this.close()},isRootPath:function(){var a=this.form.findField("folderpath").getValue();if("/"===a){return true}return false},onCancel:function(){var a=false;if(this.isDirtyByItemId("nametype")){a=true}else{var b=this.leafEntryNode.getAttribute("x_type")||this.leafEntryNode.getAttribute("type");if("recenttake"==b&&this.isDirtyByItemId(b)){a=true}else{if("recentadd"==b&&this.isDirtyByItemId(b)){a=true}else{if("storagefolder"==b||"categoryfolder"==b){if((this.origShownPath!=this.form.findField("folderpath").getValue())||("categoryfolder"==b&&this.isCategoryListChanged())){a=true}}}}}if(a){this.getMsgBox().confirm(_T("tree","leaf_mediaservice"),_T("common","confirm_lostchange"),function(c){if(c=="yes"){this.close()}},this);return}this.close()},onActionComplete:function(a,b){this.clearStatusBusy();if(b.type==="apply"){if(!b.success){this.msgAlert(_T("common","commfail"))}else{this.close()}}},onComboSelect:function(c,a,b){var d=c.getValue();if(this.ruleType===d){return}else{this.ruleType=d}this.changeRulyTypeDOM(d);this.showRuleUI(d)},changeRulyTypeDOM:function(a){this.leafEntryNode.removeAttribute("x_type");this.leafEntryNode.removeAttribute("x_day");var h=null;h=this.leafEntryNode.getElementsByTagName("directory");if(1===h.length){this.leafEntryNode.removeChild(h[0])}h=this.leafEntryNode.getElementsByTagName("categories");if(1===h.length){this.leafEntryNode.removeChild(h[0])}this.categoryRoot=null;h=this.leafEntryNode.getElementsByTagName("conjunction");if(1===h.length){this.leafEntryNode.removeChild(h[0])}h=this.leafEntryNode.getElementsByTagName("rulelist");if(1===h.length){this.leafEntryNode.removeChild(h[0])}var c=this.leafEntryNode.ownerDocument;var d=null;var i=null;if("category"==a||"storage"==a){var g=a+"folder";this.leafEntryNode.setAttribute("type",g);var f=":"+this.mediaType;d=c.createElement("directory");d.appendChild(c.createTextNode(f));this.leafEntryNode.appendChild(d)}else{if("recenttake"==a||"recentadd"==a){this.leafEntryNode.setAttribute("type","smartct");this.leafEntryNode.setAttribute("x_type",a);d=c.createElement("conjunction");d.appendChild(c.createTextNode("AND"));this.leafEntryNode.appendChild(d);d=c.createElement("rulelist");this.leafEntryNode.appendChild(d);i=c.createElement("rule");i.appendChild(c.createTextNode(""));d.appendChild(i);if("music"==this.mediaType&&"recentadd"==a){var e=c.createElement("categories");var b=c.createElement("category");b.appendChild(c.createTextNode("album"));e.appendChild(b);this.leafEntryNode.appendChild(e)}}else{if("smartplaylist"==a){this.leafEntryNode.setAttribute("type","smartplaylist")}else{if("playlist"==a){this.leafEntryNode.setAttribute("type","playlist")}else{if("radio"==a){this.leafEntryNode.setAttribute("type","radio")}else{if("index_storagefolder"==a){this.leafEntryNode.setAttribute("type","index_storagefolder")}}}}}}},editPathBtnHandler:function(c,a){var b=new SYNO.SDS.MediaServer.FolderTreeDialog({owner:this.owner,module:this.module,mediaType:"menu_folder@"+this.mediaType});b.mon(b,"close",function(){var d=b.getParameters();if(d.fdrName){if("fm_root"===d.fdrName){d.fdrName="/"}this.form.findField("folderpath").setValue(d.fdrName)}},this);b.load()},onTreePanelAfterRender:function(a){var b=new SYNO.SDS.MediaServer.TreeDropZone(a,{ddGroup:"catDD",scope:this})},onTreeBeforeSelect:function(c,a,b){if(a.id==="category_root"){return false}return true},onGridPanelAfterRender:function(a){var b=new Ext.dd.DropTarget(a.getView().mainBody,{ddGroup:"catDD",scope:this,notifyDrop:function(n,m,j){if(j.selections){return false}if(j.node&&false===j.node.draggable){return false}var l=this.scope;var c={node:n.tree.root,next:null};var k=c;var f=n.tree.root;var e=null;var g=j.node.getDepth()-1;var h=0;var p=null;for(h=0;1==f.childNodes.length;h++,f=f.childNodes[0]){if(h==g){l.addCategoryToGrid(f.childNodes[0].id);p=l.gridStore.getSortState();l.gridStore.sort(p.field,p.direction);continue}e=l.createCategoryTreeNode(f.childNodes[0].id);k.next={node:e,next:null};k=k.next}l.rebuildUITree(n.tree,c);var o=l.ns.getActualChildNodes(l.categoryRoot.childNodes);var d=null;for(h=0;h<o.length;h++){d=o[h].childNodes[0].nodeValue;if("1"===o[h].getAttribute("index")){d+="_index"}if(j.node.id==d){l.categoryRoot.removeChild(o[h])}}if(null===c.next){l.removeCategoryRoot()}return true}})},MoveCategory:function(l){if(l!=="up"&&l!=="down"){return}var c=this.tree.getSelectionModel();var j=c.getSelectedNode();if(!j){this.msgAlert(this.ns._M("foldertree","select_one"));return}if(this.tree.root===j){return}var k=j.parentNode;if((l==="up"&&this.tree.root===k)||(l==="down"&&j.childNodes.length===0)){return}var f=j.getDepth()-1;var m=null;if("up"===l){m=f-1}else{m=f+1}var a={node:this.tree.root,next:null};var h=a;var d=this.tree.root;var p=null;var e=null;var o=null;var n=null;var b=null;var g;for(g=0;1==d.childNodes.length;g++,d=d.childNodes[0]){b=this.createCategoryTreeNode(d.childNodes[0].id);h.next={node:b,next:null};if(g==f){p=h.next;o=h}else{if(g==m){e=h.next;n=h}}h=h.next}if(f>m){o.next=p.next;n.next=p;p.next=e}else{if(m>f){o.next=p.next;p.next=e.next;e.next=p}}if(!(this.checkInvalidCategoryCombine(a))){return}this.rebuildUITree(this.tree,a);c.select(p.node);this.rebuildDOMTree(a)},MoveUpCategory:function(){this.MoveCategory("up")},MoveDownCategory:function(){this.MoveCategory("down")},checkInvalidCategoryCombine:function(b){var d=b;var e={};for(var c=0;c<this.oCategory[this.mediaType].length;c++){e[this.oCategory[this.mediaType][c]]=false}var f=0;var a=0;while(null!==d.next){d=d.next;if(true===e[d.node.id]){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}if("year"===d.node.id||"yearmon"===d.node.id||"yearmonday"===d.node.id){f++;if(1<f){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}}if("month"===d.node.id||"yearmon"===d.node.id||"yearmonday"===d.node.id){a++;if(1<a){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}}if("year"==d.node.id&&true===e.month){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}if("timetaken_yearmon"==d.node.id&&(true===e.timetaken)){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}if("timetaken_year"==d.node.id&&(true===e.timetaken||true===e.timetaken_yearmon)){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}e[d.node.id]=true}if(true===e.album&&true===e.album_index){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}if(true===e.artist&&true===e.artist_index){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}if(true===e.albumartist&&true===e.albumartist_index){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}if(true===e.composer&&true===e.composer_index){this.msgAlert(this.ns._M("customize","illegal_category_combination"));return false}return true},rebuildUITree:function(b,a){if(1===b.root.childNodes.length){b.root.removeChild(b.root.childNodes[0])}var c=b.root;var d=a;while(null!==d.next){d=d.next;c.appendChild(d.node);c=d.node}b.root.expand()},rebuildDOMTree:function(c){if(null!==c.next){this.createCategoryRoot()}var g=this.ns.getActualChildNodes(this.categoryRoot.childNodes);for(var e=0;e<g.length;e++){this.categoryRoot.removeChild(g[e])}var f=c;var b=this.leafEntryNode.ownerDocument;var d=null;var a=-1;while(null!==f.next){f=f.next;d=b.createElement("category");a=f.node.id.indexOf("_index");if(-1!=a){d.appendChild(b.createTextNode(f.node.id.substring(0,a)));d.setAttribute("index","1")}else{d.appendChild(b.createTextNode(f.node.id))}this.categoryRoot.appendChild(d)}},createCategoryRoot:function(){if(!this.categoryRoot){var a=this.leafEntryNode.ownerDocument;var b=a.createElement("categories");this.leafEntryNode.appendChild(b);this.categoryRoot=b}},removeCategoryRoot:function(){if(this.categoryRoot){this.leafEntryNode.removeChild(this.categoryRoot);this.categoryRoot=null}},createCategoryTreeNode:function(a){return new Ext.tree.TreeNode({id:a,text:this.ns.CategoryText[a],draggable:true,expanded:true,expandable:false})},addCategoryToGrid:function(a){if(-1==this.gridStore.indexOfId(a)){this.gridStore.add(new Ext.data.Record({category:a,display:this.ns.CategoryText[a]},a))}},delCategoryFromGrid:function(b){var a=this.gridStore.getById(b);if(a){this.gridStore.remove(a)}},msgAlert:function(a){this.getMsgBox().alert(_T("tree","leaf_mediaservice"),a)}});Ext.namespace("SYNO.SDS.MediaServer");Ext.define("SYNO.SDS.MediaServer.MenuEnumDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.module=a.module;this.owner=a.owner;this.ns=SYNO.SDS.MediaServer;this.cgiURL=this.owner.getAbsoluteURL("cgi/mediaserv.cgi");this.gridArray={};this.storeArray={};this.mediaEntryArr={};this.entryRootArr={};this.createTab("music");this.createTab("photo");this.createTab("video");this.tabPanel=this.createTabPanel();var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={width:600,height:530,minWidth:300,minHeight:250,title:"",layout:"fit",items:this.tabPanel,buttons:[{disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","alt_apply"),btnStyle:"blue",scope:this,handler:this.applySetting},{text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};Ext.apply(b,a);return b},createTabPanel:function(){var a={plain:true,activeTab:0,scope:this,listeners:{beforetabchange:this.BeforeTabChange.createDelegate(this),tabChange:this.TabChange.createDelegate(this)},items:[this.gridArray.music,this.gridArray.photo,this.gridArray.video]};var b=new SYNO.ux.TabPanel(a);return b},BeforeTabChange:function(a,c,b){this.initTab=false;if(!b){this.initTab=true}},TabChange:function(b,c){if(this.initTab){return}var a=(0<c.getStore().getCount())?false:true;this.maskGridPanelBody(c,a)},createTab:function(a){var b=new Ext.data.ArrayStore({fields:["title","node"]});this.storeArray[a]=b;var c=new Ext.grid.ColumnModel([{id:"title",header:_T("common","name"),width:160,dataIndex:"title",renderer:Ext.util.Format.htmlEncode}]);var d=new SYNO.ux.GridPanel({title:this.ns.TabTitle[a],itemId:a,store:b,colModel:c,stripeRows:true,autoExpandColumn:"title",enableColumnMove:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:false,enableDragDrop:true,ddGroup:"GridDD",tbar:{items:[{xtype:"syno_button",text:_T("common","create"),tooltip:this.ns._M("customize","tip_new_rule"),scope:this,itemId:"createButton",handler:this.onBtnNewClick},{xtype:"syno_button",text:_T("common","alt_edit"),tooltip:this.ns._M("customize","tip_edit_rule"),scope:this,handler:this.onBtnEditClick},{xtype:"syno_button",text:_T("common","delete"),tooltip:this.ns._M("customize","tip_delete_rule"),scope:this,handler:this.onBtnDeleteClick},{xtype:"syno_button",text:this.ns._M("customize","category_up"),tooltip:this.ns._M("customize","category_up"),scope:this,handler:this.onBtnUpClick},{xtype:"syno_button",text:this.ns._M("customize","category_down"),tooltip:this.ns._M("customize","category_down"),scope:this,handler:this.onBtnDownClick}]},selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),listeners:{scope:this,celldblclick:this.onCellDblClick,afterrender:this.onGridAfterRender}});this.gridArray[a]=d},load:function(b,c,a){this.menuChanged=false;this.menuConfig=null;this.template=b;this.active=c;this.storeArray.music.removeAll();this.storeArray.photo.removeAll();this.storeArray.video.removeAll();this.setTitle(this.ns.TemplateText[b]);this.setStatusBusy({text:_T("common","loading")});if(!this.dmsLang||this.dmsLang!=a){this.dmsLang=a;this.AjaxRequest({action:"getdmslangtext",lang:this.dmsLang},this.onGetDmsLangText)}else{this.AjaxRequest({action:"loadmenu",template:this.template},this.onLoadMenuConfig)}this.show()},encodeTagContent:function(c){var a=this.menuConfig.getElementsByTagName(c);if(0<a.length){var d=null;for(var b=0;b<a.length;b++){d=a[b].childNodes[0].nodeValue;d=this.ns.encodeXMLSpecialChar(d);a[b].childNodes[0].nodeValue=d}}},onCancel:function(){if(this.menuChanged){this.getMsgBox().confirm(_T("tree","leaf_service"),_T("common","confirm_lostchange"),function(a){if(a==="yes"){this.close()}},this);return}this.close()},applySetting:function(){if(!this.menuChanged){this.close();return}this.encodeTagContent("rule");this.encodeTagContent("title");this.encodeTagContent("directory");var a=this.serializeXML(this.menuConfig).replace(/&amp;/g,"&");if(Ext.isIE){a=a.replace(/\r\n/g,"\n")}if(Ext.isSafari){if(-1!=navigator.userAgent.search(/[Vv][Ee][Rr][Ss][Ii][Oo][Nn]\/[0-5]/)){a='<?xml version="1.0" encoding="UTF-8"?>\n'+a}}this.setStatusBusy({text:_T("common","saving")});this.AjaxRequest({action:"savemenu",content:a,template:this.template,restartserver:this.active},this.onApplySetting)},onApplySetting:function(b,c,a){this.clearStatusBusy();if(!c){this.msgAlert(_T("common","commfail"))}this.close()},onGetDmsLangText:function(b,d,a){var c=this.ns.reportAjaxResponse(d,a);if(!c||!c.success||!c.text){this.clearStatusBusy();this.msgAlert(_T("common","commfail"));return}this.dmsLangText=c.text;this.AjaxRequest({action:"loadmenu",template:this.template},this.onLoadMenuConfig)},onLoadMenuConfig:function(b,c,a){this.clearStatusBusy();if(c&&a.responseXML){this.setUIData(a.responseXML)}else{this.msgAlert(_T("common","commfail"))}},setUIData:function(d){this.menuConfig=d;var c=this.menuConfig.getElementsByTagName("menu");if(1!=c.length){this.menuConfig=null;this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}var b=this.ns.getActualChildNodes(c[0].childNodes);if(1!=b.length){this.menuConfig=null;this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}var e=this.ns.getActualChildNodes(b[0].childNodes);if(3!=e.length){this.menuConfig=null;this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}var a={music:true,photo:true,video:true};Ext.each(e,function(h,f,g){var i=h.getAttribute("x_media");if(a[i]){this.mediaEntryArr[i]=h}},this);Ext.iterate(this.mediaEntryArr,function(g,h,i){this.storeArray[g].removeAll();var f;f=this.getElementsByTagNameFromChild(h,"entrylist");if(f.length!==1){this.showNoMenuMessage(this.gridArray[g],true);return true}this.showNoMenuMessage(this.gridArray[g],false);this.entryRootArr[g]=f[0]},this);Ext.iterate(this.entryRootArr,function(g,i,j){var h=[];var f=Ext.query("entry",i);f=this.ns.getActualChildNodes(i.childNodes);Ext.each(f,function(p,n,o){var k;var q=this.ns.getDomFirstNodeValue("title",p,null);if(!Ext.isString(q)){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return false}var m=q.replace(/{(\w+)}/,"$1");var l=this.dmsLangText.mediaservice[m];k=new Ext.data.Record({title:l||q,node:p});h.push(k)},this);this.storeArray[g].add(h)},this)},showNoMenuMessage:function(b,a){this.maskGridPanelBody(b,a)},maskGridPanelBody:function(b,a){if(b.body){if(a){b.body.mask(this.ns._M("customize","no_rule_desc"),"syno-ux-mask-info");b.getTopToolbar().setDisabled(true);b.getTopToolbar().getComponent("createButton").setDisabled(false)}else{b.body.unmask();b.getTopToolbar().setDisabled(false)}}},getElementsByTagNameFromChild:function(e,b){var a=[];var c=e.childNodes;for(var d=0;d<c.length;d++){if(c[d].nodeName===b){a.push(c[d])}}return a},serializeXML:function(a){if(typeof XMLSerializer!=="undefined"){try{return(new XMLSerializer()).serializeToString(a)}catch(b){return a.xml||null}}else{if(a.xml){return a.xml}else{return null}}},AjaxRequest:function(c,b){if(!Ext.isObject(c)){return}var a=Ext.Ajax.request({url:this.cgiURL,params:c,method:"POST",scope:this,callback:b});return a},onCellDblClick:function(d,f,c,b){var a=d.itemId;var e=d.getStore().getAt(f);this.saveOldMenuConfig();this.launchMenuEditDialog(a,e.get("node"),_T("common","alt_edit"))},onGridAfterRender:function(a){var b=new Ext.dd.DropTarget(a.getView().mainBody,{ddGroup:"GridDD",copy:false,scope:this,notifyDrop:function(c,k,g){var i=this.scope;var f=c.getDragData(k);var h=f.rowIndex;if(!Ext.isDefined(h)){return}var l=g.selections[0];var j=a.getStore();j.remove(l);j.insert(h,[l]);var e=i.entryRootArr[a.itemId];var d=l.get("node");e.removeChild(d);if(h+1<j.getCount()){var m=j.getAt(h+1).get("node");e.insertBefore(d,m)}else{e.appendChild(d)}i.menuChanged=true}})},onBtnNewClick:function(c,k){if(!this.menuConfig){return}this.saveOldMenuConfig();var a=c.findParentByType("grid");var l=a.itemId;var j=this.storeArray[l];var g=this.mediaEntryArr[l];var d=this.entryRootArr[l];var b=g.ownerDocument;var e=null;if(j.getCount()===0){var i=g.getElementsByTagName("directory");if(i.length===1){g.removeChild(i[0])}g.removeAttribute("media");g.removeAttribute("type");e=b.createElement("entrylist");g.appendChild(e);d=e}e=b.createElement("entry");e.setAttribute("media",l);e.setAttribute("type","categoryfolder");var h=b.createElement("title");h.appendChild(b.createTextNode(""));e.appendChild(h);var f=b.createElement("directory");f.appendChild(b.createTextNode(":"+l));e.appendChild(f);d.appendChild(e);this.launchMenuEditDialog(l,e,_T("common","create"))},onBtnEditClick:function(b,a){var c=this.getSelectedRecordObj(b);if(!c){return}this.saveOldMenuConfig();this.launchMenuEditDialog(c.mediaType,c.rec.get("node"),_T("common","alt_edit"))},onBtnDeleteClick:function(e,b){var g=this.getSelectedRecordObj(e);if(!g){return}var h=g.rec;var a=g.mediaType;var d=g.grid;var c=this.storeArray[a];this.entryRootArr[a].removeChild(h.get("node"));c.remove(h);if(c.getCount()===0){var f=this.mediaEntryArr[a];f.removeChild(this.entryRootArr[a]);f.setAttribute("media",a);f.setAttribute("type","index_storagefolder");this.entryRootArr[a]=null;this.showNoMenuMessage(d,true)}this.menuChanged=true},onBtnUpClick:function(b,j){var f=this.getSelectedRecordObj(b);if(!f){return}var k=f.mediaType;var a=f.grid;var i=this.storeArray[k];var e=f.rec;var g=i.indexOf(e);if(g===0){return}var c=e.get("node");i.remove(e);var d=this.entryRootArr[k];d.removeChild(c);i.insert(g-1,[e]);var h=i.getAt(g).get("node");d.insertBefore(c,h);a.getSelectionModel().selectRecords([e]);this.menuChanged=true},onBtnDownClick:function(b,j){var f=this.getSelectedRecordObj(b);if(!f){return}var k=f.mediaType;var a=f.grid;var i=this.storeArray[k];var e=f.rec;var g=i.indexOf(e);if(g===i.getCount()-1){return}var c=e.get("node");i.remove(e);var d=this.entryRootArr[k];d.removeChild(c);i.insert(g+1,[e]);var h=i.getAt(g).get("node");if(d.lastChild===h){d.appendChild(c)}else{d.insertBefore(c,h.nextSibling)}a.getSelectionModel().selectRecords([e]);this.menuChanged=true},getSelectedRecordObj:function(b){if(!this.menuConfig){return false}var a=b.findParentByType("grid");var d=a.getSelectionModel();if(!d.hasSelection()){this.msgAlert(this.ns._M("foldertree","select_one"));return false}var c={rec:d.getSelected(),grid:a,mediaType:a.itemId};return c},getCurrentMediaType:function(b){var a=b.findParentByType("grid");return a.itemId},saveOldMenuConfig:function(){var a=this.menuConfig.getElementsByTagName("menu");if(a.length!==1){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}this.oldMenuDOM=a[0].cloneNode(true)},restoreOldMenuConfig:function(){var a=this.menuConfig.getElementsByTagName("menu");if(a.length!==1){this.msgAlert(this.ns._M("error","error_illegal_config_format"));return}this.menuConfig.replaceChild(this.oldMenuDOM,a[0])},launchMenuEditDialog:function(a,c,d){var b=new SYNO.SDS.MediaServer.MenuEditDialog({owner:this.owner,module:this.module,title:d});b.mon(b,"close",function(){var e=b.isSaveMenu();if(e){this.menuChanged=true}else{this.restoreOldMenuConfig()}this.setUIData(this.menuConfig)},this);b.load({mediaType:a,leafEntryNode:c,entryRoot:this.entryRootArr[a],menuConfig:this.menuConfig,template:this.template,text:this.dmsLangText})},msgAlert:function(a){this.getMsgBox().alert(_T("tree","leaf_mediaservice"),a)}});Ext.namespace("SYNO.SDS.MediaServer");Ext.define("SYNO.SDS.MediaServer.DMAListDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.module=a.module;this.owner=a.owner;this.ns=SYNO.SDS.MediaServer;this.url=a.url;this.grid=this.createDMAListTabObj();var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={width:800,height:500,title:this.ns._M("button","btn_devicelist"),layout:"fit",items:[this.grid],buttons:[{text:_T("common","close"),scope:this,handler:function(){this.onCancelClick()}}],listeners:{beforeshow:function(){this.LoadClientList();this.LoadProfileList()},scope:this}};Ext.apply(b,a);return b},onCancelClick:function(){var a=this.clientListStore.getModifiedRecords().length;if(a!==0){this.getMsgBox().confirm(_T("controlpanel","leaf_mediaservice"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.close()}},this)}else{this.close()}},createDMAListTabObj:function(){this.clientListStore=new Ext.data.JsonStore({root:"ClientList",fields:["isAccess","macAddr","ipAddr","displayName","profileName"]});this.profileStore=new Ext.data.JsonStore({root:"ProfileList",fields:["profileName"]});this.profileStore.sort("profileName");var b=new Ext.grid.RowSelectionModel({single:false});var c=new SYNO.ux.EnableColumn({header:this.ns._M("devicelist","enable"),width:35,align:"center",sortable:true,dataIndex:"isAccess"});var d={id:this.clientListTabId=Ext.id(),itemId:"clientlist",store:this.clientListStore,clicksToEdit:1,enableHdMenu:false,plugins:c,selModle:b,columns:[c,{header:this.ns._M("devicelist","mac_addr"),dataIndex:"macAddr",width:60,sortable:true},{header:_T("common","ip_addr"),dataIndex:"ipAddr",width:50,sortable:true},{header:this.ns._M("devicelist","device"),dataIndex:"displayName",sortable:true,renderer:function(i,f,e,j,h,g){return'<div ext:qtip="'+Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(i))+'">'+Ext.util.Format.htmlEncode(i)+"</div>"}},{header:this.ns._M("devicelist","profile"),dataIndex:"profileName",sortable:true,width:80,renderer:function(i,f,e,j,h,g){return'<div ext:qtip="'+i+'">'+i+"</div>"},editor:new Ext.grid.GridEditor(new SYNO.ux.ComboBox({store:this.profileStore,mode:"local",displayField:"profileName",triggerAction:"all",editable:false,lazyRender:true,tpl:'<tpl for="."><div ext:qtip="{profileName}" class="x-combo-list-item">{profileName}</div></tpl>'}))}],tbar:{items:[{xtype:"syno_button",text:_T("common","refresh"),scope:this,handler:this.onRefreshClick},{xtype:"syno_button",text:_T("common","save"),disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onSaveClick},{xtype:"syno_button",text:_T("common","reset"),disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onClearClick}]}};var a=new SYNO.ux.EditorGridPanel(d);return a},onClearClick:function(){this.getMsgBox().confirm(_T("controlpanel","leaf_mediaservice"),_T("iscsitrg","iscsitrg_lun_delete_warning"),function(a){if(a==="yes"){this.clearMsg()}},this)},clearMsg:function(){this.setStatusBusy({text:_T("group","deleting_group")});Ext.Ajax.request({scope:this,method:"POST",url:this.url,params:{action:"clearClientList"},callback:function(e,f,b){if(f){var a=Ext.decode(b.responseText);if(a.success===false){this.getMsgBox().alert(_T("controlpanel","leaf_mediaservice"),this.ns._M("error","error_devicelist_reset_failed"));this.clearStatusBusy();return}var d=a.ClientList.length;var c;for(c=0;c<d;c++){if(a.ClientList[c].displayName==="General DMA"){a.ClientList[c].displayName=this.ns._M("devicelist","general_upnp_dlna_device")}if(a.ClientList[c].profileName==="Default Profile"){a.ClientList[c].profileName=this.ns._M("devicelist","default_profile")}else{if(a.ClientList[c].profileName==="General DLNA"){a.ClientList[c].profileName=this.ns._M("devicelist","general_dlna")}else{if(a.ClientList[c].profileName==="General Non-DLNA"){a.ClientList[c].profileName=this.ns._M("devicelist","general_non_dlna")}}}}this.clientListStore.loadData(a);this.clearStatusBusy();this.setStatusOK({text:_T("common","setting_applied")})}}})},onRefreshClick:function(){var a=this.clientListStore.getModifiedRecords().length;if(a!==0){this.getMsgBox().confirm(_T("controlpanel","leaf_mediaservice"),_T("common","confirm_refresh"),function(b){if(b==="yes"){this.LoadClientList()}},this)}else{this.LoadClientList()}},onSaveClick:function(){var b=this.clientListStore.getModifiedRecords();var d=[];var a;for(a=0;a<b.length;a++){var c={};c.macAddr=b[a].data.macAddr;if(b[a].data.profileName===this.ns._M("devicelist","default_profile")){c.profileName="Default Profile"}else{if(b[a].data.profileName===this.ns._M("devicelist","general_dlna")){c.profileName="General DLNA"}else{if(b[a].data.profileName===this.ns._M("devicelist","general_non_dlna")){c.profileName="General Non-DLNA"}else{c.profileName=b[a].data.profileName}}}c.isAccess=b[a].data.isAccess;d.push(c)}if(b.length>0){this.setStatusBusy({text:_T("common","saving")});Ext.Ajax.request({scope:this,method:"POST",url:this.url,params:{action:"saveClientList",modifiedInfo:Ext.encode(d)},callback:function(f,h,e){this.clearStatusBusy();if(h){var g=Ext.decode(e.responseText);if(g.success===false){this.getMsgBox().alert(_T("controlpanel","leaf_mediaservice"),this.ns._M("error","error_devicelist_save_failed"));this.LoadClientList();return}this.clientListStore.commitChanges();this.setStatusOK({text:_T("common","setting_applied")})}}})}},LoadClientList:function(){this.setStatusBusy();this.addAjaxTask({single:true,method:"POST",url:this.url,scope:this,params:{action:"loadClientList"},callback:function(f,g,b){this.clientListStore.commitChanges();if(g){var a=b.responseText;var d=Ext.decode(a);if(d.success===false){this.getMsgBox().alert(_T("controlpanel","leaf_mediaservice"),_T("common","loadres_fail"));this.clearStatusBusy();return}var e=d.ClientList.length;var c;for(c=0;c<e;c++){if(d.ClientList[c].displayName==="General DMA"){d.ClientList[c].displayName=this.ns._M("devicelist","general_upnp_dlna_device")}if(d.ClientList[c].profileName==="Default Profile"){d.ClientList[c].profileName=this.ns._M("devicelist","default_profile")}else{if(d.ClientList[c].profileName==="General DLNA"){d.ClientList[c].profileName=this.ns._M("devicelist","general_dlna")}else{if(d.ClientList[c].profileName==="General Non-DLNA"){d.ClientList[c].profileName=this.ns._M("devicelist","general_non_dlna")}}}}this.clientListStore.loadData(d);this.clearStatusBusy()}}}).start()},LoadProfileList:function(){this.setStatusBusy();this.addAjaxTask({single:true,method:"POST",url:this.url,scope:this,params:{action:"loadProfileList"},callback:function(f,g,b){if(g){var e=b.responseText;var a=Ext.decode(e);if(a.success===false){this.getMsgBox().alert(_T("controlpanel","leaf_mediaservice"),_T("common","loadres_fail"));this.clearStatusBusy();return}var d=a.ProfileList.length;var c;for(c=0;c<d;c++){if(a.ProfileList[c].profileName==="Default Profile"){a.ProfileList[c].profileName=this.ns._M("devicelist","default_profile")}else{if(a.ProfileList[c].profileName==="General DLNA"){a.ProfileList[c].profileName=this.ns._M("devicelist","general_dlna")}else{if(a.ProfileList[c].profileName==="General Non-DLNA"){a.ProfileList[c].profileName=this.ns._M("devicelist","general_non_dlna")}}}}this.profileStore.loadData(a);this.clearStatusBusy()}}}).start()}});Ext.namespace("SYNO.SDS.MediaServer");Ext.define("SYNO.SDS.MediaServer.GeneralPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(a){this.ns=SYNO.SDS.MediaServer;this.owner=a.appWin;this.module=a.module;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={xtype:"syno_formpanel",itemId:"main",trackResetOnLoad:true,hideMode:"offsets",labelWidth:280,fieldWidth:250,buttons:[{xtype:"syno_button",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","commit"),btnStyle:"blue",scope:this,handler:this.onApply},{xtype:"syno_button",text:_T("common","reset"),scope:this,handler:this.onCancel}],items:[{xtype:"syno_fieldset",title:this.ns._M("customize","generic_setting"),items:[{xtype:"syno_displayfield",value:this.ns._M("main","service_desc_mediaservice2").replace("__INDEX__",this.ns.getMediaIndexedPageLink())},{xtype:"syno_combobox",name:"dmsInterface",fieldLabel:this.ns._M("main","network_mediaservice"),editable:false,store:[[0,0]]},{xtype:"syno_combobox",name:"language",fieldLabel:this.ns._M("main","language_mediaservice"),editable:false,store:SYNO.SDS.Utils.getSupportedLanguage(0)},{synotype:"indent",xtype:"syno_compositefield",fieldLabel:this.ns._M("menu","menu_default"),width:400,items:[{xtype:"syno_combobox",name:"templatetype",width:250,editable:false,store:[[SYNO.SDS.MediaServer.TEMPLATE_SIMPLE,this.ns._M("menu","menu_simple")],[SYNO.SDS.MediaServer.TEMPLATE_IPOD,this.ns._M("menu","menu_ipod")],[SYNO.SDS.MediaServer.TEMPLATE_ADVANCE,this.ns._M("menu","menu_advance")],[SYNO.SDS.MediaServer.TEMPLATE_CUSTOM,this.ns._M("menu","menu_custom")],[SYNO.SDS.MediaServer.TEMPLATE_CUSTOM2,this.ns._M("menu","menu_custom_2")],[SYNO.SDS.MediaServer.TEMPLATE_CUSTOM3,this.ns._M("menu","menu_custom_3")]],listeners:{scope:this,select:function(f,c,d){var e=Ext.getCmp(this.customizeMenuBtnId);if(this.isCustomizedMenu(f)){e.enable();return true}e.disable();return false},enable:function(d){var c=Ext.getCmp(this.customizeMenuBtnId);if(this.isCustomizedMenu(d)){c.enable()}else{c.disable()}},disable:function(d){var c=Ext.getCmp(this.customizeMenuBtnId);c.disable()}}},{xtype:"syno_button",disabled:true,text:this.ns._M("button","btn_customize_menu"),id:this.customizeMenuBtnId=Ext.id(),scope:this,handler:this.onCustomizeMenuBtnClick}]},{xtype:"syno_numberfield",fieldLabel:this.ns._M("main","ssdp_advr_interval"),name:"ssdp_advr",minValue:5,maxValue:86400,maxlength:5,emptyText:"920",allowBlank:false},{xtype:"syno_displayfield",value:String.format('<span class="syno-ux-note">{0}: </span>{1}',_T("common","note"),this.ns._M("main","ssdp_advr_desc"))},{xtype:"syno_displayfield",height:20},{xtype:"syno_button",width:"auto",id:this.diagnosisBtnId=Ext.id(),text:this.ns._M("button","btn_diagnosis_mediaservice"),scope:this,handler:this.launchDiagnosisDialog}]}]};Ext.apply(b,a);return b},onPageActivate:function(){this.loadForm()},loadForm:function(){this.setStatusBusy({text:_T("common","loading")});this.owner.addAjaxTask({params:{action:"load_general_page"},single:true,autoJsonDecode:true,url:this.owner.getAbsoluteURL("cgi/mediaserv.cgi"),method:"POST",scope:this,success:function(a,b){this.clearStatusBusy();if(a.success&&a.data){this.OriSetting=a.data;this.getForm().setValues(this.OriSetting);this.displaySet()}else{this.owner.getMsgBox().alert(this.title,_T("common","error_system"))}},failure:function(a,b){this.clearStatusBusy();this.owner.getMsgBox().alert(this.title,_T("common","error_system"))}}).start()},displaySet:function(){var b=this.getForm();if(this.isCustomizedMenu(b.findField("templatetype"))){Ext.getCmp(this.customizeMenuBtnId).enable()}var c=[];var a=b.findField("dmsInterface");if(!this.OriSetting.network){SYNO.SDS.Utils.DisplayField(b,"dmsInterface",false)}else{this.OriSetting.network.sort(function(e,d){if(e.value>d.value){return 1}else{return -1}});Ext.each(this.OriSetting.network,function(f,d,e){c.push([f.value,f.display])},this);a.getStore().loadData(c);a.setValue(this.OriSetting.dmsInterface);SYNO.SDS.Utils.DisplayField(b,"dmsInterface",true)}if(this.OriSetting.network_total===1){SYNO.SDS.Utils.DisplayField(b,"dmsInterface",false)}},checkDirty:function(){if(this.getForm().isDirty()){return true}return false},onApply:function(){if(!this.checkDirty()){this.setStatusError({text:_T("error","nochange_subject"),clear:true});return}if(!this.getForm().isValid()){this.setStatusError({text:_T("common","forminvalid"),clear:true});return}this.applyForm()},applyForm:function(){this.setStatusBusy({text:_T("common","saving")});var a=this.getForm();var b={action:"save_general_page"};Ext.apply(b,a.getValues());this.TmpSetting=a.getValues();this.owner.addAjaxTask({single:true,autoJsonDecode:true,url:this.owner.getAbsoluteURL("cgi/mediaserv.cgi"),params:b,method:"POST",scope:this,success:function(c,d){this.clearStatusBusy();if(c.success){this.setStatusOK();this.OriSetting=this.TmpSetting;this.getForm().setValues(this.OriSetting)}else{this.owner.getMsgBox().alert(this.title,_T("error","error_unknown"))}},failure:function(c,d){this.clearStatusBusy();this.owner.getMsgBox().alert(this.title,_T("error","error_unknown"))}}).start()},onCancel:function(){this.getForm().setValues(this.OriSetting)},onCustomizeMenuBtnClick:function(b,a){this.launchMenuDialog()},launchMenuDialog:function(){var c=this.getForm();if(this.isCustomizedMenu(c.findField("templatetype"))){var d=c.findField("templatetype");var b=d.getValue();var e=c.findField("language").getValue();var a=new SYNO.SDS.MediaServer.MenuEnumDialog({owner:this.owner,module:this.module});a.load(b,!d.isDirty(),e)}},isCustomizedMenu:function(a){var b=a.getValue();if(b===this.ns.TEMPLATE_CUSTOM||b===this.ns.TEMPLATE_CUSTOM2||b===this.ns.TEMPLATE_CUSTOM3){return true}return false},launchDiagnosisDialog:function(){var a=new SYNO.SDS.MediaServer.DiagnosisDialog({owner:this.owner,module:this.module});a.load()}});Ext.namespace("SYNO.SDS.MediaServer");Ext.define("SYNO.SDS.MediaServer.CollectionDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.module=a.module;this.owner=a.owner;this.url=a.url;this.ns=SYNO.SDS.MediaServer;this.grid=this.createCollectionGridPanel();var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={width:550,height:300,title:this.ns._M("collection","video_station_collection"),layout:"fit",items:[this.grid],buttons:[{text:_T("common","commit"),btnStyle:"blue",scope:this,handler:function(){this.onApplyClick()}},{text:_T("common","cancel"),scope:this,handler:function(){this.onCancelClick()}}],listeners:{beforeshow:function(){this.loadCollection()},scope:this}};Ext.apply(b,a);return b},loadCollection:function(){this.setStatusBusy();Ext.Ajax.request({method:"POST",url:this.url,scope:this,params:{action:"loadCollection"},callback:function(d,e,a){var c=Ext.decode(a.responseText);if(!e||!c.success){this.getMsgBox().alert(_T("controlpanel","leaf_mediaservice"),_T("common","loadres_fail"));this.clearStatusBusy();return}for(var b=0;b<c.data.collections.length;b++){if("syno_favorite"===c.data.collections[b].title){c.data.collections[b].title=this.ns._M("collection","favorite")}else{if("syno_watchlist"===c.data.collections[b].title){c.data.collections[b].title=this.ns._M("collection","watchlist")}}}this.collectionStore.loadData(c.data);this.clearStatusBusy()}})},onApplyClick:function(){var a=new Array();this.collectionStore.each(function(b){if(true===b.data.exposed){a.push(b.data.id)}},this);if(0===this.collectionStore.getModifiedRecords().length){this.setStatusError({text:_T("error","nochange_subject"),clear:true});return}this.setStatusBusy({text:_T("common","saving")});Ext.Ajax.request({scope:this,method:"POST",url:this.url,params:{action:"saveCollection",exposed_collections:Ext.encode(a)},callback:function(d,e,b){this.clearStatusBusy();var c=Ext.decode(b.responseText);if(!e||!c.success){this.getMsgBox().alert(_T("controlpanel","leaf_mediaservice"),_T("error","save"));this.loadCollection();return}this.collectionStore.commitChanges();this.setStatusOK({text:_T("common","setting_applied")});this.close()}})},onCancelClick:function(){var a=this.collectionStore.getModifiedRecords().length;if(0===a){this.close();return}this.getMsgBox().confirm(_T("controlpanel","leaf_mediaservice"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.close();return}},this)},createCollectionGridPanel:function(){this.collectionStore=new Ext.data.JsonStore({root:"collections",fields:["id","exposed","title"]});var b=new SYNO.ux.EnableColumn({header:this.ns._M("devicelist","enable"),width:35,align:"center",sortable:true,dataIndex:"exposed"});var c={store:this.collectionStore,selModel:new Ext.grid.RowSelectionModel({single:false}),enableHdMenu:false,plugins:b,columns:[b,{header:this.ns._M("collection","title"),flex:1,align:"center",sortable:true,dataIndex:"title",renderer:function(f,g,d){var e='<div ext:qtip="'+f+'">'+f+"</div>";return e}}]};var a=new SYNO.ux.GridPanel(c);return a}});Ext.namespace("SYNO.SDS.MediaServer");Ext.define("SYNO.SDS.MediaServer.BrowsingPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(a){this.ns=SYNO.SDS.MediaServer;this.owner=a.appWin;this.module=a.module;var b=this.fillConfig(a);this.callParent([b])},initEvents:function(){this.callParent(arguments);this.mon(this,"afterrender",function(a){var b;b=new SYNO.SDS.Utils.EnableCheckGroup(a.getForm(),"cmzalbumart",["albumartlist"])},this)},fillConfig:function(a){var b={xtype:"syno_formpanel",id:this.browseTabId=Ext.id(),itemId:"browse",trackResetOnLoad:true,hideMode:"offsets",fieldWidth:320,labelWidth:249,buttons:[{xtype:"syno_button",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","commit"),btnStyle:"blue",scope:this,handler:this.onApply},{xtype:"syno_button",text:_T("common","reset"),scope:this,handler:this.onCancel}],items:[{xtype:"syno_fieldset",title:this.ns._M("browsing","sendthumb_label"),items:[{xtype:"syno_combobox",name:"musicdisplayinfo",fieldLabel:this.ns._M("browsing","musicinfo_mediaservice"),store:[[SYNO.SDS.MediaServer.MUSICINFO_TITLE,this.ns._M("browsing","musicinfo_title")],[SYNO.SDS.MediaServer.MUSICINFO_TRACKTITLE,this.ns._M("browsing","musicinfo_tracktitle")],[SYNO.SDS.MediaServer.MUSICINFO_TITLEALBUM,this.ns._M("browsing","musicinfo_titlealbum")],[SYNO.SDS.MediaServer.MUSICINFO_TITLEARTIST,this.ns._M("browsing","musicinfo_titleartist")],[SYNO.SDS.MediaServer.MUSICINFO_ARTISTALBUM,this.ns._M("browsing","musicinfo_artistalbum")]]},{xtype:"syno_combobox",name:"photo_sort_by",fieldLabel:this.ns._M("browsing","photo_sort_by"),store:[[SYNO.SDS.MediaServer.PHOTO_FILENAME,this.ns._M("browsing","filename")],[SYNO.SDS.MediaServer.PHOTO_TIMETAKEN,this.ns._M("browsing","photo_timetaken")]]},{xtype:"syno_combobox",name:"photo_sort_order",store:[[SYNO.SDS.MediaServer.PHOTO_SORT_ORDER_ASC,this.ns._M("browsing","sort_order_asc")],[SYNO.SDS.MediaServer.PHOTO_SORT_ORDER_DESC,this.ns._M("browsing","sort_order_desc")]]},{xtype:"syno_checkbox",name:"sendthumb",boxLabel:this.ns._M("browsing","service_mediaservice_sendthumb")},{xtype:"syno_displayfield",indent:1,value:this.ns._M("browsing","service_desc_mediaservice_sendthumb")},{xtype:"syno_checkbox",name:"cmzalbumart",boxLabel:this.ns._M("browsing","service_mediaservice_displaycover")},{xtype:"syno_displayfield",indent:1,value:this.ns._M("browsing","service_mediaservice_cmzalbumart")},{xtype:"syno_textfield",indent:1,name:"albumartlist",fieldLabel:this.ns._M("browsing","albumart_list_mediaservice")},{xtype:"syno_checkbox",boxLabel:this.ns._M("browsing","ebdvideoinfo_mediaservice"),name:"ebdvideoinfo"},{xtype:"syno_checkbox",boxLabel:this.ns._M("browsing","enable_inetradio"),name:"enableradio"},{xtype:"syno_compositefield",hideLabel:true,width:700,items:[{xtype:"syno_checkbox",name:"integrateVideoStation",boxLabel:this.ns._M("browsing","integrate_video_station"),id:this.integrateVS_ID=Ext.id()},{xtype:"syno_displayfield",name:"hint_for_enable_video_station",cls:"syno-mediaserver-hint-enable-video-station",id:this.hintEnableVideoStation_ID=Ext.id(),value:String.format('<span style="color:red ">({0})</span>',this.ns._M("browsing","desc_enable_video_station"))}]},{xtype:"syno_button",autoWidth:true,indent:1,text:this.ns._M("collection","video_station_collection"),scope:this,id:this.showVideoStationCollection_ID=Ext.id(),handler:this.launchVideoStationCollection}]}]};Ext.apply(b,a);return b},onPageActivate:function(){this.loadForm()},loadForm:function(){this.setStatusBusy({text:_T("common","loading")});this.owner.addAjaxTask({params:{action:"load_browsing_page"},single:true,autoJsonDecode:true,url:this.owner.getAbsoluteURL("cgi/mediaserv.cgi"),method:"POST",scope:this,success:function(a,b){this.clearStatusBusy();if(a.success&&a.data){this.OriSetting=a.data;this.blSupportVideoStation=this.OriSetting.support_video_station;this.blEnableVideoStation=this.OriSetting.video_station_enabled;this.getForm().setValues(this.OriSetting);this.displaySet()}else{this.owner.getMsgBox().alert(this.title,_T("common","error_system"))}},failure:function(a,b){this.clearStatusBusy();this.owner.getMsgBox().alert(this.title,_T("common","error_system"))}}).start()},displaySet:function(){var a=this.getForm();if(!this.blSupportVideoStation){SYNO.SDS.Utils.DisplayField(a,"integrateVideoStation",false);SYNO.SDS.Utils.DisplayField(a,"hint_for_enable_video_station",false);Ext.getCmp(this.showVideoStationCollection_ID).setVisible(false)}else{if(this.blEnableVideoStation){Ext.getCmp(this.hintEnableVideoStation_ID).setVisible(false)}if(this.OriSetting.integrateVideoStation){Ext.getCmp(this.showVideoStationCollection_ID).setDisabled(false)}else{Ext.getCmp(this.showVideoStationCollection_ID).setDisabled(true)}if(!this.blEnableVideoStation&&!this.OriSetting.integrateVideoStation){Ext.getCmp(this.integrateVS_ID).disable()}}},checkDirty:function(){if(this.getForm().isDirty()){return true}return false},onApply:function(){if(!this.checkDirty()){this.setStatusError({text:_T("error","nochange_subject"),clear:true});return}if(!this.getForm().isValid()){this.setStatusError({text:_T("common","forminvalid"),clear:true});return}this.applyForm()},applyForm:function(){this.setStatusBusy({text:_T("common","saving")});var a=this.getForm();var b={action:"save_browsing_page"};Ext.apply(b,a.getValues());this.TmpSetting=a.getValues();this.owner.addAjaxTask({single:true,autoJsonDecode:true,url:this.owner.getAbsoluteURL("cgi/mediaserv.cgi"),params:b,method:"POST",scope:this,success:function(c,d){this.clearStatusBusy();if(c.success){this.setStatusOK();this.OriSetting=this.TmpSetting;this.getForm().setValues(this.OriSetting);this.displaySet()}else{this.owner.getMsgBox().alert(this.title,_T("error","error_unknown"))}},failure:function(c,d){this.clearStatusBusy();this.owner.getMsgBox().alert(this.title,_T("error","error_unknown"))}}).start()},onCancel:function(){this.getForm().setValues(this.OriSetting)},launchVideoStationCollection:function(){var a=new SYNO.SDS.MediaServer.CollectionDialog({owner:this.owner,module:this.module,url:this.owner.getAbsoluteURL("cgi/mediaserv.cgi")});a.show()}});Ext.namespace("SYNO.SDS.MediaServer");Ext.apply(SYNO.SDS.MediaServer,{TEMPLATE_SIMPLE:"simple",TEMPLATE_IPOD:"ipod",TEMPLATE_ADVANCE:"advance",TEMPLATE_CUSTOM:"custom1",TEMPLATE_CUSTOM2:"custom2",TEMPLATE_CUSTOM3:"custom3",MUSICINFO_TITLE:"title",MUSICINFO_TRACKTITLE:"tracktitle",MUSICINFO_TITLEALBUM:"titlealbum",MUSICINFO_TITLEARTIST:"titleartist",MUSICINFO_ARTISTALBUM:"artistalbum",PHOTO_FILENAME:"filename",PHOTO_TIMETAKEN:"timetaken",PHOTO_SORT_ORDER_ASC:"asc",PHOTO_SORT_ORDER_DESC:"desc"});SYNO.SDS.MediaServer.AppInstance=Ext.extend(SYNO.SDS.AppInstance,{appWindowName:"SYNO.SDS.MediaServer.AppWindow",constructor:function(){SYNO.SDS.MediaServer.AppInstance.superclass.constructor.apply(this,arguments)}});Ext.define("SYNO.SDS.MediaServer.AppWindow",{extend:"SYNO.SDS.PageListAppWindow",activePage:"SYNO.SDS.MediaServer.GeneralPanel",constructor:function(a){this.ns=SYNO.SDS.MediaServer;var b=[{iconCls:"icon-general",text:this.ns._M("customize","generic_setting"),fn:"SYNO.SDS.MediaServer.GeneralPanel",help:"application_mediaserver_general.html"},{iconCls:"icon-browsing",text:this.ns._M("browsing","sendthumb_label"),fn:"SYNO.SDS.MediaServer.BrowsingPanel",help:"application_mediaserver_browse.html"},{iconCls:"icon-dma",text:this.ns._M("compatibility","transcoder_label"),fn:"SYNO.SDS.MediaServer.DMACompatibilityPanel",help:"application_mediaserver_dma.html"}];var c=Ext.apply({cls:"syno-mediaserver-app",maximizable:true,minimizable:true,width:950,height:580,minWidth:950,minHeight:360,listItems:b});Ext.apply(c,a);this.callParent([c])},getAbsoluteURL:function(a){return String.format("{0}/{1}",this.jsConfig.jsBaseURL,a)}});Ext.namespace("SYNO.SDS.MediaServer");Ext.define("SYNO.SDS.MediaServer.DMACompatibilityPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(a){this.ns=SYNO.SDS.MediaServer;this.owner=a.appWin;this.module=a.module;var b=this.fillConfig(a);this.callParent([b])},initEvents:function(){this.callParent(arguments);this.mon(this,"afterrender",function(a){var b;b=new SYNO.SDS.Utils.EnableCheckGroup(a.getForm(),"cmzmimetype",["mimetypelist"]);b=new SYNO.SDS.Utils.EnableCheckGroup(a.getForm(),"videotranscoding",["videoextlist"])},this)},fillConfig:function(a){var b={id:this.dmaTabId=Ext.id(),itemId:"dma",trackResetOnLoad:true,fieldWidth:320,labelWidth:249,hideMode:"offsets",buttons:[{xtype:"syno_button",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","commit"),btnStyle:"blue",scope:this,handler:this.onApply},{xtype:"syno_button",text:_T("common","reset"),scope:this,handler:this.onCancel}],items:[{xtype:"syno_fieldset",title:this.ns._M("compatibility","transcoder_label"),items:[{xtype:"syno_checkbox",boxLabel:this.ns._M("compatibility","enable_audio_transcoding"),name:"opttranscoding",scope:this,handler:this.transcodingClickHandler},{xtype:"syno_displayfield",indent:1,value:this.ns._M("compatibility","service_desc_mediaservice_transcoder")},{xtype:"syno_compositefield",indent:1,hideLabel:true,items:[{xtype:"syno_checkbox",boxLabel:this.ns._M("compatibility","downsampling_for_audio_transcoding"),name:"downsample_audio_transcoding",scope:this,disabled:true,handler:this.transcodingClickHandler}]},{xtype:"syno_compositefield",name:"grptranscoding",indent:1,hideLabel:true,width:400,items:[{xtype:"syno_checkbox",boxLabel:String.format('<span ext:qtip="*.flac *.ape">FLAC/APE</span>'),width:100,name:"flactranscoding",scope:this,handler:this.transcodingClickHandler},{xtype:"syno_checkbox",boxLabel:String.format('<span ext:qtip="*.aac *.m4a *.m4b">ALAC/AAC</span>'),width:100,name:"aactranscoding",scope:this,handler:this.transcodingClickHandler},{xtype:"syno_checkbox",boxLabel:String.format('<span ext:qtip="*.ogg">OGG</span>'),width:60,name:"oggtranscoding",scope:this,handler:this.transcodingClickHandler},{xtype:"syno_checkbox",boxLabel:String.format('<span ext:qtip="*.aiff *.aif">AIFF</span>'),name:"aifftranscoding",scope:this,handler:this.transcodingClickHandler}]},{xtype:"syno_checkbox",boxLabel:this.ns._M("compatibility","enable_video_transcoding"),name:"videotranscoding"},{xtype:"syno_displayfield",indent:1,name:"desc_video_transcoder",value:this.ns._M("compatibility","service_desc_mediaservice_transcoder")},{xtype:"syno_textfield",indent:1,fieldLabel:this.ns._M("compatibility","file_ext"),name:"videoextlist",emptyText:"rm;rmvb;mkv",validator:function(e){if(Ext.isEmpty(e.trim())){return false}var d=e.split(";");for(var c=0;c<d.size();c++){if("dvr-ms"===d[c]){continue}if(-1==d[c].search(/^[a-zA-Z0-9]+$/)){return false}}return true}},{xtype:"syno_checkbox",boxLabel:this.ns._M("compatibility","service_mediaservice_cmzmimetype"),name:"cmzmimetype"},{xtype:"syno_displayfield",indent:1,value:this.ns._M("compatibility","service_desc_mediaservice_cmzmimetype")},{xtype:"syno_textfield",indent:1,fieldLabel:this.ns._M("compatibility","mimetype_list_mediaservice"),name:"mimetypelist",scope:this,validator:this.mimeTypeValidator.createDelegate(this)},{xtype:"syno_displayfield",height:10},{xtype:"syno_displayfield",value:this.ns._M("compatibility","customize_device_behavior")},{xtype:"syno_checkbox",boxLabel:this.ns._M("compatibility","disable_access_right_for_dma"),name:"disable_access_right"},{xtype:"syno_button",text:this.ns._M("button","btn_devicelist"),indent:1,scope:this,id:this.DMAListBtnId=Ext.id(),handler:this.launchDMAListDialog}]}]};Ext.apply(b,a);return b},mimeTypeValidator:function(c){var e=c.split(",");for(var d=0,a=e.length;d<a;d++){if(e[d]===""){continue}var b=e[d].split("=");if(b.length<2||b[0]===""||b[1]===""){return this.ns._M("compatibility","mimetype_list_alert_mediaservice")}}return true},launchDMAListDialog:function(){var a=new SYNO.SDS.MediaServer.DMAListDialog({owner:this.owner,module:this.module,url:this.owner.getAbsoluteURL("cgi/mediaserv.cgi")});a.show()},onPageActivate:function(){this.loadForm()},loadForm:function(){this.setStatusBusy({text:_T("common","loading")});this.owner.addAjaxTask({params:{action:"load_dma_page"},single:true,autoJsonDecode:true,url:this.owner.getAbsoluteURL("cgi/mediaserv.cgi"),method:"POST",scope:this,success:function(a,b){this.clearStatusBusy();if(a.success&&a.data){this.OriSetting=a.data;this.blSupportVTE=this.OriSetting.support_video_transcoding;this.getForm().setValues(this.OriSetting);this.displaySet()}else{this.owner.getMsgBox().alert(this.title,_T("common","error_system"))}},failure:function(a,b){this.clearStatusBusy();this.owner.getMsgBox().alert(this.title,_T("common","error_system"))}}).start()},displaySet:function(){var a=this.getForm();if(!this.blSupportVTE){SYNO.SDS.Utils.DisplayField(a,"videotranscoding",false);SYNO.SDS.Utils.DisplayField(a,"videoextlist",false);SYNO.SDS.Utils.DisplayField(a,"desc_video_transcoder",false)}},checkDirty:function(){if(this.getForm().isDirty()){return true}return false},onApply:function(){if(!this.checkDirty()){this.setStatusError({text:_T("error","nochange_subject"),clear:true});return}if(!this.getForm().isValid()){this.setStatusError({text:_T("common","forminvalid"),clear:true});return}this.applyForm()},onCancel:function(){this.getForm().setValues(this.OriSetting)},applyForm:function(){this.setStatusBusy({text:_T("common","saving")});var a=this.getForm();var b={action:"save_dma_page"};Ext.apply(b,a.getValues());this.TmpSetting=a.getValues();this.owner.addAjaxTask({single:true,autoJsonDecode:true,url:this.owner.getAbsoluteURL("cgi/mediaserv.cgi"),params:b,method:"POST",scope:this,success:function(c,d){this.clearStatusBusy();if(c.success){this.setStatusOK();this.OriSetting=this.TmpSetting;this.getForm().setValues(this.OriSetting)}else{this.owner.getMsgBox().alert(this.title,_T("error","error_unknown"))}},failure:function(c,d){this.clearStatusBusy();this.owner.getMsgBox().alert(this.title,_T("error","error_unknown"))}}).start()},transcodingClickHandler:function(d,c){var b=this.getForm();var e=b.findField("grptranscoding");var a=false;if(this.inTranscodingClickHandler||!e.rendered){return}this.inTranscodingClickHandler=true;if(d.name==="opttranscoding"){e.items.each(function(f){f.setValue(c)},this);b.findField("downsample_audio_transcoding").setDisabled(!c);if(!c){b.findField("downsample_audio_transcoding").setValue(false)}}else{e.items.each(function(f){if(f.getValue()){a=true;return false}},this);b.findField("opttranscoding").setValue(a);b.findField("downsample_audio_transcoding").setDisabled(!a);if(!a){b.findField("downsample_audio_transcoding").setValue(false)}}this.inTranscodingClickHandler=false}});