#!/bin/sh

#include common scripts
FILE_MEDIASERVER_INC_SCRIPT=/var/packages/MediaServer/target/scripts/MediaServerCommon.sh
if [ ! -f ${FILE_MEDIASERVER_INC_SCRIPT} ]; then
	exit 1;
fi
. ${FILE_MEDIASERVER_INC_SCRIPT}

#At begining, acquire package settings
PackageInfoGet;

case $1 in
	--sdk-mod-ver)
		#print SDK support version
		echo ${MEDIASERVER_PKG_MODVER};
	;;
	--name)
		#print package name
		echo ${MEDIASERVER_PKG_NAME};
	;;
	--vendor)
		#printf package vendor
		echo ${MEDIASERVER_PKG_VENDOR};
	;;
	--post)
		PackageEnableGet;
		if [ "1" = "${MEDIASERVER_PKG_ENABLE}" ]; then
			MediaServerRestart;
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
