#!/bin/sh

###############################################################
#   This script should be hooked when interface name changed
#   Usable environment variable:
#      ORIGIN_IFNAME_NUM ORIGIN_IFNAME_1 ... ORIGIN_IFNAME_N
#      IFNAME_NUM IFNAME_1 ... IFNAME_N
#      RESULT
#
###############################################################

#include common scripts
FILE_MEDIASERVER_INC_SCRIPT=/var/packages/MediaServer/target/scripts/MediaServerCommon.sh
if [ ! -f ${FILE_MEDIASERVER_INC_SCRIPT} ]; then
	exit 1;
fi
. ${FILE_MEDIASERVER_INC_SCRIPT}

#At begining, acquire package settings
PackageInfoGet;

#dmsvlan binary path
DMSVLAN=/var/packages/MediaServer/target/sbin/dmsvlan

case $1 in
	--sdk-mod-ver)
		#print SDK support version
		echo ${MEDIASERVER_PKG_NETIFNAMEVER};
	;;
	--name)
		#print package name
		echo ${MEDIASERVER_PKG_NAME};
	;;
	--vendor)
		#printf package vendor
		echo ${MEDIASERVER_PKG_VENDOR};
	;;
	--pre)
	;;
	--post)
		#Check if package enable
		PackageEnableGet;
		if [ "1" = "${MEDIASERVER_PKG_ENABLE}" ]; then
			#Check action success or not
			if [ "0" != "${RESULT}" ]; then
				exit 0;
			fi

			if [ "${ORIGIN_IFNAME_NUM}" != "${IFNAME_NUM}" ]; then
				exit 0;
			fi

			if [ 1 -ne "${IFNAME_NUM}" ]; then
				exit 0;
			fi

			${DMSVLAN} --change-interface-name ${ORIGIN_IFNAME_1} ${IFNAME_1}
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
