#!/bin/sh

ChrootDir="/var/packages/ProxyServer/target/squid"
BinDir="/var/packages/ProxyServer/target/bin"
LOGDir=${ChrootDir}"/var/logs/"

${BinDir}/squid -z
CACHE_REBUILD_RETRY="30"
while [ "0" -lt "`/usr/bin/ps -ef | /usr/bin/grep -v grep | /usr/bin/grep "squid.*-z" | /usr/bin/wc -l`" ]; do
	if [ "0" -gt "$CACHE_REBUILD_RETRY" ]; then
		echo "Time out: Squid cache rebuild script fail!\n" >> $LOGDir/error.log
		exit 1
	fi
	sleep 1
	CACHE_REBUILD_RETRY="$(($CACHE_REBUILD_RETRY - 1))"
done

